/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"image", "status", "parentUser", "linkedUser", "linkedUsersIfExists", "currentCashDrawer", "activeDrawerPullReport", "type", "currentShift", "manager", "administrator"})
@XmlRootElement(name="user")
public class User
extends BaseUser
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    public static final String USER_TYPE_MANAGER = Messages.getString("User.0");
    public static final String USER_TYPE_CASHIER = Messages.getString("User.1");
    public static final String USER_TYPE_SERVER = Messages.getString("User.2");
    private CashDrawer currentCashDrawer;

    public User() {
    }

    public User(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public UserType getType() {
        String string = this.getUserTypeId();
        if (string != null) {
            return DataProvider.get().getUserType(string);
        }
        return null;
    }

    public void setType(UserType userType) {
        if (userType != null) {
            super.setUserTypeId(userType.getId());
        } else {
            super.setUserTypeId(null);
        }
    }

    @XmlTransient
    public Shift getCurrentShift() {
        return DataProvider.get().getShiftById(this.getCurrentShiftId());
    }

    public void setCurrentShift(Shift shift) {
        if (shift != null) {
            super.setCurrentShiftId(shift.getId());
        } else {
            super.setCurrentShiftId(null);
        }
    }

    @Override
    public Boolean isActive() {
        return super.isActive() == null ? Boolean.TRUE : super.isActive();
    }

    public boolean hasPermission(UserPermission userPermission) {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().hasPermission(userPermission);
    }

    @XmlTransient
    public CashDrawer getCurrentCashDrawer() {
        if (this.currentCashDrawer != null && this.currentCashDrawer.getId().equals(super.getCurrentCashDrawerId())) {
            return this.currentCashDrawer;
        }
        String string = super.getCurrentCashDrawerId();
        if (StringUtils.isNotEmpty((String)string)) {
            this.currentCashDrawer = CashDrawerDAO.getInstance().get(string);
        }
        return this.currentCashDrawer;
    }

    public void setCurrentCashDrawer(CashDrawer cashDrawer) {
        this.currentCashDrawer = cashDrawer;
        this.setCurrentCashDrawerId(cashDrawer == null ? null : cashDrawer.getId());
    }

    @Override
    public String getCurrentCashDrawerId() {
        if (this.currentCashDrawer != null && StringUtils.isNotEmpty((String)this.currentCashDrawer.getId())) {
            return this.currentCashDrawer.getId();
        }
        return super.getCurrentCashDrawerId();
    }

    @XmlTransient
    public CashDrawer getActiveDrawerPullReport() {
        CashDrawer cashDrawer = this.getCurrentCashDrawer();
        if (cashDrawer != null) {
            return cashDrawer;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null) {
            return terminal.getCurrentCashDrawer();
        }
        return null;
    }

    public void doClockIn(Terminal terminal, Shift shift, Calendar calendar) {
        UserDAO.getInstance().refresh(this);
        if (this.isClockedIn().booleanValue()) {
            throw new PosException(Messages.getString("User.3") + this.getFullName());
        }
        List<User> list = this.getLinkedUser();
        if (list != null) {
            for (User user : list) {
                if (!user.isClockedIn().booleanValue()) continue;
                throw new PosException(Messages.getString("User.3") + this.getFullName());
            }
        }
        this.setClockedIn(true);
        this.setCurrentShift(shift);
        this.setLastClockInTime(calendar.getTime());
        if (this.isDriver().booleanValue()) {
            this.setAvailableForDelivery(true);
        }
        AttendenceHistory attendenceHistory = new AttendenceHistory();
        attendenceHistory.setClockInTime(calendar.getTime());
        attendenceHistory.setClockInHour((short)calendar.get(11));
        attendenceHistory.setUser(this);
        attendenceHistory.setTerminal(terminal);
        attendenceHistory.setShift(shift);
        UserDAO.getInstance().saveClockIn(this, attendenceHistory, shift, calendar);
    }

    public void doClockOut(AttendenceHistory attendenceHistory, Shift shift, Calendar calendar) {
        this.setClockedIn(false);
        this.setCurrentShift(null);
        this.setLastClockInTime(null);
        this.setLastClockOutTime(null);
        if (this.isDriver().booleanValue()) {
            this.setAvailableForDelivery(false);
        }
        attendenceHistory.setClockedOut(true);
        attendenceHistory.setClockOutTime(calendar.getTime());
        attendenceHistory.setClockOutHour((short)calendar.get(11));
        UserDAO.getInstance().saveClockOut(this, attendenceHistory, shift, calendar);
    }

    public boolean canViewAllOpenTickets() {
        if (this.getType() == null) {
            return false;
        }
        Set<UserPermission> set = this.getType().getPermissions();
        if (set == null) {
            return false;
        }
        for (UserPermission userPermission : set) {
            if (!userPermission.equals(UserPermission.EDIT_OTHER_USERS_TICKETS)) continue;
            return true;
        }
        return false;
    }

    public boolean canViewAllCloseTickets() {
        if (this.getType() == null) {
            return false;
        }
        Set<UserPermission> set = this.getType().getPermissions();
        if (set == null) {
            return false;
        }
        for (UserPermission userPermission : set) {
            if (!userPermission.equals(UserPermission.EDIT_OTHER_USERS_TICKETS)) continue;
            return true;
        }
        return false;
    }

    public void setFullName(String string) {
    }

    public String getStatus() {
        if (this.isClockedIn().booleanValue()) {
            if (this.isAvailableForDelivery().booleanValue()) {
                return Messages.getString("User.5");
            }
            return Messages.getString("User.6");
        }
        return Messages.getString("User.7");
    }

    public String getFullName() {
        String string = "";
        if (StringUtils.isNotEmpty((String)this.getFirstName())) {
            string = this.getFirstName() + " ";
        }
        if (StringUtils.isNotEmpty((String)this.getLastName())) {
            string = string + this.getLastName();
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    @XmlTransient
    public boolean isManager() {
        return this.hasPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    @XmlTransient
    public boolean isAdministrator() {
        return this.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK);
    }

    public void setImage(ImageIcon imageIcon) {
    }

    @XmlTransient
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonBigImage();
        }
        return null;
    }

    @XmlTransient
    public User getParentUser() {
        String string = super.getParentUserId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return DataProvider.get().getUserById(string);
    }

    public void setParentUser(User user) {
        if (user != null) {
            this.setParentUserId(user.getId());
        } else {
            this.setParentUserId(null);
        }
    }

    public boolean hasLinkedUser() {
        List<User> list = this.getLinkedUser();
        if (list != null && list.size() > 0) {
            return true;
        }
        if (this.getParentUser() == null) {
            return false;
        }
        return this.getParentUser().hasLinkedUser();
    }

    public List<User> getLinkedUsersIfExists() {
        List<User> list = this.getLinkedUser();
        if (list != null) {
            if (!list.contains(this)) {
                list.add(0, this);
            }
            return list;
        }
        if (this.getParentUser() == null) {
            return null;
        }
        return this.getParentUser().getLinkedUsersIfExists();
    }

    public void setEncryptedPassword(String string) {
        try {
            super.setPassword(AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @JsonIgnoreProperties
    public String getPasswordAsPlainText() {
        String string = super.getPassword();
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                return AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

