/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DateUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class GenericDAO
extends _RootDAO {
    private static final GenericDAO instance = new GenericDAO();

    public static GenericDAO getInstance() {
        return instance;
    }

    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object object) {
        return super.save(object);
    }

    @Override
    public void saveOrUpdate(Object object) {
        super.saveOrUpdate(object);
    }

    @Override
    public Serializable save(Object object, Session session) {
        return super.save(object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) {
        super.saveOrUpdate(object, session);
    }

    @Override
    public Session getSession(String string, boolean bl) {
        return super.getSession(string, bl);
    }

    public List findAll(Class clazz, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        return criteria.list();
    }

    public void saveAll(List list, Session session) {
        Transaction transaction = session.beginTransaction();
        for (Object e : list) {
            session.saveOrUpdate(e);
        }
        transaction.commit();
    }

    @Override
    public void closeSession(Session session) {
        try {
            super.closeSession(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List findAllUnSyncItem(Class clazz) {
        return this.findAllUnSyncItem(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllUnSyncItem(Class clazz, boolean bl) {
        Session session = null;
        try {
            Object object;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(clazz);
            if (!bl) {
                object = Restrictions.isNull((String)InventoryStock.PROP_LAST_UPDATE_TIME);
                Criterion criterion = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
                PropertyExpression propertyExpression = Restrictions.gtProperty((String)InventoryStock.PROP_LAST_UPDATE_TIME, (String)InventoryStock.PROP_LAST_SYNC_TIME);
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{object, criterion, propertyExpression}));
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            object = criteria.list();
            return object;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateItemsLastSyncTime(List<String> list, String string) {
        String string2;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string3 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string2 = transaction.next();
            string3 = string3 + "'" + string2 + "'";
            if (!transaction.hasNext()) continue;
            string3 = string3 + ",";
        }
        string3 = string3 + ")";
        transaction = null;
        string2 = null;
        try {
            string2 = this.getSession();
            transaction = string2.beginTransaction();
            String string4 = "update " + string + " set %s=:lastSyncTime where %s in %s";
            string4 = String.format(string4, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID, string3);
            Query query = string2.createQuery(string4);
            Date date = new Date();
            query.setParameter("lastSyncTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string2);
        }
    }

    public void updateItemsLastSyncTimeByInt(List<Integer> list, String string) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            int n = transaction.next();
            string2 = string2 + n;
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string3 = "update " + string + " set %s=:lastSyncTime where %s in" + string2;
            string3 = String.format(string3, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID);
            Query query = session.createQuery(string3);
            Date date = new Date();
            query.setParameter("lastSyncTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void updateLastUpdateTimeIfNull(String string) {
        Calendar calendar = Calendar.getInstance();
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string2 = "update " + string + " set %s=:lastUpdateTime where %s is null";
            string2 = String.format(string2, Terminal.PROP_LAST_UPDATE_TIME, Terminal.PROP_LAST_UPDATE_TIME);
            Query query = session.createQuery(string2);
            query.setParameter("lastUpdateTime", (Object)calendar.getTime());
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), "Failed to update last update time where last update time is null");
        }
    }

    public void checkIdOrNameExists(String string, String string2, Class clazz) {
        if (StringUtils.isBlank((String)string2)) {
            throw new PosException("Name is empty");
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)string2));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.ne((String)"id", (Object)string));
            }
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                throw new PosException(String.format("The name %s is not available.", string2));
            }
        }
    }

    public void updateLastUpdateTimeProperty(Class clazz, Date date) {
        Store store = StoreDAO.getRestaurant();
        store.addProperty(clazz.getSimpleName() + "." + Store.PROP_LAST_UPDATE_TIME, DateUtil.formatDateWithDefaultTimeAndSec(date));
        StoreDAO.getInstance().saveOrUpdate(store);
    }

    private void updateLastSyncTime(String string) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            String string2 = "update " + string + " set %s=:lastSyncTime";
            string2 = String.format(string2, InventoryStock.PROP_LAST_SYNC_TIME);
            Query query = session.createQuery(string2);
            query.setParameter("lastSyncTime", null);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String string, String string2) {
        return this.getForeignDataList(session, clazz, string, string2, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String string, String string2, String string3) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection((Projection)Projections.property((String)string3));
        criteria.add((Criterion)Restrictions.eq((String)string, (Object)string2));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String string, String string2, String string3) {
        return this.getForeignDataList(session, clazz, string, string2, string3, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String string, String string2, String string3, String string4) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.createAlias(string, "c");
        criteria.setProjection((Projection)Projections.property((String)string4));
        criteria.add((Criterion)Restrictions.eq((String)("c." + string2), (Object)string3));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }
}

