/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryDepartment;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.BaseInventoryLocationDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.StockCountItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class InventoryLocationDAO
extends BaseInventoryLocationDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public void delete(Object object, Session session) {
        InventoryLocation inventoryLocation = (InventoryLocation)object;
        if (inventoryLocation == null) {
            throw new PosException(Messages.getString("InventoryLocationDAO.0"));
        }
        this.checkForeignRelation(inventoryLocation, session);
        inventoryLocation.setParentLocation(null);
        inventoryLocation.setDeleted(true);
        this.update(inventoryLocation, session);
    }

    private void checkForeignRelation(InventoryLocation inventoryLocation, Session session) throws PosException {
        String string;
        List<PurchaseOrder> list;
        String string2 = inventoryLocation.getId();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List<InventoryLocation> list2 = inventoryLocation.getChildren();
        if (list2 != null && !list2.isEmpty()) {
            stringBuilder.append(Messages.getString("InventoryLocationDAO.1") + ", ");
            stringBuilder2.append(this.constructExceptionDetailsByInventoryLocations(inventoryLocation, list2));
            stringBuilder2.append("\n \n");
        }
        this.append(genericDAO.getForeignDataList(session, InventoryStock.class, InventoryStock.PROP_LOCATION_ID, string2, InventoryStock.PROP_ITEM_NAME), Messages.getString("InventoryLocationDAO.3"), stringBuilder, stringBuilder2);
        this.append(genericDAO.getForeignDataListNames(session, InventoryDepartment.class, "locations", InventoryDepartment.PROP_ID, string2), Messages.getString("InventoryLocationDAO.4"), stringBuilder, stringBuilder2);
        List<StockCountItem> list3 = StockCountItemDAO.getInstance().getStockCountItemByInvLocation(inventoryLocation, session);
        if (list3 != null && !list3.isEmpty()) {
            stringBuilder.append(Messages.getString("InventoryLocationDAO.5") + ",");
            stringBuilder2.append(this.constructExceptionDetailsByStockCountItems(inventoryLocation, list3));
            stringBuilder2.append("\n \n");
        }
        if ((list = PurchaseOrderDAO.getInstance().getPurchaseOrderByInvLocation(inventoryLocation, session)) != null && !list.isEmpty()) {
            stringBuilder.append(Messages.getString("InventoryLocationDAO.6"));
            stringBuilder2.append(this.constructExceptionDetailsByPurchaseOrders(inventoryLocation, list));
            stringBuilder2.append("\n");
        }
        if (StringUtils.isNotBlank((String)(string = stringBuilder2.toString()))) {
            String string3 = stringBuilder.toString();
            if (string3.endsWith(", ")) {
                string3 = string3.substring(0, string3.length() - 2);
            }
            StringBuilder stringBuilder3 = new StringBuilder();
            String string4 = stringBuilder3.append(Messages.getString("InventoryLocationDAO.7")).append(string3).append(". ").append("\n").append(Messages.getString("InventoryLocationDAO.8")).toString();
            throw new PosException(string4, string);
        }
    }

    private void append(List<String> list, String string, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        stringBuilder2.append(Messages.getString("InventoryLocationDAO.9") + string + ":");
        stringBuilder.append(string + ", ");
        int n = 1;
        for (String string2 : list) {
            stringBuilder2.append("\n" + n + ". " + string2);
            ++n;
        }
        stringBuilder2.append("\n \n");
    }

    private String constructExceptionDetailsByStockCountItems(InventoryLocation inventoryLocation, List<StockCountItem> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(Messages.getString("InventoryLocationDAO.9") + Messages.getString("InventoryLocationDAO.11"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append("\n ").append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByPurchaseOrders(InventoryLocation inventoryLocation, List<PurchaseOrder> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(Messages.getString("InventoryLocationDAO.9") + Messages.getString("InventoryLocationDAO.13"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getId();
                stringBuilder.append("\n").append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByInventoryLocations(InventoryLocation inventoryLocation, List<InventoryLocation> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(Messages.getString("InventoryLocationDAO.14") + Messages.getString("InventoryLocationDAO.15"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append("\n").append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public List<InventoryLocation> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)InventoryLocation.PROP_NAME));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryLocation initialize(InventoryLocation inventoryLocation) {
        if (inventoryLocation == null || inventoryLocation.getId() == null) {
            return inventoryLocation;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryLocation);
            Hibernate.initialize(InventoryLocation.class);
            InventoryLocation inventoryLocation2 = inventoryLocation;
            return inventoryLocation2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public InventoryLocation getRootLocation() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ROOT, (Object)true));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
                return inventoryLocation;
            }
            InventoryLocation inventoryLocation = null;
            return inventoryLocation;
        }
    }

    public List<InventoryLocation> getRootLocations() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ROOT, (Object)true));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InventoryLocation getDefaultInInventoryLocation() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_IN_LOCATION, (Object)true));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                InventoryLocation inventoryLocation2 = null;
                return inventoryLocation2;
            }
            InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
            return inventoryLocation;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InventoryLocation getDefaultOutInventoryLocation() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_OUT_LOCATION, (Object)true));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                InventoryLocation inventoryLocation2 = null;
                return inventoryLocation2;
            }
            InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
            return inventoryLocation;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
            return null;
        }
    }

    public InventoryLocation getDefaultOutInventoryLocation(Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_OUT_LOCATION, (Object)true));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.setMaxResults(1);
            return (InventoryLocation)criteria.uniqueResult();
        }
        return (InventoryLocation)list.get(0);
    }

    public InventoryLocation getDefaultInInventoryLocation(Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_IN_LOCATION, (Object)true));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.setMaxResults(1);
            return (InventoryLocation)criteria.uniqueResult();
        }
        return (InventoryLocation)list.get(0);
    }

    public void saveOrUpdateInventoryLocation(List<InventoryLocation> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (InventoryLocation inventoryLocation : list) {
                InventoryLocation inventoryLocation2 = this.get(inventoryLocation.getId());
                if (inventoryLocation2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(inventoryLocation.getLastUpdateTime(), inventoryLocation2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), inventoryLocation.getName() + " already updated");
                        continue;
                    }
                    long l = inventoryLocation2.getVersion();
                    List<InventoryLocation> list2 = inventoryLocation2.getChildren();
                    PropertyUtils.copyProperties((Object)inventoryLocation2, (Object)inventoryLocation);
                    inventoryLocation2.setVersion(l);
                    inventoryLocation2.setChildren(list2);
                    inventoryLocation2.setUpdateLastUpdateTime(bl);
                    inventoryLocation2.setUpdateSyncTime(bl2);
                    this.update(inventoryLocation2, session);
                    continue;
                }
                inventoryLocation.setUpdateLastUpdateTime(bl);
                inventoryLocation.setUpdateSyncTime(bl2);
                this.save(inventoryLocation, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }
}

