/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BasePurchaseOrderItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PurchaseOrderItemDAO
extends BasePurchaseOrderItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(InventoryVendor inventoryVendor) {
        ArrayList<MenuItem> arrayList;
        Session session = null;
        Criteria criteria = null;
        try {
            ArrayList<MenuItem> arrayList2 = new ArrayList<MenuItem>();
            session = this.getSession();
            criteria = session.createCriteria(PurchaseOrderItem.class);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)PurchaseOrderItem.PROP_MENU_ITEM_ID)));
            criteria.createAlias(PurchaseOrderItem.PROP_PURCHASE_ORDER, "p");
            criteria.add((Criterion)Restrictions.eq((String)"p.vendor", (Object)inventoryVendor));
            List list = criteria.list();
            if (list != null) {
                for (Integer n : list) {
                    MenuItem menuItem = MenuItemDAO.getInstance().getReplenishedMenuItem(n, session);
                    if (menuItem == null) continue;
                    arrayList2.add(menuItem);
                }
            }
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return arrayList;
    }

    public void loadCustomers(PurchaseOrderItem purchaseOrderItem) {
        if (purchaseOrderItem == null || purchaseOrderItem.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(purchaseOrderItem.getCustomers())) {
            return;
        }
        Session session = this.createNewSession();
        try {
            session.refresh((Object)purchaseOrderItem);
            Hibernate.initialize(purchaseOrderItem.getCustomers());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeCustomers(PurchaseOrderItem purchaseOrderItem) {
        try (Session session = null;){
            session = this.createNewSession();
            session.refresh((Object)purchaseOrderItem);
            if (!Hibernate.isInitialized(purchaseOrderItem.getCustomers())) {
                Hibernate.initialize(purchaseOrderItem.getCustomers());
            }
        }
    }
}

