/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.OpenTicketSummaryReport;
import com.floreantpos.report.Report;
import com.floreantpos.report.VoidItemReport;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public class ReportViewer
extends JPanel {
    private JButton a;
    private JButton b;
    private JLabel c;
    private JComboBox d;
    private JXDatePicker e;
    private JXDatePicker f;
    private JComboBox<Date> g;
    private JComboBox<Date> h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JCheckBox l;
    private JCheckBox m;
    private JLabel n;
    private JComboBox o;
    private JLabel p;
    private JComboBox<OrderType> q;
    private TransparentPanel r;
    private TransparentPanel s;
    private TransparentPanel t;
    private Report u;
    private MultiSelectComboBox<MenuGroup> v;

    public ReportViewer() {
        this.a();
    }

    public ReportViewer(Report report) {
        this.a();
        this.v.setItems(MenuGroupDAO.getInstance().findAll());
        TerminalDAO terminalDAO = new TerminalDAO();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(0, POSConstants.ALL);
        List<Terminal> list = terminalDAO.findAll();
        for (Terminal terminal : list) {
            if (!terminal.isHasCashDrawer().booleanValue()) continue;
            arrayList.add(terminal);
        }
        this.d.setModel(new ListComboBoxModel(arrayList));
        this.setReport(report);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.r = new TransparentPanel(new BorderLayout());
        this.s = new TransparentPanel();
        this.s.setLayout((LayoutManager)new MigLayout("", "[][][]"));
        this.c = new JLabel(Messages.getString("ReportViewer.4"));
        this.k = new JLabel(Messages.getString("ReportViewer.3"));
        this.d = new JComboBox();
        this.d.setPreferredSize(new Dimension(115, 0));
        this.i = new JLabel(POSConstants.START_DATE + ":");
        this.f = UiUtil.getCurrentMonthStart();
        TimeComboBox timeComboBox = new TimeComboBox();
        this.g = timeComboBox.getDefaultTimeComboBox();
        this.h = timeComboBox.getDefaultTimeComboBox();
        this.j = new JLabel(POSConstants.END_DATE + ":");
        this.e = UiUtil.getCurrentMonthEnd();
        this.l = new JCheckBox(Messages.getString("ReportViewer.6"));
        this.m = new JCheckBox(Messages.getString("ReportViewer.5"));
        this.n = new JLabel(Messages.getString("ReportViewer.7"));
        this.o = new JComboBox();
        this.p = new JLabel(Messages.getString("ReportViewer.0"));
        this.q = new JComboBox();
        this.a = new JButton(Messages.getString("ReportViewer.2"));
        this.t = new TransparentPanel();
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportViewer.this.a(actionEvent);
            }
        });
        this.b = new JButton(Messages.getString("ReportViewer.8"));
        this.t = new TransparentPanel();
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportViewer.this.doClear(actionEvent);
            }
        });
        this.v = new MultiSelectComboBox();
        this.s.add(this.c);
        this.s.add(this.v, "split 8");
        this.s.add(this.k);
        this.s.add(this.d);
        this.s.add(this.i);
        this.s.add((Component)this.f);
        this.s.add(this.g);
        this.s.add(this.j);
        this.s.add((Component)this.e);
        this.s.add(this.h, "wrap");
        this.s.add(new JLabel(""));
        this.s.add((Component)this.l, "split 5");
        this.s.add(this.m);
        this.s.add(new JLabel(""));
        this.s.add(this.a);
        this.r.add((Component)this.s, "North");
        this.r.add((Component)new JSeparator(), "Center");
        this.t.setLayout(new BorderLayout());
        this.add((Component)this.r, "North");
        this.add((Component)this.t, "Center");
    }

    private void a(ActionEvent actionEvent) {
        Date date = this.f.getDate();
        Date date2 = this.e.getDate();
        Date date3 = (Date)this.g.getSelectedItem();
        Date date4 = (Date)this.h.getSelectedItem();
        if ((date = DateUtil.copyTime(date, date3)).after(date2 = DateUtil.copyTime(date2, date4))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        try {
            this.t.removeAll();
            this.t.revalidate();
            if (this.u != null) {
                UserType userType = null;
                if (this.o.getSelectedItem() instanceof UserType) {
                    userType = (UserType)this.o.getSelectedItem();
                }
                this.u.setUserType(userType);
                OrderType orderType = null;
                if (this.q.getSelectedItem() instanceof OrderType) {
                    orderType = (OrderType)this.q.getSelectedItem();
                }
                this.u.setOrderType(orderType);
                Terminal terminal = null;
                if (this.d.getSelectedItem() instanceof Terminal) {
                    terminal = (Terminal)this.d.getSelectedItem();
                }
                this.u.setMenuGroups(this.v.getSelectedItems());
                this.u.setTerminal(terminal);
                this.u.setStartDate(date);
                this.u.setEndDate(date2);
                this.u.setIncludeFreeItems(this.l.isSelected());
                this.u.setShowInGroups(this.m.isSelected());
                this.u.refresh();
                if (this.u != null && this.u.getViewer() != null) {
                    this.t.add((Component)this.u.getViewer());
                    this.t.revalidate();
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doClear(ActionEvent actionEvent) {
        if (this.u != null) {
            this.q.setSelectedIndex(0);
            this.o.setSelectedIndex(0);
            this.d.setSelectedIndex(0);
        }
    }

    public Report getReport() {
        return this.u;
    }

    public void setReport(Report report) {
        this.u = report;
        if (report instanceof VoidItemReport) {
            this.s.removeAll();
            this.s.add(this.k);
            this.s.add(this.d);
            this.s.add(this.i);
            this.s.add((Component)this.f);
            this.s.add(this.g);
            this.s.add(this.j);
            this.s.add((Component)this.e);
            this.s.add(this.h);
            this.s.add(this.a);
        }
        if (report instanceof OpenTicketSummaryReport) {
            this.s.removeAll();
            UserTypeDAO userTypeDAO = new UserTypeDAO();
            List<UserType> list = userTypeDAO.findAll();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(0, POSConstants.ALL);
            arrayList.addAll(list);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(0, POSConstants.ALL);
            arrayList2.addAll(OrderTypeDAO.getInstance().findAll());
            this.o.setModel(new ListComboBoxModel(arrayList));
            this.o.setPreferredSize(this.d.getPreferredSize());
            this.s.add(this.n);
            this.s.add(this.o);
            this.q.setModel(new ListComboBoxModel(arrayList2));
            this.q.setPreferredSize(this.d.getPreferredSize());
            this.s.add(this.p);
            this.s.add(this.q);
            this.s.add(this.i);
            this.s.add((Component)this.f);
            this.s.add(this.g);
            this.s.add(this.j);
            this.s.add((Component)this.e);
            this.s.add(this.h);
            this.s.add(this.k);
            this.s.add(this.d);
            this.s.add(new JLabel(""));
            this.s.add(this.a);
            this.s.add(this.b);
        }
    }
}

