/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class MultiCurrencyTenderDialog
extends OkCancelOptionDialog {
    private List<Currency> a;
    private double b;
    private double c;
    private double d;
    private List<CurrencyRow> e = new ArrayList<CurrencyRow>();
    private Ticket f;
    private List<PaymentByCurrency> g;

    public MultiCurrencyTenderDialog(Ticket ticket, List<Currency> list) {
        super(POSUtil.getFocusedWindow());
        this.f = ticket;
        this.a = list;
        this.b = ticket.getDueAmount();
        this.a();
    }

    public MultiCurrencyTenderDialog(List<Ticket> list, List<Currency> list2) {
        super(POSUtil.getFocusedWindow());
        this.a = list2;
        this.f = list.get(list.size() - 1);
        this.b = 0.0;
        for (Ticket ticket : list) {
            this.b += ticket.getDueAmount().doubleValue();
        }
        this.a();
    }

    public MultiCurrencyTenderDialog(Ticket ticket, List<Currency> list, double d) {
        super(POSUtil.getFocusedWindow());
        this.f = ticket;
        this.a = list;
        this.b = d;
        this.a();
    }

    private void a() {
        Object object;
        JPanel jPanel = this.getContentPanel();
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setTitle(Messages.getString("MultiCurrencyTenderDialog.0"));
        this.setCaption(Messages.getString("MultiCurrencyTenderDialog.1") + NumberUtil.getCurrencyFormat(this.b));
        this.setResizable(true);
        this.setMinimumSize(PosUIManager.getSize(730, 600));
        MigLayout migLayout = new MigLayout("inset 0", "[grow,fill]", "[grow,fill]");
        jPanel.setLayout((LayoutManager)migLayout);
        jPanel.setPreferredSize(PosUIManager.getSize(730, 500));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill,ins 0", "[fill][right]30px[120px,grow,fill,right][120px,grow,fill,right][][]", ""));
        jPanel2.add(this.a("Currency", 1, 16, 10));
        jPanel2.add((Component)this.a("Remaining", 1, 16, 0), "gapleft 20");
        jPanel2.add((Component)this.a("Tender", 1, 16, 11), "center");
        jPanel2.add((Component)this.a("Cash Back", 1, 16, 11), "center");
        for (Currency serializable2 : this.a) {
            object = new CurrencyRow(serializable2, this.b);
            jPanel2.add((Component)((CurrencyRow)object).f, "newline");
            jPanel2.add(((CurrencyRow)object).e);
            jPanel2.add((Component)((CurrencyRow)object).b, "grow");
            jPanel2.add((Component)((CurrencyRow)object).c, "grow");
            this.e.add((CurrencyRow)object);
        }
        PosScrollPane posScrollPane = new PosScrollPane(jPanel2);
        posScrollPane.setBorder(null);
        jPanel.add((Component)posScrollPane, "cell 0 2,alignx left,aligny top");
        NumericKeypad numericKeypad = new NumericKeypad();
        numericKeypad.setPreferredSize(PosUIManager.getSize(400, 250));
        object = new TransparentPanel();
        ((Container)object).add((Component)numericKeypad, "grow, center");
        jPanel.add((Component)new JSeparator(), "newline, gapbottom 5,gaptop 5");
        jPanel.add((Component)object, "newline");
    }

    private JLabel a(String string, int n, int n2, int n3) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(n, PosUIManager.getSize(n2)));
        jLabel.setHorizontalAlignment(n3);
        return jLabel;
    }

    private DoubleTextField b(String string, int n, int n2, int n3) {
        DoubleTextField doubleTextField = new DoubleTextField(14, 13, 3);
        doubleTextField.setText(string);
        doubleTextField.setFont(doubleTextField.getFont().deriveFont(n, PosUIManager.getSize(n2)));
        doubleTextField.setHorizontalAlignment(n3);
        doubleTextField.setBackground(Color.WHITE);
        return doubleTextField;
    }

    @Override
    public void doOk() {
        this.d();
        if (!this.b()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Invalid Amount");
            return;
        }
        boolean bl = Boolean.FALSE;
        for (CurrencyRow currencyRow : this.e) {
            if (!(currencyRow.b() > 0.0)) continue;
            bl = Boolean.TRUE;
            break;
        }
        double d = this.b - (this.c - this.d);
        this.g = new ArrayList<PaymentByCurrency>();
        for (CurrencyRow currencyRow : this.e) {
            PaymentByCurrency paymentByCurrency = null;
            double d2 = currencyRow.a();
            double d3 = currencyRow.b();
            if (!bl && d < 0.0 && currencyRow.a.isMain().booleanValue()) {
                d3 = Math.abs(d);
            }
            if (d2 > 0.0) {
                paymentByCurrency = new PaymentByCurrency();
                paymentByCurrency.currency = currencyRow.a;
                paymentByCurrency.tenderedAmount = d2;
            }
            if (d3 > 0.0) {
                if (paymentByCurrency == null) {
                    paymentByCurrency = new PaymentByCurrency();
                }
                paymentByCurrency.currency = currencyRow.a;
                paymentByCurrency.tenderedAmount = d2;
                paymentByCurrency.cashBackAmount = d3;
            }
            if (paymentByCurrency == null) continue;
            this.g.add(paymentByCurrency);
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean b() {
        double d = this.b - (this.c - this.d);
        if (this.c <= 0.0) {
            return false;
        }
        double d2 = CurrencyUtil.getMainCurrency().getTolerance();
        if (d > d2) {
            return true;
        }
        return this.c();
    }

    private boolean c() {
        double d = this.b - (this.c - this.d);
        double d2 = CurrencyUtil.getMainCurrency().getTolerance();
        if (d <= d2) {
            if (d > 0.0) {
                this.a(d);
            }
            return true;
        }
        return false;
    }

    private void a(double d) {
        TicketDiscount ticketDiscount = new TicketDiscount();
        ticketDiscount.setName("Tolerance");
        ticketDiscount.setValue(NumberUtil.roundToThreeDigit(d));
        ticketDiscount.setAutoApply(true);
        ticketDiscount.setTicket(this.f);
        this.f.addTodiscounts(ticketDiscount);
        this.f.calculatePrice();
    }

    private void d() {
        double d;
        this.c = 0.0;
        this.d = 0.0;
        for (CurrencyRow currencyRow : this.e) {
            d = currencyRow.a();
            double d2 = currencyRow.b();
            this.c += d / currencyRow.a.getExchangeRate();
            this.d += d2 / currencyRow.a.getExchangeRate();
        }
        for (CurrencyRow currencyRow : this.e) {
            d = (this.b - (this.c - this.d)) * currencyRow.a.getExchangeRate();
            currencyRow.a(d);
        }
    }

    public double getTenderedAmount() {
        return this.c;
    }

    public double getChangeDueAmount() {
        return this.c - this.b;
    }

    public List<PaymentByCurrency> getPaymentByCurrencies() {
        return this.g;
    }

    public class PaymentByCurrency {
        public Currency currency;
        public double tenderedAmount;
        public double cashBackAmount;
    }

    class CurrencyRow
    implements ActionListener,
    FocusListener {
        Currency a;
        DoubleTextField b;
        DoubleTextField c;
        double d;
        JLabel e;
        JLabel f;
        PosButton g = new PosButton(Messages.getString("MultiCurrencyTenderDialog.17"));
        PosButton h = new PosButton(Messages.getString("MultiCurrencyTenderDialog.18"));

        public CurrencyRow(Currency currency, double d) {
            this.a = currency;
            this.d = currency.getExchangeRate() * d;
            this.e = MultiCurrencyTenderDialog.this.a(NumberUtil.format3DigitNumber(this.d), 0, 16, 4);
            this.f = MultiCurrencyTenderDialog.this.a(currency.getName(), 0, 16, 10);
            this.b = MultiCurrencyTenderDialog.this.b("", 0, 16, 4);
            this.c = MultiCurrencyTenderDialog.this.b("", 0, 16, 4);
            this.b.addFocusListener(this);
            this.c.addFocusListener(this);
            this.g.addActionListener(this);
            this.h.addActionListener(this);
        }

        double a() {
            double d = this.b.getDouble();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d;
        }

        double b() {
            double d = this.c.getDouble();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d;
        }

        void a(double d) {
            this.d = d;
            this.e.setText(NumberUtil.format3DigitNumber(d));
        }

        double c() {
            return this.d;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.g) {
                this.b.setText(String.valueOf(NumberUtil.roundToThreeDigit(this.d)));
            } else {
                this.b.setText(String.valueOf(NumberUtil.roundToThreeDigit(Math.ceil(this.d))));
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MultiCurrencyTenderDialog.this.d();
        }
    }
}

