/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class POSDialog
extends JDialog {
    protected boolean canceled = true;

    public POSDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initUI();
    }

    public POSDialog(Dialog dialog, boolean bl) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), bl);
    }

    public POSDialog(Dialog dialog, String string, boolean bl) {
        this(POSUtil.getFocusedWindow(), string, bl);
    }

    public POSDialog(Frame frame, String string, boolean bl) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), bl);
    }

    public POSDialog(Frame frame, String string) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), true);
    }

    public POSDialog(Frame frame) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), true);
    }

    public POSDialog(Window window, Dialog.ModalityType modalityType) {
        super(POSUtil.getFocusedWindow(), modalityType);
        this.initUI();
    }

    public POSDialog(Window window) {
        super(window);
        this.initUI();
    }

    public POSDialog(Frame frame, boolean bl) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), bl);
    }

    public POSDialog(Window window, String string) {
        this(window, VersionInfo.getAppName(), true);
    }

    public POSDialog(Window window, String string, boolean bl) {
        super(window, VersionInfo.getAppName(), bl ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.initUI();
    }

    protected void initUI() {
        this.a();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                POSDialog.this.setCanceled(true);
                POSDialog.this.dispose();
            }
        };
        this.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void open() {
        this.canceled = true;
        if (this.isUndecorated()) {
            Window window = this.getOwner();
            if (window instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                this.setLocationRelativeTo(jFrame.getContentPane());
            } else {
                this.setLocationRelativeTo(window);
            }
        } else {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.setVisible(true);
    }

    public void openFullScreen() {
        this.canceled = true;
        if (TerminalConfig.isKioskMode()) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(dimension);
            this.setUndecorated(true);
        } else {
            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            rectangle.height -= 50;
            this.setBounds(rectangle);
        }
        this.setResizable(true);
        this.setLocationRelativeTo(POSUtil.getFocusedWindow());
        this.setVisible(true);
    }

    public void openUndecoratedFullScreen() {
        this.openFullScreen();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    private void a() {
        PosWindow posWindow = Application.getPosWindow();
        if (posWindow != null) {
            this.setIconImage(posWindow.getIconImage());
        }
    }
}

