/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ServerSummaryReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class ServerSummaryReportDialog
extends POSDialog {
    private TitlePanel a;
    private User b;
    private CashDrawer c;
    private StoreSession d;
    private PosButton e;
    private JPanel f;
    private PosButton g;
    private PosButton h;
    private JComboBox i;
    private JPanel j;
    private JPanel k;
    private JasperPrint l;
    private JasperPrint m;

    public ServerSummaryReportDialog(User user, StoreSession storeSession) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.b = user;
        this.d = storeSession;
        this.a();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.k = new JPanel(new BorderLayout());
        this.f = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.h = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.g = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.f.add((Component)new JSeparator(), "grow,span,wrap");
        this.e = new PosButton(POSConstants.DETAILS);
        this.f.add((Component)this.h, "grow");
        this.f.add((Component)this.e, "grow");
        this.f.add((Component)this.g, "grow");
        this.j = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,center,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.j.setVisible(false);
        List<User> list = UserDAO.getInstance().findAll();
        JLabel jLabel = new JLabel(POSConstants.SELECT_USER + " :");
        this.i = new JComboBox(new ListComboBoxModel(list));
        this.i.setSelectedItem(this.b);
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ServerSummaryReportDialog.this.b = (User)ServerSummaryReportDialog.this.i.getSelectedItem();
                    ServerSummaryReportDialog.this.refreshServerSummeryReport();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        if (this.b.isAdministrator() || this.b.isManager()) {
            this.j.setVisible(true);
        }
        this.j.add((Component)jLabel, "right");
        this.j.add((Component)this.i, "w 170!");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0"));
        jPanel.add((Component)this.j, "grow,wrap");
        jPanel.add((Component)new PosScrollPane(this.k), "grow");
        this.add((Component)this.a, "North");
        this.add(jPanel);
        this.add((Component)this.f, "South");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerSummaryReportDialog.this.b();
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerSummaryReportDialog.this.d();
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerSummaryReportDialog.this.e();
            }
        });
    }

    private void b() {
        try {
            this.c();
            DetailReportDialog detailReportDialog = new DetailReportDialog(this.l);
            detailReportDialog.setTitle(Messages.getString("ServerSummaryReportDialog.13"));
            detailReportDialog.updateView();
            detailReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void c() throws JRException {
        Object object;
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        List<PosTransaction> list = PosTransactionDAO.getInstance().findTransactionsForServer(this.d.getId(), this.b.getId());
        arrayList.addAll(list);
        CashDrawerTransactionReportModel cashDrawerTransactionReportModel = new CashDrawerTransactionReportModel();
        cashDrawerTransactionReportModel.setItems(arrayList);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Store store = DataProvider.get().getStore();
        hashMap.put("headerLine1", store.getName());
        hashMap.put("headerLine2", store.getAddressLine1());
        hashMap.put("receiptType", Messages.getString("ServerSummaryReportDialog.13"));
        if (this.b != null) {
            object = this.b.getFullName();
            hashMap.put("serverName", Messages.getString("ServerSummaryReportDialog.16") + (String)object);
        }
        object = this.d != null ? this.d.getCloseTime() : new Date();
        String string = "<b>" + Messages.getString("FROM") + "</b> " + DateUtil.formatFullDateAndTimeAsString(this.d.getOpenTime()) + " <b>" + Messages.getString("TO") + "</b> " + DateUtil.formatFullDateAndTimeAsString((Date)(object != null ? object : new Date()));
        hashMap.put("startDate", string);
        hashMap.put("status", arrayList == null || arrayList.isEmpty() ? Messages.getString("NoTransactionFound") : null);
        JasperReport jasperReport = ReportUtil.getReport("server_details_report");
        this.l = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)cashDrawerTransactionReportModel));
    }

    private void d() {
        this.dispose();
    }

    private void e() {
        try {
            PosPrintService.printReportByJasperPrint(this.m);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + exception.getMessage());
            PosLog.error(this.getClass(), exception);
        }
    }

    public void refreshServerSummeryReport() throws Exception {
        this.createServerSummaryReport();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(AppProperties.getAppName());
    }

    public void createServerSummaryReport() throws Exception {
        this.k.removeAll();
        ServerSummaryReportService serverSummaryReportService = new ServerSummaryReportService(this.b, this.d);
        this.c = serverSummaryReportService.populateServerSummaryReport();
        this.m = PosPrintService.populateServerSummaryReportParameters(this.c);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(this.m);
        ticketReceiptView.setZoom(1.25f);
        this.k.add(ticketReceiptView.getReportPanel());
        this.k.revalidate();
        this.k.repaint();
    }
}

