/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseMultiplier;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.multipart.PizzaModifierView;
import com.floreantpos.ui.views.order.multipart.PizzaTicketItemTableModel;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class PizzaModifierSelectionDialog
extends POSDialog
implements ModifierSelectionListener,
ActionListener,
ChangeListener {
    private static final String a = "pizzaPrice";
    private SizeAndCrustSelectionPane b;
    private PizzaModifierView c;
    private List<Section> d;
    private boolean e = false;
    private Section f;
    private Section g;
    private Section h;
    private Section i;
    private Section j;
    private Section k;
    private Section l;
    private TicketItemModifier m;
    private List<TicketItem> n = new ArrayList<TicketItem>();
    private CardLayout o = new CardLayout();
    private JPanel p = new Pizza(this.o);
    private JPanel q = new TransparentPanel(new GridLayout(1, 1, 2, 2));
    private JPanel r = new TransparentPanel(new GridLayout(1, 2, 2, 2));
    private JPanel s = new TransparentPanel(new GridLayout(2, 2, 2, 2));
    private JTable t;
    private MenuItemSize u;
    private MenuItemSize v;
    private TicketItem w;
    private JPanel x;
    private final MenuItem y;
    private PizzaTicketItemTableModel z;
    private boolean A;
    private boolean B = true;
    private PosButton C;
    private double D;
    private POSToggleButton E;
    private POSToggleButton F;
    private JToggleButton G;
    private ButtonGroup H;
    private JToggleButton I;
    private Ticket J;
    private JPanel K;
    private POSToggleButton L;
    private POSToggleButton M;
    private POSToggleButton N;
    private POSToggleButton O;
    private POSToggleButton P;
    private POSToggleButton Q;
    private POSToggleButton R;
    private ButtonGroup S;

    public PizzaModifierSelectionDialog(Ticket ticket, TicketItem ticketItem, MenuItem menuItem, boolean bl) {
        this.J = ticket;
        this.y = menuItem;
        this.w = ticketItem;
        this.A = bl;
        this.g();
        this.a();
        this.c();
    }

    private void a() {
        this.setTitle(Messages.getString("PizzaModifierSelectionDialog.1"));
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.d(), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setPreferredSize(PosUIManager.getSize(0, 200));
        this.t = new JTable();
        this.z = new PizzaTicketItemTableModel();
        this.t.setModel(this.z);
        this.t.setRowHeight(30);
        this.t.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.t.setAutoResizeMode(3);
        TableColumnModel tableColumnModel = this.t.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(50);
        JScrollPane jScrollPane = new JScrollPane(this.t);
        jPanel4.add(jScrollPane);
        int n = PosUIManager.getSize(40);
        JXCollapsiblePane jXCollapsiblePane = new JXCollapsiblePane();
        jXCollapsiblePane.setBackground(Color.WHITE);
        jXCollapsiblePane.setLayout((LayoutManager)new MigLayout("fillx,ins 2 0 2 0", "[" + n + "px][grow][" + n + "px]", "[" + n + "]"));
        jXCollapsiblePane.setAnimated(true);
        jXCollapsiblePane.setCollapsed(false);
        jXCollapsiblePane.setVisible(true);
        PosButton posButton = new PosButton();
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierSelectionDialog.a(PizzaModifierSelectionDialog.this);
                PizzaModifierSelectionDialog.this.C.setText(NumberUtil.trimDecilamIfNotNeeded(PizzaModifierSelectionDialog.this.D));
            }
        });
        this.C = new PosButton(NumberUtil.trimDecilamIfNotNeeded(this.D));
        this.C.setForeground(Color.BLUE);
        this.C.setBackground(Color.WHITE);
        Border border = BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f, 0.1f), 1);
        this.C.setBorder(border);
        this.C.setFont(new Font(this.C.getFont().getName(), 1, 20));
        this.C.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
                numberSelectionDialog2.setTitle(Messages.getString("PizzaModifierSelectionDialog.8"));
                numberSelectionDialog2.setFloatingPoint(false);
                numberSelectionDialog2.pack();
                numberSelectionDialog2.open();
                if (numberSelectionDialog2.isCanceled()) {
                    return;
                }
                PizzaModifierSelectionDialog.this.D = (int)numberSelectionDialog2.getValue();
                PizzaModifierSelectionDialog.this.C.setText(NumberUtil.trimDecilamIfNotNeeded(PizzaModifierSelectionDialog.this.D));
            }
        });
        PosButton posButton2 = new PosButton();
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PizzaModifierSelectionDialog.this.D == 1.0) {
                    return;
                }
                PizzaModifierSelectionDialog.d(PizzaModifierSelectionDialog.this);
                PizzaModifierSelectionDialog.this.C.setText(NumberUtil.trimDecilamIfNotNeeded(PizzaModifierSelectionDialog.this.D));
            }
        });
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "plus_32.png"));
        posButton2.setIcon(IconFactory.getIcon("/ui_icons/", "minus_32.png"));
        jXCollapsiblePane.add((Component)posButton2);
        jXCollapsiblePane.add((Component)this.C, (Object)"grow");
        jXCollapsiblePane.add((Component)posButton);
        jPanel4.add((Component)jXCollapsiblePane, "South");
        jPanel2.add((Component)jPanel4, "North");
        this.b = new SizeAndCrustSelectionPane();
        jPanel3.add((Component)this.b, "North");
        this.c = new PizzaModifierView(this.J, this.w, this.y, this);
        this.c.addModifierSelectionListener(this);
        jPanel3.add((Component)this.c, "Center");
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel2, "West");
        this.createButtonPanel();
        this.l();
    }

    private JPanel b() {
        this.K = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 7 0"));
        this.K.setBorder(null);
        this.S = new ButtonGroup();
        this.L = new POSToggleButton("WHOLE");
        this.M = new POSToggleButton("H1");
        this.N = new POSToggleButton("H2");
        this.O = new POSToggleButton("Q1");
        this.P = new POSToggleButton("Q2");
        this.Q = new POSToggleButton("Q3");
        this.R = new POSToggleButton("Q4");
        this.L.addChangeListener(this);
        this.M.addChangeListener(this);
        this.N.addChangeListener(this);
        this.O.addChangeListener(this);
        this.P.addChangeListener(this);
        this.Q.addChangeListener(this);
        this.R.addChangeListener(this);
        this.S.add(this.L);
        this.S.add(this.M);
        this.S.add(this.N);
        this.S.add(this.O);
        this.S.add(this.P);
        this.S.add(this.Q);
        this.S.add(this.R);
        this.K.add((Component)this.L, "grow");
        this.K.add((Component)this.M, "grow");
        this.K.add((Component)this.N, "grow");
        this.K.add((Component)this.O, "grow");
        this.K.add((Component)this.P, "grow");
        this.K.add((Component)this.Q, "grow");
        this.K.add((Component)this.R, "grow");
        return this.K;
    }

    private void c() {
        if (this.w.getSizeModifier() == null) {
            if (this.m != null) {
                this.w.setSizeModifier(this.m);
                this.w.getSizeModifier().calculatePrice();
            }
        } else {
            this.w.getSizeModifier().calculatePrice();
        }
        this.z.setTicketItem(this.w);
        this.z.updateView();
        List<TicketItemModifier> list = this.w.getTicketItemModifiers();
        if (list == null) {
            return;
        }
        for (Section section : this.d) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue() || !section.getSectionName().equals(ticketItemModifier.getSectionName())) continue;
                section.j.addItem(ticketItemModifier);
            }
        }
        if (this.w.getPizzaSectionMode() != null) {
            if (this.w.getPizzaSectionMode() == TicketItem.PIZZA_SECTION_MODE.FULL) {
                this.E.setSelected(true);
                this.I = this.E;
                this.j();
                if (this.w.isPrintedToKitchen().booleanValue()) {
                    this.F.setEnabled(false);
                    this.G.setEnabled(false);
                }
            } else if (this.w.getPizzaSectionMode() == TicketItem.PIZZA_SECTION_MODE.HALF) {
                this.F.setSelected(true);
                this.I = this.F;
                this.l();
                if (this.w.isPrintedToKitchen().booleanValue()) {
                    this.E.setEnabled(false);
                    this.G.setEnabled(false);
                }
            } else if (this.w.getPizzaSectionMode() == TicketItem.PIZZA_SECTION_MODE.QUARTER) {
                this.G.setSelected(true);
                this.I = this.G;
                this.n();
                if (this.w.isPrintedToKitchen().booleanValue()) {
                    this.F.setEnabled(false);
                    this.E.setEnabled(false);
                }
            }
        }
    }

    private JPanel d() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.d = new ArrayList<Section>();
        this.l = new Section("WHOLE", "WHOLE", 0, true, 1.0);
        this.f = new Section("Quarter 1", "Quarter 1", 1, false, 0.25);
        this.g = new Section("Quarter 2", "Quarter 2", 2, false, 0.25);
        this.h = new Section("Quarter 3", "Quarter 3", 3, false, 0.25);
        this.i = new Section("Quarter 4", "Quarter 4", 4, false, 0.25);
        this.j = new Section("Half 1", "Half 1", 5, false, 0.5);
        this.k = new Section("Half 2", "Half 2", 6, false, 0.5);
        this.d.add(this.l);
        this.d.add(this.f);
        this.d.add(this.g);
        this.d.add(this.h);
        this.d.add(this.i);
        this.d.add(this.j);
        this.d.add(this.k);
        this.q.add(this.l);
        this.r.add(this.j);
        this.r.add(this.k);
        this.s.add(this.f);
        this.s.add(this.g);
        this.s.add(this.h);
        this.s.add(this.i);
        this.p.add((Component)this.q, "full");
        this.p.add((Component)this.r, "half");
        this.p.add((Component)this.s, "quarter");
        this.x = new JPanel((LayoutManager)new MigLayout("fill,ins 0 0 0 0"));
        this.x.setOpaque(false);
        jPanel.setOpaque(false);
        jPanel.add((Component)this.b(), "North");
        jPanel.add((Component)this.p, "Center");
        jPanel.add((Component)this.x, "South");
        jPanel.setPreferredSize(PosUIManager.getSize(300, 0));
        return jPanel;
    }

    public void createButtonPanel() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fill, ins 2", "", ""));
        this.H = new ButtonGroup();
        this.E = new POSToggleButton("FULL");
        this.I = this.E;
        this.E.addActionListener(this);
        this.F = new POSToggleButton("HALF");
        this.F.setSelected(true);
        this.F.addActionListener(this);
        this.G = new POSToggleButton("QUARTER");
        this.G.addActionListener(this);
        this.H.add(this.E);
        this.H.add(this.F);
        this.H.add(this.G);
        PosButton posButton = new PosButton(Messages.getString("PizzaModifierSelectionDialog.2"));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Section section = PizzaModifierSelectionDialog.this.getSelectedSection();
                if (section == null) {
                    return;
                }
                section.clearSelectedItem();
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("PizzaModifierSelectionDialog.3"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Section section = PizzaModifierSelectionDialog.this.getSelectedSection();
                if (section == null) {
                    return;
                }
                section.clearItems();
                PizzaModifierSelectionDialog.this.c.resetDefaultMultiplierButton();
            }
        });
        PosButton posButton3 = new PosButton(Messages.getString("DONE"));
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PizzaModifierSelectionDialog.this.e()) {
                    PizzaModifierSelectionDialog.this.setCanceled(false);
                    PizzaModifierSelectionDialog.this.dispose();
                }
            }
        });
        PosButton posButton4 = new PosButton(POSConstants.CANCEL.toUpperCase());
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierSelectionDialog.this.setCanceled(true);
                PizzaModifierSelectionDialog.this.dispose();
            }
        });
        int n = PosUIManager.getSize(97);
        JSeparator jSeparator = new JSeparator(1);
        transparentPanel.add((Component)this.E, "w " + n + "!, split 5");
        transparentPanel.add((Component)this.F, "w " + n + "!");
        transparentPanel.add((Component)this.G, "w " + n + "!");
        transparentPanel.add((Component)jSeparator, "growy");
        transparentPanel.add((Component)posButton, "grow");
        transparentPanel.add((Component)posButton2, "grow");
        transparentPanel.add((Component)posButton4, "grow");
        transparentPanel.add((Component)posButton3, "grow");
        this.add((Component)transparentPanel, "South");
    }

    private boolean e() {
        if (!this.e) {
            POSMessageDialog.showError(Messages.getString("PizzaModifierSelectionDialog.63"));
            return false;
        }
        List<MenuItemModifierSpec> list = this.w.getMenuItem().getMenuItemModiferSpecs();
        for (MenuItemModifierSpec comparable : list) {
            if (this.w.requiredModifiersAdded(comparable)) continue;
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), String.format(Messages.getString("PizzaModifierSelectionDialog.64"), comparable.getModifierGroup().getDisplayName()));
            return false;
        }
        this.f();
        if (!this.A) {
            this.n.add(this.w);
            if (!this.isAllowCreateMultiPizza()) {
                return true;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.65"), Messages.getString("PizzaModifierSelectionDialog.66"));
            if (n == 0) {
                TicketItem ticketItem = this.w.clone();
                ticketItem.setId(null);
                this.w = ticketItem;
                this.h();
                return false;
            }
        }
        return true;
    }

    private void f() {
        this.w.setQuantity(this.D);
        this.w.calculatePrice();
    }

    private void g() {
        this.D = this.w.getQuantity();
        this.w.setQuantity(1.0);
        List<TicketItemModifier> list = this.w.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setItemQuantity(ticketItemModifier.getItemQuantity() / this.D);
            }
        }
        this.w.calculatePrice();
    }

    private void h() {
        for (Section section : this.d) {
            if (section.j.getRows() == null) continue;
            Iterator iterator = section.j.getRows().iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = (TicketItemModifier)iterator.next();
                if (ticketItemModifier == null) continue;
                iterator.remove();
            }
            section.j.fireTableDataChanged();
            section.repaint();
        }
        this.c.getModifierGroupView().selectFirst();
        this.w.setSizeModifier(this.i());
        this.w.getSizeModifier().calculatePrice();
        if (this.w.getTicketItemModifiers() != null) {
            this.w.getTicketItemModifiers().clear();
        }
        this.z.setTicketItem(this.w);
        this.z.updateView();
    }

    private boolean a(MenuItemModifierSpec menuItemModifierSpec, int n) {
        int n2 = menuItemModifierSpec.getMinQuantity();
        int n3 = menuItemModifierSpec.getMaxQuantity();
        if (n3 < n2) {
            n3 = n2;
        }
        return n >= n3;
    }

    private Multiplier a(Section section, Multiplier multiplier) {
        Store store = DataProvider.get().getStore();
        if (section.getSectionName().startsWith("Half")) {
            multiplier = store.getHalfMultiplier(multiplier);
        } else if (section.getSectionName().startsWith("Quarter")) {
            multiplier = store.getQuarterMultiplier(multiplier);
        }
        return multiplier;
    }

    @Override
    public void modifierSelected(MenuModifier menuModifier, Multiplier multiplier) {
        int n;
        Object object;
        int n2;
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        boolean bl = this.a(menuItemModifierSpec, n2 = this.w.countModifierFromGroup(menuItemModifierSpec));
        if (bl) {
            if (DataProvider.get().getStore().hasExtraMultiplier().booleanValue()) {
                String string;
                object = Messages.getString("PizzaModifierSelectionDialog.4");
                int n3 = POSMessageDialog.showYesNoQuestionDialog(this, (String)object, string = Messages.getString("PizzaModifierSelectionDialog.5"));
                if (n3 != 0) {
                    return;
                }
            } else {
                POSMessageDialog.showError(Messages.getString("PizzaModifierSelectionDialog.67") + menuModifier.getMenuItemModifierGroup().getDisplayName());
                this.modifierGroupSelectionDone(menuItemModifierSpec);
                this.c.revalidate();
                this.c.repaint();
                return;
            }
        }
        object = this.getSelectedSection();
        boolean bl2 = false;
        this.v = this.b.getMenuItemSize();
        if (this.v != null) {
            if (this.u != null) {
                if (this.u == this.v) {
                    bl2 = true;
                }
            } else {
                this.u = this.v;
                bl2 = true;
            }
        }
        TicketItemModifier ticketItemModifier = this.w.findTicketItemModifierFor(menuModifier, this.getMainSection().getSectionName(), null);
        TicketItemModifier ticketItemModifier2 = this.w.findTicketItemModifierFor(menuModifier, ((Section)object).getSectionName(), null);
        if (!((Section)object).c) {
            n = 0;
            for (Section section : this.d) {
                int n4;
                TicketItemModifier ticketItemModifier3;
                if (section.getSectionName().startsWith("Half")) {
                    if (section == object || (ticketItemModifier3 = this.w.findTicketItemModifierFor(menuModifier, section.getSectionName(), null)) == null || ticketItemModifier2 != null) continue;
                    if (ticketItemModifier != null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.69"));
                        return;
                    }
                    n4 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.70"), Messages.getString("PizzaModifierSelectionDialog.71"));
                    if (n4 != 0) break;
                    section.clearItem(ticketItemModifier3, section.j);
                    object = this.getMainSection();
                    continue;
                }
                if (!section.getSectionName().startsWith("Quarter") || section == object || (ticketItemModifier3 = this.w.findTicketItemModifierFor(menuModifier, section.getSectionName(), null)) == null || ticketItemModifier2 != null) continue;
                if (n == 2) {
                    if (ticketItemModifier != null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.73"));
                        return;
                    }
                    n4 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.74"), Messages.getString("PizzaModifierSelectionDialog.75"));
                    if (n4 == 0) {
                        for (Section section2 : this.d) {
                            if (section2.getSectionName().startsWith("Quarter")) {
                                section2.clearItem(ticketItemModifier3, section2.j);
                            }
                            section2.repaint();
                        }
                        object = this.getMainSection();
                    }
                }
                ++n;
            }
        }
        multiplier = this.a((Section)object, multiplier);
        if (ticketItemModifier != null && !((Section)object).c && ticketItemModifier2 == null && (n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.77"), Messages.getString("PizzaModifierSelectionDialog.78"))) == 1) {
            return;
        }
        if (ticketItemModifier2 == null || ticketItemModifier2.isPrintedToKitchen().booleanValue() || !bl2) {
            OrderType orderType = this.w.getTicket().getOrderType();
            ticketItemModifier2 = this.a(this.w, menuModifier, orderType, multiplier, (Section)object, bl);
            ticketItemModifier2.setSectionName(((Section)object).getSectionName());
            ticketItemModifier2.setMenuModifier(menuModifier);
            if (ticketItemModifier2.isShouldSectionWisePrice().booleanValue()) {
                ticketItemModifier2.setUnitPrice(((Section)object).calculatePrice(ticketItemModifier2.getUnitPrice()));
            }
            ((Section)object).addItem(ticketItemModifier2);
            TicketItemModifier ticketItemModifier4 = this.a(((Section)object).getSectionName());
            if (ticketItemModifier4 != null) {
                this.w.addToticketItemModifiers(ticketItemModifier4);
            }
            this.w.addToticketItemModifiers(ticketItemModifier2);
            if (!ticketItemModifier2.isInfoOnly().booleanValue()) {
                double d = this.y.getDefaultSellPortion().intValue();
                this.w.updateModifiersUnitPrice(d);
            }
        } else {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.79"));
            this.c.revalidate();
            this.c.repaint();
            return;
        }
        if (n2 + 1 >= menuItemModifierSpec.getMinQuantity()) {
            this.modifierGroupSelectionDone(menuItemModifierSpec);
        }
        this.z.updateView();
        this.c.revalidate();
        this.c.repaint();
        this.revalidate();
        this.repaint();
    }

    private TicketItemModifier a(String string) {
        TicketItemModifier ticketItemModifier;
        List<TicketItemModifier> list = this.w.getTicketItemModifiers();
        if (this.z.getRowCount() == 1 && string.equals("WHOLE")) {
            return null;
        }
        if (list != null && !list.isEmpty() && string.equals((ticketItemModifier = list.get(list.size() - 1)).getSectionName())) {
            return null;
        }
        ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setName("== " + string + " ==");
        ticketItemModifier.setModifierType(6);
        ticketItemModifier.setInfoOnly(true);
        ticketItemModifier.setSectionName(string);
        ticketItemModifier.setTicketItem(this.w);
        return ticketItemModifier;
    }

    @Override
    public void clearModifiers(MenuItemModifierSpec menuItemModifierSpec) {
    }

    @Override
    public void modifierGroupSelectionDone(MenuItemModifierSpec menuItemModifierSpec) {
        if (!PizzaModifierSelectionDialog.isRequiredModifiersAdded(this.w, menuItemModifierSpec)) {
            this.a(menuItemModifierSpec);
            this.c.getModifierGroupView().setSelectedModifierGroup(menuItemModifierSpec);
            return;
        }
        if (menuItemModifierSpec.isJumpGroup().booleanValue() && this.c.getModifierGroupView().hasNextMandatoryGroup()) {
            this.c.getModifierGroupView().selectNextGroup();
        }
    }

    public static boolean isRequiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        return true;
    }

    private TicketItemModifier a(TicketItem ticketItem, MenuModifier menuModifier, OrderType orderType, Multiplier multiplier, Section section, Boolean bl) {
        Multiplier multiplier2;
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemQuantity(1.0);
        ticketItemModifier.setName(menuModifier.getDisplayName().trim());
        ticketItemModifier.setTicketItem(ticketItem);
        double d = menuModifier.getPriceForSizeAndMultiplier(this.getSelectedSize(), false, multiplier);
        Multiplier multiplier3 = multiplier2 = bl != false ? DataProvider.get().getStore().getExtraMultiplier() : this.c.getSelectedMultiplier();
        if (multiplier2 != null) {
            Object object;
            if (!multiplier2.getId().equals("Regular") && !section.c) {
                object = DataProvider.get().getMultiplierById("Regular");
                double d2 = multiplier2.getRate() / ((BaseMultiplier)object).getRate();
                d *= d2;
            }
            ticketItemModifier.setMultiplierName(multiplier2.getId());
            object = multiplier2.getTicketPrefix() + " " + menuModifier.getDisplayName();
            ticketItemModifier.setName((String)object);
        }
        ticketItemModifier.setUnitPrice(d);
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(orderType, ticketItem));
        ticketItemModifier.setModifierType(1);
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setShouldSectionWisePrice(menuModifier.isShouldSectionWisePrice());
        return ticketItemModifier;
    }

    public MenuItemSize getSelectedSize() {
        List<POSToggleButton> list = this.b.b;
        for (POSToggleButton pOSToggleButton : list) {
            if (!pOSToggleButton.isSelected()) continue;
            PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(a);
            return pizzaPrice.getSize();
        }
        return null;
    }

    public void setSelectedSection(Section section) {
        if (section.isSelected()) {
            return;
        }
        for (Section section2 : this.d) {
            section2.d.setBackground(Color.lightGray);
            section2.setSelected(false);
            section2.setBorder(null);
        }
        section.d.setBackground(Color.green);
        section.setSelected(true);
        this.x.revalidate();
        this.x.repaint();
    }

    public Section getSelectedSection() {
        for (Section section : this.d) {
            if (!section.isSelected()) continue;
            return section;
        }
        return this.getMainSection();
    }

    public Section getMainSection() {
        for (Section section : this.d) {
            if (!section.c) continue;
            return section;
        }
        return null;
    }

    private TicketItemModifier i() {
        if (this.w != null && this.w.getSizeModifier() != null) {
            this.m = this.w.getSizeModifier();
            return this.m;
        }
        return this.m;
    }

    @Override
    public void modifierRemoved(TicketItemModifier ticketItemModifier) {
    }

    private void a(MenuItemModifierSpec menuItemModifierSpec) {
        String string = menuItemModifierSpec.getModifierGroup().getDisplayName();
        int n = menuItemModifierSpec.getMinQuantity();
        POSMessageDialog.showError(Messages.getString("PizzaModifierSelectionDialog.100") + n + Messages.getString("PizzaModifierSelectionDialog.101") + string);
    }

    private void a(POSToggleButton pOSToggleButton) {
        PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(a);
        this.w.setUnitPrice(pizzaPrice.getPrice(this.y.getDefaultSellPortion()));
        TicketItemModifier ticketItemModifier = this.i();
        if (ticketItemModifier != null) {
            ticketItemModifier.setName(pizzaPrice.getSize().getName() + " " + pizzaPrice.getCrust());
            this.m = ticketItemModifier;
        } else {
            this.m = new TicketItemModifier();
            this.m.setName(pizzaPrice.getSize().getName() + " " + pizzaPrice.getCrust());
            this.m.setModifierType(5);
            this.m.setInfoOnly(true);
            this.m.setTicketItem(this.w);
        }
        this.e = true;
    }

    private void j() {
        this.x.removeAll();
        this.q.removeAll();
        this.q.add(this.l);
        this.o.show(this.p, "full");
        this.w.setPizzaSectionMode(TicketItem.PIZZA_SECTION_MODE.FULL);
        this.K.setVisible(false);
        this.m();
    }

    private void k() {
        for (Section section : this.d) {
            if (section.j.getRows() == null) continue;
            section.clearItems();
        }
    }

    private void l() {
        this.x.add((Component)this.l, "grow");
        this.o.show(this.p, "half");
        this.w.setPizzaSectionMode(TicketItem.PIZZA_SECTION_MODE.HALF);
        this.K.setVisible(true);
        this.M.setVisible(true);
        this.N.setVisible(true);
        this.O.setVisible(false);
        this.P.setVisible(false);
        this.Q.setVisible(false);
        this.R.setVisible(false);
        this.m();
        this.L.setSelected(true);
    }

    private void m() {
        this.S.clearSelection();
        for (Section section : this.d) {
            section.d.setBackground(Color.lightGray);
            section.setSelected(false);
            section.setBorder(null);
        }
        this.x.setBorder(null);
    }

    private void n() {
        this.x.add((Component)this.l, "grow");
        this.o.show(this.p, "quarter");
        this.w.setPizzaSectionMode(TicketItem.PIZZA_SECTION_MODE.QUARTER);
        this.K.setVisible(true);
        this.M.setVisible(false);
        this.N.setVisible(false);
        this.O.setVisible(true);
        this.P.setVisible(true);
        this.Q.setVisible(true);
        this.R.setVisible(true);
        this.m();
        this.L.setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "FULL") {
            if (this.w.getTicketItemModifiers() != null && this.w.getTicketItemModifiers().size() > 0) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.113"), Messages.getString("PizzaModifierSelectionDialog.114"));
                if (n != 0) {
                    this.I.setSelected(true);
                    return;
                }
                this.k();
            }
            this.j();
        } else if (actionEvent.getActionCommand() == "HALF") {
            if (this.w.getTicketItemModifiers() != null && this.w.getTicketItemModifiers().size() > 0) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.116"), Messages.getString("PizzaModifierSelectionDialog.117"));
                if (n != 0) {
                    this.I.setSelected(true);
                    return;
                }
                this.k();
            }
            this.l();
        } else if (actionEvent.getActionCommand() == "QUARTER") {
            if (this.w.getTicketItemModifiers() != null && this.w.getTicketItemModifiers().size() > 0) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.119"), Messages.getString("PizzaModifierSelectionDialog.120"));
                if (n != 0) {
                    this.I.setSelected(true);
                    return;
                }
                this.k();
            }
            this.n();
        }
        this.I = (JToggleButton)actionEvent.getSource();
    }

    private void a(Section section) {
        if (section.getSectionName().equals("WHOLE")) {
            this.L.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 1")) {
            this.O.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 2")) {
            this.P.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 3")) {
            this.Q.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 4")) {
            this.R.setSelected(true);
        } else if (section.getSectionName().equals("Half 1")) {
            this.M.setSelected(true);
        } else if (section.getSectionName().equals("Half 2")) {
            this.N.setSelected(true);
        }
    }

    @Override
    public void finishModifierSelection() {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JToggleButton jToggleButton = (JToggleButton)changeEvent.getSource();
        if (jToggleButton.getText().equals("WHOLE")) {
            for (Section section : this.d) {
                section.d.setBackground(Color.lightGray);
                section.setSelected(false);
            }
        } else if (jToggleButton.getText().equals("H1")) {
            this.setSelectedSection(this.j);
        } else if (jToggleButton.getText().equals("H2")) {
            this.setSelectedSection(this.k);
        } else if (jToggleButton.getText().equals("Q1")) {
            this.setSelectedSection(this.f);
        } else if (jToggleButton.getText().equals("Q2")) {
            this.x.setBorder(null);
            this.setSelectedSection(this.g);
        } else if (jToggleButton.getText().equals("Q3")) {
            this.setSelectedSection(this.h);
        } else if (jToggleButton.getText().equals("Q4")) {
            this.setSelectedSection(this.i);
        }
    }

    public void updateTicketItemModifierPrices() {
        List<TicketItemModifier> list = this.w.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                MenuModifier menuModifier = ticketItemModifier.getMenuModifier();
                if (menuModifier == null) continue;
                double d = menuModifier.getPriceForSizeAndMultiplier(this.getSelectedSize(), false, this.c.getSelectedMultiplier());
                ticketItemModifier.setUnitPrice(d);
            }
        }
        this.o();
        if (this.w.getSizeModifier() != null) {
            this.w.getSizeModifier().calculatePrice();
            this.z.updateView();
        }
    }

    private void o() {
        for (Section section : this.d) {
            section.j.fireTableDataChanged();
        }
    }

    @Override
    public void modifierUpdated(TicketItemModifier ticketItemModifier, double d) {
    }

    public List<TicketItem> getPizzzItemList() {
        return this.n;
    }

    public boolean isAllowCreateMultiPizza() {
        return this.B;
    }

    public void setAllowCreateMultiPizza(boolean bl) {
        this.B = bl;
    }

    static /* synthetic */ double a(PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        double d = pizzaModifierSelectionDialog.D;
        pizzaModifierSelectionDialog.D = d + 1.0;
        return d;
    }

    static /* synthetic */ double d(PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        double d = pizzaModifierSelectionDialog.D;
        pizzaModifierSelectionDialog.D = d - 1.0;
        return d;
    }

    class SectionModifierTableModel
    extends ListTableModel<TicketItemModifier> {
        public SectionModifierTableModel() {
            super(new String[]{Messages.getString("PizzaModifierSelectionDialog.109"), Messages.getString("PizzaModifierSelectionDialog.110")});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)this.rows.get(n);
            if (ticketItemModifier instanceof TicketItemModifier) {
                ticketItemModifier.calculatePrice();
            }
            switch (n2) {
                case 0: {
                    if (ticketItemModifier instanceof TicketItemModifier) {
                        return ticketItemModifier.getName();
                    }
                    return " " + ticketItemModifier.getNameDisplay();
                }
                case 1: {
                    Double d = null;
                    if (ticketItemModifier instanceof TicketItemModifier) {
                        d = ticketItemModifier.getUnitPrice();
                        return NumberUtil.roundToTwoDigit(d);
                    }
                    return null;
                }
            }
            return null;
        }

        public void deleteGivenItem(TicketItemModifier ticketItemModifier) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = (TicketItemModifier)iterator.next();
                if (ticketItemModifier != ticketItemModifier2) continue;
                iterator.remove();
            }
            this.fireTableDataChanged();
        }

        public void deleteGivenItemByName(TicketItemModifier ticketItemModifier) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = (TicketItemModifier)iterator.next();
                if (!ticketItemModifier.getName().equals(ticketItemModifier2.getName())) continue;
                iterator.remove();
            }
            this.fireTableDataChanged();
        }
    }

    public class ModifierTableCellRenderer
    extends PosTableRenderer {
        private boolean b = false;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ITicketItem iTicketItem;
            Component component = null;
            SectionModifierTableModel sectionModifierTableModel = (SectionModifierTableModel)jTable.getModel();
            Object e = sectionModifierTableModel.getRowData(n);
            if (n2 == 1) {
                component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            } else {
                component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (n2 == 0) {
                    this.setHorizontalAlignment(0);
                } else {
                    this.setHorizontalAlignment(4);
                }
            }
            if (bl) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
                return component;
            }
            component.setBackground(jTable.getBackground());
            component.setForeground(Color.BLACK);
            if (e instanceof TicketItemModifier && (iTicketItem = (ITicketItem)e).isPrintedToKitchen().booleanValue()) {
                component.setBackground(Color.YELLOW);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    class SizeAndCrustSelectionPane
    extends JPanel {
        List<PizzaPrice> a;
        List<POSToggleButton> b = new ArrayList<POSToggleButton>();
        List<POSToggleButton> c = new ArrayList<POSToggleButton>();
        JPanel d = new JPanel();
        JPanel e = new JPanel();
        ButtonGroup f = new ButtonGroup();
        ButtonGroup g = new ButtonGroup();
        MenuItemSize h;
        PizzaCrust i;

        public SizeAndCrustSelectionPane() {
            this.a = PizzaModifierSelectionDialog.this.y.getPizzaPriceList();
            this.setLayout(new BorderLayout());
            this.d.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("PizzaModifierSelectionDialog.0"), 2, 2));
            this.e.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("PizzaModifierSelectionDialog.94"), 2, 2));
            this.e.setLayout(new FlowLayout());
            HashSet<MenuItemSize> hashSet = new HashSet<MenuItemSize>();
            for (PizzaPrice pizzaPrice : this.a) {
                MenuItemSize menuItemSize = pizzaPrice.getSize();
                if (hashSet.contains(menuItemSize)) continue;
                hashSet.add(menuItemSize);
                this.a(pizzaPrice, menuItemSize);
            }
            this.a();
            this.add((Component)this.d, "West");
            this.add(this.e);
        }

        private void a() {
            TicketItemModifier ticketItemModifier = PizzaModifierSelectionDialog.this.i();
            if (ticketItemModifier != null) {
                PizzaPrice pizzaPrice;
                String string = ticketItemModifier.getName();
                String[] stringArray = string.split(" ");
                String string2 = stringArray[0];
                String pizzaPrice2 = stringArray[1];
                for (POSToggleButton pOSToggleButton : this.b) {
                    pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.a);
                    if (pizzaPrice.getSize().getName().equalsIgnoreCase(string2)) {
                        pOSToggleButton.setSelected(true);
                        this.renderCrusts(pizzaPrice.getSize());
                        continue;
                    }
                    if (!PizzaModifierSelectionDialog.this.w.isPrintedToKitchen().booleanValue()) continue;
                    pOSToggleButton.setEnabled(false);
                }
                for (POSToggleButton pOSToggleButton : this.c) {
                    pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.a);
                    if (pizzaPrice.getCrust().getName().startsWith(pizzaPrice2)) {
                        pOSToggleButton.setSelected(true);
                        PizzaModifierSelectionDialog.this.e = true;
                        continue;
                    }
                    if (!PizzaModifierSelectionDialog.this.w.isPrintedToKitchen().booleanValue()) continue;
                    pOSToggleButton.setEnabled(false);
                }
            } else if (!this.b.isEmpty()) {
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                for (POSToggleButton serializable : this.b) {
                    if (!serializable.isSelected()) continue;
                    PizzaPrice pizzaPrice = (PizzaPrice)serializable.getClientProperty(PizzaModifierSelectionDialog.a);
                    this.renderCrusts(pizzaPrice.getSize());
                    arrayList.add(true);
                }
                if (arrayList.isEmpty() || arrayList.contains(false)) {
                    POSToggleButton pOSToggleButton = this.b.get(0);
                    PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.a);
                    this.renderCrusts(pizzaPrice.getSize());
                    pOSToggleButton.setSelected(true);
                }
            }
        }

        private void a(PizzaPrice pizzaPrice, MenuItemSize menuItemSize) {
            POSToggleButton pOSToggleButton = new POSToggleButton(menuItemSize.getName());
            pOSToggleButton.putClientProperty(PizzaModifierSelectionDialog.a, pizzaPrice);
            if (menuItemSize.isDefaultSize().booleanValue()) {
                pOSToggleButton.setSelected(true);
            }
            pOSToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                    PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.a);
                    SizeAndCrustSelectionPane.this.renderCrusts(pizzaPrice.getSize());
                    TicketItemModifier ticketItemModifier = PizzaModifierSelectionDialog.this.i();
                    if (ticketItemModifier != null) {
                        PizzaModifierSelectionDialog.this.w.setSizeModifier(ticketItemModifier);
                        ticketItemModifier.calculatePrice();
                        PizzaModifierSelectionDialog.this.z.updateView();
                    }
                    PizzaModifierSelectionDialog.this.updateTicketItemModifierPrices();
                    PizzaModifierSelectionDialog.this.c.updateView();
                    PizzaModifierSelectionDialog.this.c.revalidate();
                    PizzaModifierSelectionDialog.this.c.repaint();
                    SizeAndCrustSelectionPane.this.revalidate();
                    SizeAndCrustSelectionPane.this.repaint();
                }
            });
            this.f.add(pOSToggleButton);
            this.b.add(pOSToggleButton);
            this.d.add(pOSToggleButton);
        }

        protected void renderCrusts(MenuItemSize menuItemSize) {
            this.setMenuItemSize(menuItemSize);
            for (POSToggleButton serializable2 : this.c) {
                this.g.remove(serializable2);
            }
            this.e.removeAll();
            Set<PizzaPrice> set = PizzaModifierSelectionDialog.this.y.getAvailablePrices(menuItemSize);
            TicketItemModifier ticketItemModifier = PizzaModifierSelectionDialog.this.i();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                final PizzaPrice pizzaPrice = (PizzaPrice)iterator.next();
                POSToggleButton pOSToggleButton = new POSToggleButton();
                pOSToggleButton.setText("<html><center>" + pizzaPrice.getCrust().getName() + "<br/>" + CurrencyUtil.getCurrencySymbol() + pizzaPrice.getPrice(PizzaModifierSelectionDialog.this.y.getDefaultSellPortion()) + "</center></html>");
                pOSToggleButton.putClientProperty(PizzaModifierSelectionDialog.a, pizzaPrice);
                if (set.size() == 1) {
                    PizzaModifierSelectionDialog.this.e = true;
                    pOSToggleButton.setSelected(true);
                    PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                    this.setPizzaCrust(pizzaPrice.getCrust());
                }
                if (pizzaPrice.getCrust().isDefaultCrust().booleanValue() && ticketItemModifier == null) {
                    PizzaModifierSelectionDialog.this.e = true;
                    pOSToggleButton.setSelected(true);
                    PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                    this.setPizzaCrust(pizzaPrice.getCrust());
                }
                if (ticketItemModifier != null) {
                    String string = ticketItemModifier.getName();
                    String[] stringArray = string.split(" ");
                    String string2 = stringArray[1];
                    if (pizzaPrice.getCrust().getName().startsWith(string2)) {
                        PizzaModifierSelectionDialog.this.e = true;
                        pOSToggleButton.setSelected(true);
                        PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                        this.setPizzaCrust(pizzaPrice.getCrust());
                    }
                }
                pOSToggleButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                        PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                        SizeAndCrustSelectionPane.this.setPizzaCrust(pizzaPrice.getCrust());
                        if (PizzaModifierSelectionDialog.this.i() != null) {
                            PizzaModifierSelectionDialog.this.w.setSizeModifier(PizzaModifierSelectionDialog.this.i());
                            if (PizzaModifierSelectionDialog.this.w.getSizeModifier() == null) {
                                return;
                            }
                            PizzaModifierSelectionDialog.this.w.getSizeModifier().calculatePrice();
                            PizzaModifierSelectionDialog.this.z.updateView();
                            SizeAndCrustSelectionPane.this.revalidate();
                            SizeAndCrustSelectionPane.this.repaint();
                        }
                    }
                });
                this.g.add(pOSToggleButton);
                this.c.add(pOSToggleButton);
                this.e.add(pOSToggleButton);
            }
            this.e.revalidate();
            this.e.repaint();
            this.revalidate();
            this.repaint();
        }

        public MenuItemSize getMenuItemSize() {
            return this.h;
        }

        public void setMenuItemSize(MenuItemSize menuItemSize) {
            this.h = menuItemSize;
        }

        public PizzaCrust getPizzaCrust() {
            return this.i;
        }

        public void setPizzaCrust(PizzaCrust pizzaCrust) {
            this.i = pizzaCrust;
        }
    }

    public class Pizza
    extends JPanel {
        int a;

        public Pizza(LayoutManager layoutManager) {
            super(layoutManager);
            this.setOpaque(false);
            this.setBackground(Color.white);
            this.setPreferredSize(PosUIManager.getSize(200, 200));
        }

        public void setSize(int n) {
            this.a = n;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getHeight();
            int n2 = 30;
            int n3 = this.getWidth() - 2 * n2;
            int n4 = 0;
            if (n > n3) {
                n4 = n / 2 - n3 / 2;
            } else {
                n2 = (int)((double)(this.getWidth() - n) / 1.65);
                n4 = n / 15;
                n3 = n - this.getWidth() / n4;
            }
            n = n3;
            graphics.setColor(Color.WHITE);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(new Color(255, 251, 211));
            Ellipse2D.Double double_ = new Ellipse2D.Double(n2, n4, n3, n);
            graphics2D.fill(double_);
            Graphics2D graphics2D2 = (Graphics2D)graphics;
            graphics2D2.setColor(Color.green);
            Section section = PizzaModifierSelectionDialog.this.getSelectedSection();
            if (section == null) {
                return;
            }
            if (section.getSectionName().equalsIgnoreCase("Quarter 1")) {
                this.a(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Quarter 2")) {
                this.b(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Quarter 3")) {
                this.c(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Quarter 4")) {
                this.d(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Half 1")) {
                this.e(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Half 2")) {
                this.f(graphics2D2, n2, n4, n3);
            }
        }

        void a(Graphics graphics, int n, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.lightGray);
            graphics.drawOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
        }

        void a(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 90, 90);
        }

        void b(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 360, 90);
        }

        void c(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 180, 90);
        }

        void d(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 270, 90);
        }

        void e(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 90, 180);
        }

        void f(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 270, 180);
        }
    }

    private class Section
    extends JPanel
    implements MouseListener {
        boolean a;
        private boolean c;
        private PosButton d;
        private final String e;
        private final int f;
        private final String g;
        private final double h;
        private JTable i;
        private SectionModifierTableModel j;

        public Section(String string, String string2, int n, boolean bl, double d) {
            this.e = string;
            this.g = string2;
            this.f = n;
            this.c = bl;
            this.h = d;
            this.setLayout(new BorderLayout());
            this.d = new PosButton(string);
            this.d.setBackground(Color.LIGHT_GRAY);
            this.d.setHorizontalAlignment(0);
            this.d.setFont(this.d.getFont().deriveFont(1, 14.0f));
            this.d.setOpaque(true);
            this.setOpaque(false);
            this.setPreferredSize(PosUIManager.getSize(160, 135));
            this.setBorder(null);
            this.i = new JTable();
            this.i.setTableHeader(null);
            this.i.setRowHeight(PosUIManager.getSize(30));
            this.j = new SectionModifierTableModel();
            this.i.setDefaultRenderer(Object.class, new ModifierTableCellRenderer());
            this.i.setModel(this.j);
            JScrollPane jScrollPane = new JScrollPane(this.i);
            jScrollPane.setBorder(null);
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.setOpaque(false);
            jScrollPane.setOpaque(false);
            jScrollPane.setBorder(null);
            this.add((Component)jScrollPane, "Center");
            this.i.addMouseListener(this);
            this.resizeColumnWidth(this.i);
        }

        public void resizeColumnWidth(JTable jTable) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.a().get(i));
            }
        }

        private List a() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(70);
            arrayList.add(30);
            return arrayList;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AlphaComposite alphaComposite = (AlphaComposite)graphics2D.getComposite();
            AlphaComposite alphaComposite2 = alphaComposite.derive(0.75f);
            graphics2D.setComposite(alphaComposite2);
            super.paintComponent(graphics);
        }

        public boolean isEmpty() {
            return this.j.getRows().size() <= 0;
        }

        public void clearItems() {
            boolean bl = false;
            List<TicketItemModifier> list = PizzaModifierSelectionDialog.this.w.getTicketItemModifiers();
            if (list != null) {
                Iterator<TicketItemModifier> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TicketItemModifier ticketItemModifier = iterator.next();
                    if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                        if (!ticketItemModifier.getSectionName().equals(this.getSectionName())) continue;
                        iterator.remove();
                        PizzaModifierSelectionDialog.this.w.deleteTicketItemModifier(ticketItemModifier);
                        this.j.deleteGivenItem(ticketItemModifier);
                        continue;
                    }
                    bl = true;
                }
            }
            PizzaModifierSelectionDialog.this.z.updateView();
            this.i.repaint();
            this.repaint();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.84"));
            }
            PizzaModifierSelectionDialog.this.u = null;
        }

        public void clearSelectedItem() {
            boolean bl = false;
            if (this.j.getRows() == null) {
                return;
            }
            if (this.j.getRows().size() == 0) {
                return;
            }
            int n = this.i.getSelectedRow();
            if (n < 0) {
                return;
            }
            TicketItemModifier ticketItemModifier = (TicketItemModifier)this.j.getRowData(n);
            if (ticketItemModifier == null) {
                return;
            }
            if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                PizzaModifierSelectionDialog.this.w.deleteTicketItemModifier(ticketItemModifier);
                this.j.deleteGivenItem(ticketItemModifier);
                if (this.j.getRows().size() == 0) {
                    this.clearItems();
                }
            } else {
                bl = true;
            }
            PizzaModifierSelectionDialog.this.z.updateView();
            this.repaint();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.85"));
            }
            PizzaModifierSelectionDialog.this.u = null;
        }

        public void clearItem(TicketItemModifier ticketItemModifier, SectionModifierTableModel sectionModifierTableModel) {
            boolean bl = false;
            List list = sectionModifierTableModel.getRows();
            if (list == null || list.isEmpty()) {
                return;
            }
            if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                PizzaModifierSelectionDialog.this.w.deleteTicketItemModifierByName(ticketItemModifier);
                sectionModifierTableModel.deleteGivenItemByName(ticketItemModifier);
                if (list.size() == 0) {
                    this.clearItems();
                }
            } else {
                bl = true;
            }
            PizzaModifierSelectionDialog.this.z.updateView();
            this.repaint();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.86"));
            }
            PizzaModifierSelectionDialog.this.u = null;
        }

        public void setSelected(boolean bl) {
            this.a = bl;
            this.repaint();
        }

        public boolean isSelected() {
            return this.a;
        }

        public void addItem(TicketItemModifier ticketItemModifier) {
            this.j.addItem(ticketItemModifier);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PizzaModifierSelectionDialog.this.a(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        public String getSectionName() {
            return this.e;
        }

        public double getPrice() {
            return this.h;
        }

        public double calculatePrice(double d) {
            return d * this.getPrice();
        }
    }
}

