/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.db.update.UpdateDBTo101;
import com.floreantpos.db.update.UpdateDBTo104;
import com.floreantpos.db.update.UpdateDBTo122;
import com.floreantpos.db.update.UpdateDBTo129;
import com.floreantpos.db.update.UpdateDBTo135;
import com.floreantpos.db.update.UpdateDBTo151;
import com.floreantpos.db.update.UpdateDBTo160;
import com.floreantpos.db.update.UpdateDBTo165;
import com.floreantpos.db.update.UpdateDBTo171;
import com.floreantpos.db.update.UpdateDBTo185;
import com.floreantpos.db.update.UpdateDBTo188;
import com.floreantpos.db.update.UpdateDBTo194;
import com.floreantpos.db.update.UpdateDBTo207;
import com.floreantpos.db.update.UpdateDBTo209;
import com.floreantpos.db.update.UpdateDBTo210;
import com.floreantpos.db.update.UpdateDBTo213;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DefaultDataInserter;
import com.floreantpos.versioning.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

public class DatabaseUtil {
    public static final Integer DATABASE_VERSION = 223;
    private static Log a = LogFactory.getLog(DatabaseUtil.class);

    public static void checkConnection(String string, String string2, String string3, String string4, String string5) throws DatabaseConnectionException {
        try {
            Class.forName(string3);
            DriverManager.getConnection(string, string4, string5);
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException(Messages.getString("DatabaseUtil.0") + exception.getMessage());
        }
    }

    public static void initialize() throws DatabaseConnectionException {
        _RootDAO.initialize();
    }

    public static void initialize(String string) throws DatabaseConnectionException {
        _RootDAO.initialize(string);
    }

    public static void initialize(String string, String string2, String string3, String string4, String string5, String string6) {
        _RootDAO.initialize(string, string2, string3, string4, string5, string6);
    }

    public static void initialize(String string, Map<String, String> map) {
        _RootDAO.initialize(string, map);
    }

    public static void initialize(Map<String, String> map) {
        _RootDAO.initialize(map);
    }

    public static boolean createDatabase(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), string, string2, string3, string4, string5, bl, false);
    }

    public static boolean createDatabase(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), string, string2, string3, string4, string5, bl, bl2);
    }

    public static boolean createDatabase(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        try {
            _RootDAO.releaseConnection();
            StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder().configure(string);
            standardServiceRegistryBuilder.applySetting("hibernate.dialect", (Object)string3);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.driver_class", (Object)string4);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.url", (Object)string2);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.username", (Object)string5);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.password", (Object)string6);
            standardServiceRegistryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create");
            standardServiceRegistryBuilder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"0");
            standardServiceRegistryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
            StandardServiceRegistry standardServiceRegistry = standardServiceRegistryBuilder.build();
            Metadata metadata = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
            SchemaExport schemaExport = new SchemaExport();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE);
            schemaExport.create(enumSet, metadata);
            _RootDAO.setSessionFactory(metadata.buildSessionFactory());
            DefaultDataInserter defaultDataInserter = new DefaultDataInserter();
            defaultDataInserter.insertDefaultData(223, false);
            if (!bl) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
                return true;
            }
            if (bl2) {
                defaultDataInserter.createSampleTestData();
            } else {
                defaultDataInserter.createSampleData(false);
            }
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
            return true;
        }
        catch (Exception exception) {
            PosLog.error(DatabaseUtil.class, exception);
            a.error((Object)exception);
            return false;
        }
    }

    public static void updateLegacyDatabase() {
    }

    public static boolean updateDatabase(String string, String string2, String string3, String string4, String string5) {
        return DatabaseUtil.updateDatabase(Application.getInstance().getHibernateConfigurationFileName(), string, string2, string3, string4, string5);
    }

    public static boolean updateDatabase(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            Object object;
            Integer n;
            _RootDAO.releaseConnection();
            StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder().configure(string);
            standardServiceRegistryBuilder.applySetting("hibernate.dialect", (Object)string3);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.driver_class", (Object)string4);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.url", (Object)string2);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.username", (Object)string5);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.password", (Object)string6);
            standardServiceRegistryBuilder.applySetting("hibernate.max_fetch_depth", (Object)"3");
            standardServiceRegistryBuilder.applySetting("hibernate.connection.isolation", (Object)String.valueOf(1));
            standardServiceRegistryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
            StandardServiceRegistry standardServiceRegistry = standardServiceRegistryBuilder.build();
            Metadata metadata = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
            SchemaUpdate schemaUpdate = new SchemaUpdate();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
            schemaUpdate.execute(enumSet, metadata);
            SessionFactory sessionFactory = metadata.buildSessionFactory();
            _RootDAO.setSessionFactory(sessionFactory);
            Store store = StoreDAO.getRestaurant();
            Integer n2 = n = store == null ? null : store.getDatabaseVersion();
            if (n == null || n < 135) {
                object = new UpdateDBTo135(sessionFactory);
                ((UpdateDBTo135)object).update();
            }
            if (n == null || n < 101) {
                object = new UpdateDBTo101(string2, string5, string6, sessionFactory);
                ((UpdateDBTo101)object).update();
            }
            if (n == null || n < 104) {
                object = new UpdateDBTo104();
                ((UpdateDBTo104)object).update();
            }
            if (n == null || n < 122) {
                object = new UpdateDBTo122();
                ((UpdateDBTo122)object).update();
            }
            if (n == null || n < 129) {
                object = new UpdateDBTo129();
                ((UpdateDBTo129)object).update();
            }
            if (n == null || n < 151) {
                object = new UpdateDBTo151();
                ((UpdateDBTo151)object).update();
            }
            if (n == null || n < 160) {
                object = new UpdateDBTo160(sessionFactory);
                ((UpdateDBTo160)object).update();
            }
            if (n == null || n < 165) {
                object = new UpdateDBTo165();
                ((UpdateDBTo165)object).update(sessionFactory);
            }
            if (n == null || n < 171) {
                object = new UpdateDBTo171(sessionFactory);
                ((UpdateDBTo171)object).updateTickets();
                ((UpdateDBTo171)object).updateTransactions();
            }
            if (n == null || n < 185) {
                object = new UpdateDBTo185();
                ((UpdateDBTo185)object).update();
            }
            if (n == null || n < 188) {
                object = new UpdateDBTo188(schemaUpdate, enumSet, metadata, string3, sessionFactory, string5);
                ((UpdateDBTo188)object).update();
            }
            if (n == null || n < 195) {
                object = new UpdateDBTo194();
                ((UpdateDBTo194)object).update();
            }
            if (n == null || n < 208) {
                object = new UpdateDBTo207(string2, string5, string6);
                ((UpdateDBTo207)object).update();
            }
            if (n == null || n < 209) {
                object = new UpdateDBTo209(string2, string5, string6);
                ((UpdateDBTo209)object).update();
            }
            if (n == null || n < 210) {
                object = new UpdateDBTo210(string2, string5, string6);
                ((UpdateDBTo210)object).update();
            }
            if (n == null || n < 213) {
                object = new UpdateDBTo213();
                ((UpdateDBTo213)object).update();
            }
            if ((store = StoreDAO.getRestaurant()) != null) {
                store.setDatabaseVersion(223);
                store.setSoftwareVersion(VersionInfo.getVersion());
                store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
                StoreDAO.getInstance().update(store);
            }
            sessionFactory.close();
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
            return true;
        }
        catch (Exception exception) {
            PosLog.error(DatabaseUtil.class, exception);
            a.error((Object)exception);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded() {
        try {
            Store store = StoreDAO.getRestaurant();
            if (store == null) {
                throw new PosException(Messages.getString("DatabaseUtil.3") + Messages.getString("DatabaseUtil.4"));
            }
            Integer n = store.getDatabaseVersion();
            return n == null || n < 223;
        }
        catch (SQLGrammarException sQLGrammarException) {
            Pattern pattern;
            boolean bl;
            String string;
            Throwable throwable = sQLGrammarException.getCause();
            if (throwable != null && (string = throwable.getMessage()) != null && (bl = (pattern = Pattern.compile("Column .* is either not in any table")).matcher(string).find())) {
                return true;
            }
            a.error((Object)sQLGrammarException);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded(Integer n) {
        return n == null || n < 223;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getStoreProperties(String string, String string2, String string3, String string4) throws Exception {
        Class.forName(string2);
        try (Connection connection = null;){
            Object object;
            String string5 = Messages.getString("DatabaseUtil.6");
            string5 = String.format(string5, VersionInfo.getAppName());
            connection = DriverManager.getConnection(string, string3, string4);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string6 = DatabaseUtil.getActualTableName(databaseMetaData, "store_properties");
            if (string6 == null) {
                throw new PosException(string5);
            }
            String string7 = DatabaseUtil.getActualColumnName(databaseMetaData, string6, "property_name");
            String string8 = DatabaseUtil.getActualColumnName(databaseMetaData, string6, "property_value");
            if (string7 == null || string8 == null) {
                throw new PosException(string5);
            }
            String string9 = String.format("select * from %s", string6);
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string9);
            while (resultSet.next()) {
                object = resultSet.getString(string7);
                String string10 = resultSet.getString(string8);
                hashMap.put(object, string10);
            }
            resultSet.close();
            statement.close();
            object = hashMap;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTable(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        try (ResultSet resultSet = null;){
            resultSet = databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                arrayList.add(string2.toLowerCase());
            }
            if (arrayList.contains(string.toLowerCase())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualTableName(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        try (ResultSet resultSet = null;){
            String string2;
            resultSet = databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                string2 = resultSet.getString("TABLE_NAME");
                if (!string2.equalsIgnoreCase(string)) continue;
                String string3 = string2;
                return string3;
            }
            string2 = null;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualColumnName(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        try (ResultSet resultSet = null;){
            String string3;
            resultSet = databaseMetaData.getColumns(null, null, string, null);
            while (resultSet.next()) {
                string3 = resultSet.getString("COLUMN_NAME");
                if (!string3.equalsIgnoreCase(string2)) continue;
                String string4 = string3;
                return string4;
            }
            string3 = null;
            return string3;
        }
    }
}

