/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.GroupSettleTicketDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public class GroupSettleTicketAction
extends PosAction {
    private List<Ticket> a;
    private User b;

    public GroupSettleTicketAction(User user) {
        this.b = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public GroupSettleTicketAction(List<Ticket> list, User user) {
        this.a = list;
        this.b = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public GroupSettleTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.GROUP_SETTLE_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    @Override
    public void execute() {
        try {
            List<Ticket> list;
            Serializable serializable;
            if (!POSUtil.checkDrawerAssignment(DataProvider.get().getCurrentTerminal(), this.getCurrentUser())) {
                return;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            if (this.a == null || this.a.isEmpty()) {
                serializable = new StyledTicketSelectionDialog(true);
                serializable.openFullScreen();
                if (serializable.isCanceled()) {
                    return;
                }
                list = serializable.getSelectedTickets();
                if (list == null) {
                    return;
                }
                for (Ticket ticket : list) {
                    Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                    OrderType orderType = ticket2.getOrderType();
                    if (orderType != null && orderType.isBarTab().booleanValue()) continue;
                    arrayList.add(ticket2);
                }
            } else {
                arrayList.addAll(this.a);
            }
            serializable = this.b;
            if (serializable == null) {
                serializable = Application.getCurrentUser();
            }
            list = new GroupSettleTicketDialog(arrayList, (User)serializable);
            ((Window)((Object)list)).setSize(Application.getPosWindow().getSize());
            ((JDialog)((Object)list)).setDefaultCloseOperation(2);
            ((POSDialog)((Object)list)).openUndecoratedFullScreen();
            if (((POSDialog)((Object)list)).isCanceled()) {
                return;
            }
            this.a(arrayList);
            if (this.listener != null) {
                this.listener.dataSetUpdated();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    protected User getCurrentUser() {
        if (this.b == null) {
            return Application.getCurrentUser();
        }
        return this.b;
    }

    private void a(List<Ticket> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Group settle tickets: ");
        Object object = list.iterator();
        while (object.hasNext()) {
            Ticket ticket = object.next();
            stringBuilder.append(ticket.getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 255) {
            object = ((String)object).substring(0, 255);
        }
        ActionHistoryDAO.saveHistory("Group settle", (String)object);
    }
}

