/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Dialog;
import java.awt.Window;

public class StaffBankCloseAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private CashDrawer a;
    private User b;

    public StaffBankCloseAction(CashDrawer cashDrawer, User user) {
        super(Messages.getString("CloseStaffBank"));
        this.a = cashDrawer;
        this.b = user;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("StaffBankCloseAction.1"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return;
            }
            this.performCloseStaffBank();
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performCloseStaffBank() throws Exception {
        Object object;
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.a);
        cashDrawerReportService.populateReport();
        Double d = 0.0;
        DataProvider dataProvider = DataProvider.get();
        if (dataProvider.getStore().isUseDetailedReconciliation().booleanValue()) {
            object = new CashReconciliationDialog(this.a);
            ((Window)object).pack();
            ((CashReconciliationDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((CashReconciliationDialog)object).getTotalReconcilieAmount();
        } else if (dataProvider.getCurrentTerminal().isEnableMultiCurrency().booleanValue()) {
            object = new MultiCurrencyAmountSelectionDialog(this.a, this.a.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            ((Dialog)object).setTitle(Messages.getString("StaffBankCloseAction.3"));
            ((OkCancelOptionDialog)object).setCaption(Messages.getString("StaffBankCloseAction.4"));
            ((MultiCurrencyAmountSelectionDialog)object).setReconcile(true);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((MultiCurrencyAmountSelectionDialog)object).getTotalAmount();
        } else {
            d = this.a(this.a);
            if (d.isNaN()) {
                return;
            }
        }
        this.a.setCashToDeposit(d);
        object = new TerminalDAO();
        ((TerminalDAO)object).resetStaffBank(this.b, this.a);
        Application.getInstance().refreshCurrentUser();
        this.updateActionText();
        PosPrintService.printDrawerPullReport(this.a);
    }

    public void performForceCloseStaffBank(User user) throws Exception {
        try {
            CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.a);
            cashDrawerReportService.populateReport();
            this.a.setCashToDeposit(0.0);
            TerminalDAO terminalDAO = new TerminalDAO();
            terminalDAO.resetStaffBank(user, this.a);
            Application.getInstance().refreshCurrentUser();
            this.updateActionText();
            PosPrintService.printDrawerPullReport(this.a);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("StaffBankCloseAction.5") + printerIsNotConfiguredException.getMessage());
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private Double a(CashDrawer cashDrawer) {
        double d;
        String string;
        String string2 = Messages.getString("StaffBankCloseAction.6");
        Double d2 = NumberSelectionDialog2.takeDoubleInput(string2, string = Messages.getString("StaffBankCloseAction.7"), d = this.b.isBlindAccountableAmount() != false ? 0.0 : NumberUtil.roundToTwoDigit(cashDrawer.getDrawerAccountable()));
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 < cashDrawer.getDrawerAccountable()) {
            String string3 = Messages.getString("StaffBankCloseAction.8");
            String string4 = Messages.getString("CONFIRM");
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string3, string4) == 0) {
                return d2;
            }
            return this.a(cashDrawer);
        }
        return d2;
    }
}

