/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;

public class TicketEditAction
extends PosAction {
    private Ticket a;

    public TicketEditAction() {
        super(POSConstants.EDIT_TICKET_BUTTON_TEXT);
    }

    public TicketEditAction(Ticket ticket) {
        super(POSConstants.EDIT_TICKET_BUTTON_TEXT);
        this.a = ticket;
    }

    public TicketEditAction(DataChangeListener dataChangeListener) {
        super(POSConstants.EDIT_TICKET_BUTTON_TEXT, dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            Ticket ticket = this.a();
            if (ticket == null) {
                return;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (!this.hasPermissionToAccessTicket(ticket)) {
                return;
            }
            Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            if (ticket2.isClosed().booleanValue()) {
                ticket2.setClosed(false);
                ticket2.setReOpened(true);
            }
            OrderView.getInstance().setCurrentTicket(ticket2);
            RootView.getInstance().showView("ORDER_VIEW");
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private Ticket a() {
        if (this.a != null) {
            return this.a;
        }
        Object object = this.getSelectedObject();
        if (object == null) {
            return null;
        }
        if (object instanceof Ticket) {
            return (Ticket)object;
        }
        return TicketService.getTicket((String)object);
    }
}

