/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.ReorderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketReorderAction
extends PosAction {
    private Ticket a;
    private boolean b;

    public TicketReorderAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public TicketReorderAction(Ticket ticket, UserPermission userPermission) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, userPermission);
        this.a = ticket;
    }

    public TicketReorderAction(DataChangeListener dataChangeListener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            if (!this.getCurrentUser().hasPermission(this.requiredPermission)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketReorderAction.0"), Messages.getString("TicketReorderAction.1"));
            if (n != 0) {
                return;
            }
            Ticket ticket = DataProvider.get().getTicketToBeCreated();
            if (ticket != null) {
                ticket.setCustomer(this.a.getCustomer());
                this.a(this.a, ticket.getOrderType(), ticket);
            } else {
                OrderTypeSelectionDialog orderTypeSelectionDialog = new OrderTypeSelectionDialog();
                orderTypeSelectionDialog.open();
                if (orderTypeSelectionDialog.isCanceled()) {
                    return;
                }
                OrderType orderType = orderTypeSelectionDialog.getSelectedOrderType();
                this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
                this.a(this.a, orderType, null);
            }
            this.b = true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, OrderType orderType, Ticket ticket2) {
        Serializable serializable;
        Serializable serializable2;
        if (ticket == null) {
            throw new PosException(Messages.getString("TicketReorderAction.2"));
        }
        Ticket ticket3 = ticket2;
        if (ticket2 == null) {
            ticket3 = new Ticket(true);
            ticket3.setOrderType(orderType);
        }
        if (ticket2 == null && orderType.isShowTableSelection().booleanValue()) {
            serializable2 = TableSelectorFactory.createTableSelectorDialog(orderType);
            TableSelectionView tableSelectionView = ((TableSelectorDialog)serializable2).getTableSelector();
            tableSelectionView.setHomeViewMode(Boolean.FALSE);
            tableSelectionView.setShouldReorder(Boolean.TRUE);
            tableSelectionView.setReorderType(ReorderType.TICKET_REORDER);
            ((TableSelectorDialog)serializable2).setCreateNewTicket(false);
            ((TableSelectorDialog)serializable2).updateView(true);
            ((POSDialog)serializable2).openUndecoratedFullScreen();
            tableSelectionView.setReorderType(null);
            tableSelectionView.setShouldReorder(Boolean.FALSE);
            if (((POSDialog)serializable2).isCanceled()) {
                return;
            }
            List<ShopTable> object3 = ((TableSelectorDialog)serializable2).getSelectedTables();
            serializable = new ArrayList();
            for (Object object : object3) {
                SalesArea salesArea = ((ShopTable)object).getSalesArea();
                if (salesArea != null) {
                    ticket3.setSalesArea(salesArea);
                    ticket3.setSalesAreaId(salesArea.getId());
                }
                serializable.add(((BaseShopTable)object).getId());
            }
            ticket3.setTableNumbers((List<Integer>)((Object)serializable));
        }
        serializable2 = new ArrayList();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            Object object;
            if (ticketItem.isVoided().booleanValue() || ticketItem.isTreatAsSeat().booleanValue()) continue;
            serializable = ticketItem.cloneAsNew();
            ((BaseTicketItem)serializable).setTicket(ticket3);
            serializable2.add(serializable);
            MenuItem menuItem = ((TicketItem)serializable).getMenuItem();
            if (menuItem != null) {
                if (!menuItem.isEditablePrice().booleanValue()) {
                    ((BaseTicketItem)serializable).setUnitPrice(menuItem.getPrice());
                }
                MenuItem.setItemTaxes((TicketItem)serializable, menuItem.getTaxGroup(ticket3.getCustomer()), ticket3.getOrderType());
            }
            if ((object = ((TicketItem)serializable).getTicketItemModifiers()) == null) continue;
            object.forEach(arg_0 -> TicketReorderAction.a(orderType, (TicketItem)serializable, arg_0));
        }
        ticket3.getTicketItems().addAll((Collection<TicketItem>)((Object)serializable2));
        if (ticket3.getCustomer() == null) {
            ticket3.setCustomer(ticket.getCustomer());
        }
        OrderView.getInstance().setCurrentTicket(ticket3);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    public boolean isReorder() {
        return this.b;
    }

    private static /* synthetic */ void a(OrderType orderType, TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        MenuModifier menuModifier;
        String string = ticketItemModifier.getItemId();
        MenuModifier menuModifier2 = menuModifier = StringUtils.isBlank((String)string) ? null : MenuModifierDAO.getInstance().get(string);
        if (menuModifier != null) {
            ticketItemModifier.setUnitPrice(menuModifier.getPrice());
            List<TicketItemTax> list = menuModifier.getTaxByOrderType(orderType, ticketItem);
            if (list != null) {
                ticketItemModifier.getTaxes().clear();
                ticketItemModifier.getTaxes().addAll(list);
            }
        }
    }
}

