/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TicketTransferAction
extends PosAction {
    private Ticket a;
    private boolean b = false;
    private User c;

    public TicketTransferAction() {
        super(Messages.getString("TicketTransferAction.0"));
    }

    public TicketTransferAction(Ticket ticket, User user) {
        super(Messages.getString("TicketTransferAction.0"));
        this.a = ticket;
        this.c = user;
    }

    public TicketTransferAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("TicketTransferAction.0"), dataChangeListener);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            User user;
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            if (this.a.isClosed().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Closed ticket cannot be transferred.");
                return;
            }
            if (this.a.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketTransferAction.3"), Messages.getString("TicketTransferAction.4"));
            if (n != 0) {
                return;
            }
            this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            User user2 = this.c;
            if (user2 == null) {
                user2 = Application.getCurrentUser();
            }
            if (!user2.equals(user = this.a.getOwner()) && !user2.hasPermission(UserPermission.TRANSFER_TICKET)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderInfoDialog.4") + this.a.getId());
                return;
            }
            User user3 = this.a(user);
            if (user3 == null) {
                return;
            }
            TicketTransferAction.doTransferTickets(Application.getCurrentUser(), user3, Arrays.asList(this.a));
            this.b = true;
            POSMessageDialog.showMessage(Messages.getString("TicketTransferAction.5"));
            if (this.listener != null) {
                this.listener.dataChanged(this.a);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private User a(User user) {
        UserListDialog userListDialog = new UserListDialog();
        userListDialog.hideUser(user);
        userListDialog.setTitle(Messages.getString("UserTransferDialog.0"));
        userListDialog.setCaption(Messages.getString("UserTransferDialog.1"));
        userListDialog.setSize(PosUIManager.getSize(400, 600));
        userListDialog.open();
        if (userListDialog.isCanceled()) {
            return null;
        }
        User user2 = userListDialog.getSelectedUser();
        return user2;
    }

    public static void doTransferTickets(User user, User user2, List<Ticket> list) {
        if (user2 == null || list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            for (Ticket ticket : list) {
                User user3 = ticket.getOwner();
                ticket.setOwner(user2);
                ticket.setShouldUpdateTableStatus(true);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                TicketTransferAction.a(user, user3, user2, session, ticket);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    private static void a(User user, User user2, User user3, Session session, Ticket ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ticket: " + ticket.getId());
        stringBuilder.append(". From staff: " + user2.getId() + "/" + user2.getFirstName());
        stringBuilder.append(". To staff: " + user3.getId() + "/" + user3.getFirstName());
        ActionHistoryDAO.saveHistory(user, ticket, null, "Transfer ticket", stringBuilder.toString(), session);
    }

    public boolean isTransfered() {
        return this.b;
    }
}

