/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.PriceExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class PriceExplorerAction
extends AbstractAction {
    public PriceExplorerAction() {
        super(Messages.getString("PriceExplorerAction.0"));
    }

    public PriceExplorerAction(String string) {
        super(string);
    }

    public PriceExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            PriceExplorer priceExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(Messages.getString("PriceExplorerAction.0"));
            if (n == -1) {
                priceExplorer = new PriceExplorer();
                jTabbedPane.addTab(Messages.getString("PriceExplorerAction.0"), priceExplorer);
            } else {
                priceExplorer = (PriceExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(priceExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

