/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrintException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import java.util.List;

public class TicketPrintAction
extends PosAction {
    private OrderInfoView a;
    private SettleTicketProcessor b;
    private List<Ticket> c;

    public TicketPrintAction(OrderInfoView orderInfoView, SettleTicketProcessor settleTicketProcessor, List<Ticket> list) {
        this.a = orderInfoView;
        this.b = settleTicketProcessor;
        this.c = list;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.event = actionEvent;
            if (this.c == null) {
                return;
            }
            Store store = DataProvider.get().getStore();
            boolean bl = POSUtil.getBoolean(store.getProperty("additional_print_requires.manager_approval"));
            boolean bl2 = false;
            if (bl) {
                for (Ticket ticket : this.c) {
                    int n = POSUtil.getIntegerOrZero(ticket.getProperty("printCount"));
                    if (n <= 0) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                User user = this.getCurrentUser();
                if (user == null) {
                    return;
                }
                this.authorizedUser = user;
                if (!this.hasPermission(user, UserPermission.PERFORM_MANAGER_TASK)) {
                    return;
                }
                this.execute();
            } else {
                this.execute();
            }
        }
        catch (PrintException printException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), printException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void execute() throws Exception {
        if (ReceiptPrintService.hasNoReceiptPrinters()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
            return;
        }
        if (this.a != null) {
            this.a.printCopy("Customer Copy");
        } else if (this.b != null && this.c != null) {
            this.b.printTicket(this.c.get(0), false);
        } else {
            for (Ticket ticket : this.c) {
                ReceiptPrintService.printTicket(ticket, false);
            }
        }
    }
}

