/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.OrderTypeForm;
import javax.swing.table.DefaultTableCellRenderer;

public class OrderTypeExplorer
extends BeanTableExplorerView<OrderType> {
    public OrderTypeExplorer() {
        super(OrderType.class);
    }

    @Override
    public void initTableModel(BeanTableModel<OrderType> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME.toUpperCase(), OrderType.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("OrderTypeExplorer.0"), OrderType.PROP_SHOW_TABLE_SELECTION);
        beanTableModel.addColumn(Messages.getString("OrderTypeExplorer.2"), OrderType.PROP_SHOW_GUEST_SELECTION);
        beanTableModel.addColumn(POSConstants.PRINT_TO_KITCHEN, OrderType.PROP_SHOULD_PRINT_TO_KITCHEN);
        beanTableModel.addColumn(POSConstants.ENABLED.toUpperCase(), OrderType.PROP_ENABLED);
        beanTableModel.addColumn(Messages.getString("OrderTypeExplorer.4"), OrderType.PROP_PRE_AUTH_CREDIT_CARD);
    }

    @Override
    public void initData() {
        this.setRows(OrderTypeDAO.getInstance().findAll());
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new CustomCellRenderer();
    }

    @Override
    public OrderType createNew() {
        return this.openNewForm(new OrderTypeForm(), 800, 600);
    }

    @Override
    public OrderType editSelectedRow(OrderType orderType) {
        OrderTypeDAO.getInstance().refresh(orderType);
        this.checkDataValidation(orderType.isDeleted(), orderType.getName());
        return this.openEditForm(new OrderTypeForm(orderType), 800, 600);
    }

    @Override
    public boolean delete(OrderType orderType) {
        OrderTypeDAO orderTypeDAO = OrderTypeDAO.getInstance();
        orderTypeDAO.refresh(orderType);
        this.checkDataValidation(orderType.isDeleted(), orderType.getName());
        if (!orderTypeDAO.canDelete(orderType)) {
            String string = Messages.getString("OrderTypeExplorer.5");
            POSMessageDialog.showError(this, string);
            return false;
        }
        orderTypeDAO.delete(orderType);
        POSMessageDialog.showMessage(this, Messages.getString("TerminalConfigurationView.40"));
        return true;
    }
}

