/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceTableForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class PriceTableExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<PriceTable> b = new BeanTableModel(PriceTable.class);

    public PriceTableExplorer() {
        this.b.addColumn(POSConstants.NAME, PriceTable.PROP_NAME);
        this.b.addColumn(POSConstants.DESCRIPTION, PriceTable.PROP_DESCRIPTION);
        this.b.addColumn("LAST UPDATED TIME", PriceTable.PROP_LAST_UPDATE_TIME);
        this.b.addColumn("UPDATED BY", PriceTable.PROP_LAST_UPDATED_BY);
        this.b.addRows(PriceTableDAO.getInstance().findAll());
        this.a = new JXTable(this.b);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PriceTableExplorer.this.openPriceList(false, null);
                }
            }
        });
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.a.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){
            private SimpleDateFormat b = new SimpleDateFormat("MMM dd, YYYY hh:mm a");

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Date date = (Date)object;
                this.setHorizontalAlignment(0);
                if (date != null) {
                    object = this.b.format(date);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.a();
    }

    private void a() {
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(actionEvent -> this.b());
        JButton jButton2 = new JButton(POSConstants.DETAILS);
        jButton2.addActionListener(actionEvent -> this.openPriceList(true, actionEvent.getActionCommand()));
        JButton jButton3 = new JButton(POSConstants.EDIT);
        jButton3.addActionListener(actionEvent -> this.openPriceList(false, actionEvent.getActionCommand()));
        JButton jButton4 = new JButton(POSConstants.DELETE);
        jButton4.addActionListener(actionEvent -> this.c());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        this.add((Component)transparentPanel, "South");
    }

    public void openPriceList(boolean bl, String string) {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                if (string == null || string.equals(POSConstants.EDIT)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                } else {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToShowDetails"));
                }
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            PriceTable priceTable = this.b.getRow(n);
            PriceTableForm priceTableForm = new PriceTableForm(priceTable);
            priceTableForm.setEditable(!bl);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)priceTableForm);
            if (bl) {
                beanEditorDialog.getButtonPanel().remove(0);
            }
            beanEditorDialog.openWithScale(650, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void b() {
        try {
            PriceTableForm priceTableForm = new PriceTableForm(new PriceTable());
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)priceTableForm);
            beanEditorDialog.openWithScale(650, 600);
            PriceTable priceTable = (PriceTable)priceTableForm.getBean();
            if (beanEditorDialog.isCanceled() && priceTable.getId() == null) {
                return;
            }
            this.b.addRow(priceTable);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            PriceTable priceTable = this.b.getRow(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            PriceTableDAO priceTableDAO = new PriceTableDAO();
            priceTableDAO.delete(priceTable);
            this.b.removeRow(n);
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

