/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.Tax;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.model.TaxForm;
import javax.swing.table.DefaultTableCellRenderer;

public class TaxExplorer
extends BeanTableExplorerView<Tax> {
    public TaxExplorer() {
        super(Tax.class);
    }

    @Override
    public void initTableModel(BeanTableModel<Tax> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, Tax.PROP_NAME);
        beanTableModel.addColumn(POSConstants.RATE, Tax.PROP_RATE);
    }

    @Override
    public void initData() {
        this.setRows(TaxDAO.getInstance().findAll());
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public Tax createNew() {
        return this.openNewForm(new TaxForm());
    }

    @Override
    public Tax editSelectedRow(Tax tax) {
        TaxDAO.getInstance().refresh(tax);
        this.checkDataValidation(tax.isDeleted(), tax.getName());
        return this.openEditForm(new TaxForm(tax));
    }

    @Override
    public boolean delete(Tax tax) {
        TaxDAO.getInstance().refresh(tax);
        this.checkDataValidation(tax.isDeleted(), tax.getName());
        TaxDAO.getInstance().delete(tax);
        return true;
    }
}

