/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CategoryBreakOut;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"assignedUser", "assignedBy", "closedBy", "terminal", "storeOperationData"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class CashDrawer
extends BaseCashDrawer
implements TimedModel {
    private static final long serialVersionUID = 1L;
    protected transient DrawerType drawerType;
    private transient Double cardVoidAmount;
    private transient StoreSession storeSession;
    private transient Double promotionAmount;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Set<DrawerPullVoidEntry> voidEntries;
    private List<CategoryBreakOut> categoryBreakOut;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Transient
    public User getAssignedUser() {
        if (this.getAssignedUserId() == null) {
            return null;
        }
        return (User)DataProvider.get().getObjectOf(User.class, (Serializable)((Object)this.getAssignedUserId()));
    }

    @Transient
    public void setAssignedUser(User user) {
        if (user == null) {
            this.setAssignedUserId(null);
        } else {
            this.setAssignedUserId(user.getId());
        }
    }

    @Transient
    public User getAssignedBy() {
        return DataProvider.get().getUserById(this.getAssignedByUserId());
    }

    public void setAssignedBy(User user) {
        if (user == null) {
            this.setAssignedByUserId(null);
        } else {
            this.setAssignedByUserId(user.getId());
        }
    }

    @Transient
    public User getClosedBy() {
        return DataProvider.get().getUserById(this.getClosedByUserId());
    }

    @Transient
    public void setClosedBy(User user) {
        if (user == null) {
            this.setClosedByUserId(null);
        } else {
            this.setClosedByUserId(user.getId());
        }
    }

    @Transient
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    @Transient
    public void setTerminal(Terminal terminal) {
        if (terminal == null) {
            this.setTerminalId(null);
        } else {
            this.setTerminalId(terminal.getId());
        }
    }

    public DrawerType getDrawerType() {
        return DrawerType.fromInt(super.getType());
    }

    public void setDrawerType(DrawerType drawerType) {
        super.setType(drawerType.getTypeNumber());
    }

    public double getGiftCardAddBalance() {
        Map<String, Double> map = super.getOtherRevenueCategory();
        if (map == null) {
            return 0.0;
        }
        Set<String> set = map.keySet();
        double d = 0.0;
        for (String string : set) {
            d += map.get(string).doubleValue();
        }
        return d;
    }

    public CashBreakdown getCurrencyBalance(Currency currency) {
        List<CashBreakdown> list = this.getCashBreakdownList();
        if (list != null) {
            for (CashBreakdown cashBreakdown : list) {
                if (!currency.equals(cashBreakdown.getCurrency())) continue;
                return cashBreakdown;
            }
        }
        CashBreakdown cashBreakdown = new CashBreakdown();
        cashBreakdown.setCurrency(currency);
        cashBreakdown.setCashDrawer(this);
        this.addTocashBreakdownList(cashBreakdown);
        return cashBreakdown;
    }

    public void setGiftCardAddBalance(double d) {
    }

    public void setPayOutNumber(Integer n) {
    }

    public String getCashReceiptNumber() {
        return "";
    }

    public void setCashReceiptNumber(String string) {
    }

    public String getCreditCardReceiptNumber() {
        return "";
    }

    public void setCreditCardReceiptNumber(String string) {
    }

    public String getDrawerBleedNumber() {
        return "";
    }

    public void setDebitCardReceiptNumber(String string) {
    }

    public String getDebitCardReceiptNumber() {
        return "";
    }

    public void setDrawerBleedNumber(String string) {
    }

    public Integer getPayOutNumber() {
        return 0;
    }

    public void addCurrencyBalances(List<CashBreakdown> list) {
        this.getCashBreakdownList().addAll(list);
    }

    @Override
    public List<CashBreakdown> getCashBreakdownList() {
        List<CashBreakdown> list = super.getCashBreakdownList();
        if (list == null) {
            list = new ArrayList<CashBreakdown>();
            super.setCashBreakdownList(list);
        }
        return list;
    }

    public void calculate() {
        this.setTotalRevenue(this.getNetSales() + this.getSalesTax() - this.getTotalDiscountAmount());
        this.setGrossReceipts(this.getTotalRevenue() + this.getCashTips() + this.getChargedTips());
        double d = this.getCashReceiptAmount() + this.getCreditCardReceiptAmount() + this.getDebitCardReceiptAmount() + this.getGiftCertReturnAmount() + this.getCustomPaymentAmount() - this.getGiftCertChangeAmount() - this.getRefundAmount() - this.getCardVoidAmount() - this.getCustomerPaymentAmount();
        this.setReceiptDifferential(NumberUtil.roundToTwoDigit(this.getGrossReceipts() - d));
        this.setTipsDifferential(this.getCashTips() + this.getChargedTips() - this.getTipsPaid());
        double d2 = this.getCashReceiptAmount();
        double d3 = this.getTipsPaid();
        double d4 = this.getPayOutAmount();
        double d5 = this.getBeginCash();
        double d6 = this.getRefundAmount();
        double d7 = this.getDrawerBleedAmount();
        double d8 = d5 + d2 - d3 - d4 - d6 - d7;
        this.setDrawerAccountable(d8);
    }

    public Set<DrawerPullVoidEntry> getVoidEntries() {
        if (this.getId() == null) {
            return this.voidEntries;
        }
        this.voidEntries = new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(this));
        if (this.voidEntries != null) {
            double d = 0.0;
            for (DrawerPullVoidEntry drawerPullVoidEntry : this.voidEntries) {
                d += drawerPullVoidEntry.getAmount().doubleValue();
            }
            this.setTotalVoid(d);
        }
        return this.voidEntries;
    }

    public void setVoidEntries(Set<DrawerPullVoidEntry> set) {
        this.voidEntries = set;
        if (set != null) {
            double d = 0.0;
            for (DrawerPullVoidEntry drawerPullVoidEntry : set) {
                d += drawerPullVoidEntry.getAmount().doubleValue();
            }
            this.setTotalVoid(d);
        }
    }

    public void setCategoryBreakOut(List<CategoryBreakOut> list) {
        this.categoryBreakOut = list;
    }

    public List<CategoryBreakOut> getCategoryBreakOut() {
        return this.categoryBreakOut;
    }

    public boolean isOpen() {
        return this.getReportTime() == null;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public Double getCardVoidAmount() {
        return this.cardVoidAmount == null ? new Double(0.0) : this.cardVoidAmount;
    }

    public void setCardVoidAmount(Double d) {
        this.cardVoidAmount = d;
    }

    public StoreSession getStoreSession() {
        if (StringUtils.isEmpty((String)this.getStoreSessionId())) {
            return null;
        }
        if (this.storeSession != null && StringUtils.equals((String)this.storeSession.getId(), (String)this.getStoreSessionId())) {
            return this.storeSession;
        }
        return (StoreSession)DataProvider.get().getObjectOf(StoreSession.class, (Serializable)((Object)this.getStoreSessionId()));
    }

    public void setStoreSession(StoreSession storeSession) {
        if (storeSession == null) {
            this.storeSession = null;
            this.setStoreSessionId(null);
        } else {
            this.storeSession = storeSession;
            this.setStoreSessionId(storeSession.getId());
        }
    }

    @Deprecated
    public StoreSession getStoreOperationData() {
        if (StringUtils.isEmpty((String)this.getStoreSessionId())) {
            return null;
        }
        if (this.storeSession != null && StringUtils.equals((String)this.storeSession.getId(), (String)this.getStoreSessionId())) {
            return this.storeSession;
        }
        return (StoreSession)DataProvider.get().getObjectOf(StoreSession.class, (Serializable)((Object)this.getStoreSessionId()));
    }

    @Deprecated
    public void setStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            this.storeSession = null;
            this.setStoreSessionId(null);
        } else {
            this.storeSession = storeSession;
            this.setStoreSessionId(storeSession.getId());
        }
    }

    public Double getPromotionAmount() {
        return this.promotionAmount == null ? Double.valueOf(0.0) : this.promotionAmount;
    }

    public void setPromotionAmount(Double d) {
        this.promotionAmount = d;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

