/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.base.BaseSubRecipe;
import com.floreantpos.util.NumberUtil;
import java.util.List;

public class SubRecipe
extends BaseSubRecipe {
    private static final long serialVersionUID = 1L;
    private Double cost;

    public Double getCost() {
        this.calculateCost();
        this.cost = NumberUtil.roundToTwoDigit(this.cost);
        return this.cost == null ? 0.0 : this.cost;
    }

    public void setCost(Double d) {
        this.cost = d;
    }

    private void calculateCost() {
        List<RecepieItem> list;
        double d = 0.0;
        double d2 = 0.0;
        Recepie recepie = this.getRecipe();
        if (recepie != null && (list = recepie.getRecepieItems()) != null && list.size() > 0) {
            for (RecepieItem recepieItem : list) {
                recepieItem.calculatePercentage();
                d2 += recepieItem.getCost();
            }
        }
        d = d2 * this.getPortion() / recepie.getYield();
        this.setCost(d);
    }

    public String getName() {
        Recepie recepie = this.getRecipe();
        if (recepie != null) {
            return recepie.getName();
        }
        return "";
    }

    public Double getYield() {
        Recepie recepie = this.getRecipe();
        if (recepie != null) {
            return recepie.getYield();
        }
        return 1.0;
    }
}

