/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.dao.BaseDeliveryAddressDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DeliveryAddressDAO
extends BaseDeliveryAddressDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateDeliveryAddressList(List<DeliveryAddress> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (DeliveryAddress deliveryAddress : list) {
                DeliveryAddress deliveryAddress2 = this.get(deliveryAddress.getId());
                if (deliveryAddress2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(deliveryAddress.getLastUpdateTime(), deliveryAddress2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), deliveryAddress.getId() + " already updated");
                        continue;
                    }
                    long l = deliveryAddress2.getVersion();
                    PropertyUtils.copyProperties((Object)deliveryAddress2, (Object)deliveryAddress);
                    deliveryAddress2.setVersion(l);
                    deliveryAddress2.setUpdateLastUpdateTime(bl);
                    deliveryAddress2.setUpdateSyncTime(bl2);
                    this.update(deliveryAddress2, session);
                    continue;
                }
                deliveryAddress.setUpdateLastUpdateTime(bl);
                deliveryAddress.setUpdateSyncTime(bl2);
                this.save(deliveryAddress, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

