/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.BaseGiftCardDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class GiftCardDAO
extends BaseGiftCardDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof GiftCard) {
            GiftCard giftCard = (GiftCard)object;
            giftCard.setDeleted(Boolean.TRUE);
            super.update(giftCard, session);
        } else {
            super.delete(object, session);
        }
    }

    @Override
    public List<GiftCard> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveAsList(List<GiftCard> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (GiftCard giftCard : list) {
                String string = giftCard.getCardNumber();
                if (string == null) {
                    throw new PosException(Messages.getString("GiftCardDAO.0"));
                }
                GiftCard giftCard2 = (GiftCard)session.get(GiftCard.class, (Serializable)((Object)string));
                if (giftCard2 == null) {
                    string = string.replaceAll("-", "");
                    giftCard.setCardNumber(string);
                    this.save(giftCard, session);
                    continue;
                }
                giftCard2.setOwnerName(giftCard.getOwnerName());
                giftCard2.setBalance(giftCard.getBalance());
                giftCard2.setIssueDate(giftCard.getIssueDate());
                giftCard2.setActivationDate(giftCard.getActivationDate());
                giftCard2.setDeActivationDate(giftCard.getDeActivationDate());
                giftCard2.setExpiryDate(giftCard.getExpiryDate());
                giftCard2.setActive(giftCard.isActive());
                giftCard2.setDisable(giftCard.isDisable());
                giftCard2.setDurationType(giftCard.getDurationType());
                giftCard2.setDuration(giftCard.getDuration());
                giftCard2.setPinNumber(giftCard.getPinNumber());
                giftCard2.setPoint(giftCard.getPoint());
                giftCard2.setBatchNo(giftCard.getBatchNo());
                giftCard2.setEmail(giftCard.getEmail());
                giftCard2.setType(giftCard.getType());
                this.update(giftCard2, session);
            }
            transaction.commit();
        }
    }

    public GiftCard findByCardNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_CARD_NUMBER, (Object)string));
                if (criteria.list().isEmpty()) {
                    GiftCard giftCard = null;
                    return giftCard;
                }
                GiftCard giftCard = (GiftCard)criteria.list().get(0);
                return giftCard;
            }
            GiftCard giftCard = null;
            return giftCard;
        }
    }

    public void searchByCardAndIssueDate(String string, String string2, Date date, Date date2, String string3, PaginationSupport paginationSupport) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (date != null && date2 != null) {
                criteria.add(Restrictions.between((String)GiftCard.PROP_ISSUE_DATE, (Object)date, (Object)date2));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)GiftCard.PROP_CARD_NUMBER, (String)string, (MatchMode)MatchMode.START));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string2));
            }
            if (string3.equalsIgnoreCase("ACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true));
            } else if (string3.equalsIgnoreCase("DEACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false));
            } else if (string3.equalsIgnoreCase("DISABLED")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)true));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)GiftCard.PROP_ISSUE_DATE));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            paginationSupport.setRows(criteria.list());
        }
    }

    public List<Date> findByDate() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)GiftCard.PROP_ISSUE_DATE)));
            List list = criteria.list();
            if (list.isEmpty()) {
                List<Date> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public List<GiftCard> findExceptDisable() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard initialize(GiftCard giftCard) {
        if (giftCard == null) {
            return giftCard;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)giftCard);
            GiftCard giftCard2 = giftCard;
            return giftCard2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean findActiveCardByBatchNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false), (Criterion)Restrictions.isNotNull((String)GiftCard.PROP_ACTIVATION_DATE))));
                boolean bl = !criteria.list().isEmpty();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean deleteCardListByBatchNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List list = null;
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
                list = criteria.list();
                if (list != null) {
                    for (GiftCard giftCard : list) {
                        this.delete(giftCard);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public List<GiftCard> findByBatchNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    public boolean hasBatchNo(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
            criteria.setMaxResults(1);
            boolean bl = criteria.list().size() > 0;
            return bl;
        }
    }

    public List<GiftCard> findGiftCards(Date date, Date date2, boolean bl, String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.between((String)GiftCard.PROP_ACTIVATION_DATE, (Object)date, (Object)date2));
            if (bl) {
                criteria.add((Criterion)Restrictions.lt((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            }
            if ("Owner".equals(string)) {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_OWNER_NAME));
            } else {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_ACTIVATION_DATE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void updateItemsLastSyncTime(List<String> list, String string) {
        String string2;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string3 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string2 = transaction.next();
            string3 = string3 + "'" + string2 + "'";
            if (!transaction.hasNext()) continue;
            string3 = string3 + ",";
        }
        string3 = string3 + ")";
        transaction = null;
        try {
            string2 = this.createNewSession();
            Throwable throwable = null;
            try {
                transaction = string2.beginTransaction();
                String string4 = "update " + string + " set %s=:lastSyncTime where %s in %s";
                string4 = String.format(string4, GiftCard.PROP_LAST_SYNC_TIME, GiftCard.PROP_CARD_NUMBER, string3);
                Query query = string2.createQuery(string4);
                Date date = new Date();
                query.setParameter("lastSyncTime", (Object)date);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (string2 != null) {
                    if (throwable != null) {
                        try {
                            string2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        string2.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void saveOrUpdateGiftCardList(List<GiftCard> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (GiftCard giftCard : list) {
                GiftCard giftCard2 = this.get(giftCard.getCardNumber());
                if (giftCard2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(giftCard.getLastUpdateTime(), giftCard2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), giftCard.getBatchNo() + " already updated");
                        continue;
                    }
                    long l = giftCard2.getVersion();
                    PropertyUtils.copyProperties((Object)giftCard2, (Object)giftCard);
                    giftCard2.setVersion(l);
                    giftCard2.setUpdateLastUpdateTime(bl);
                    giftCard2.setUpdateSyncTime(bl2);
                    this.update(giftCard2, session);
                    continue;
                }
                giftCard.setUpdateLastUpdateTime(bl);
                giftCard.setUpdateSyncTime(bl2);
                this.save(giftCard, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

