/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuGroupDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;

public class MenuGroupDAO
extends BaseMenuGroupDAO {
    @Override
    public Serializable save(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        Serializable serializable = super.save(object, session);
        this.updateDependentModels((MenuGroup)object, session);
        return serializable;
    }

    @Override
    public void update(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        super.update(object, session);
        this.updateDependentModels((MenuGroup)object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
        this.updateDependentModels((MenuGroup)object, session);
    }

    @Override
    public void delete(Object object, Session session) throws HibernateException {
        MenuGroup menuGroup = (MenuGroup)object;
        if (menuGroup == null) {
            throw new PosException(Messages.getString("MenuGroupDAO.0"));
        }
        menuGroup.setMenuCategory(null);
        menuGroup.setDeleted(true);
        this.removeFromDependentModels(menuGroup, session);
        this.update(menuGroup, session);
        this.removeFromDiscounts(menuGroup, session);
    }

    @Override
    public List<MenuGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    private void updateDependentModels(MenuGroup menuGroup, Session session) {
        String string = "update MenuItem set %s=:groupName, %s=:categoryId, %s=:categoryName, %s=:beverage where %s=:groupId";
        string = String.format(string, MenuItem.PROP_MENU_GROUP_NAME, MenuItem.PROP_MENU_CATEGORY_ID, MenuItem.PROP_MENU_CATEGORY_NAME, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(string);
        query.setParameter("groupName", (Object)menuGroup.getName());
        query.setParameter("categoryId", (Object)menuGroup.getMenuCategoryId());
        query.setParameter("categoryName", (Object)menuGroup.getMenuCategoryName());
        query.setParameter("beverage", (Object)menuGroup.isBeverage());
        query.setParameter("groupId", (Object)menuGroup.getId());
        query.executeUpdate();
        session.saveOrUpdate((Object)menuGroup);
    }

    private void removeFromDependentModels(MenuGroup menuGroup, Session session) {
        String string = menuGroup.getId();
        String string2 = "update MenuItem set " + MenuItem.PROP_MENU_GROUP_NAME + "= null, " + MenuItem.PROP_MENU_GROUP_ID + "= null, " + MenuItem.PROP_MENU_CATEGORY_ID + "= null, " + MenuItem.PROP_MENU_CATEGORY_NAME + "= null, %s=:beverage where %s=:groupId";
        string2 = String.format(string2, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(string2);
        query.setParameter("beverage", (Object)false);
        query.setParameter("groupId", (Object)string);
        query.executeUpdate();
        MenuPageDAO menuPageDAO = MenuPageDAO.getInstance();
        List<MenuPage> list = menuPageDAO.findByGroup(menuGroup);
        if (list != null && !list.isEmpty()) {
            menuPageDAO.deleteAll(list, session);
        }
    }

    private void removeFromDiscounts(MenuGroup menuGroup, Session session) {
        DiscountDAO discountDAO = DiscountDAO.getInstance();
        List<Discount> list = discountDAO.getDiscountsByMenuGroup(menuGroup, session);
        if (list != null && !list.isEmpty()) {
            for (Discount discount : list) {
                List<MenuGroup> list2 = discount.getMenuGroups();
                list2.remove(menuGroup);
                discountDAO.saveOrUpdate(discount, session);
            }
        }
    }

    public void initialize(MenuGroup menuGroup) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuGroup);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGroupsForGroupView(OrderType orderType, MenuCategory menuCategory, PaginatedListModel paginatedListModel) throws PosException {
        Session session = null;
        try {
            Object object;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (orderType != null && orderType.getId() != null) {
                criteria.createAlias(MenuGroup.PROP_MENU_PAGES, "menuPage");
                object = Restrictions.isNull((String)("menuPage." + MenuPage.PROP_ORDER_TYPE_ID));
                SimpleExpression simpleExpression = Restrictions.eq((String)("menuPage." + MenuPage.PROP_ORDER_TYPE_ID), (Object)orderType.getId());
                criteria.add((Criterion)Restrictions.or((Criterion)object, (Criterion)simpleExpression));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.add(Restrictions.isNotEmpty((String)MenuGroup.PROP_MENU_PAGES));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            object = criteria.list();
            paginatedListModel.setNumRows(object.size());
            paginatedListModel.setPageSize(paginatedListModel.getNumRows());
            paginatedListModel.setData(object);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuGroup> loadActiveGroupsByOrderType(OrderType orderType) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            List<MenuCategory> list = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuCategory menuCategory : list) {
                arrayList.add(menuCategory.getId());
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_MENU_CATEGORY_ID, arrayList));
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = criteria.list();
            return list2;
        }
    }

    public List<MenuGroup> findEnabledByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<String> findEnabledGroupsIdsByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)MenuGroup.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuGroup> findByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Terminal terminal, MenuGroup menuGroup, OrderType orderType) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add(Restrictions.eqOrIsNull((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number.intValue() > 0;
            return bl;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            throw new PosException("");
        }
    }

    public void releaseParent(List<MenuGroup> list) {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (MenuGroup menuGroup : list) {
                menuGroup.setMenuCategoryId(null);
                session.saveOrUpdate((Object)menuGroup);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public void releaseParentAndDelete(MenuGroup menuGroup) {
        if (menuGroup == null) {
            return;
        }
        this.initialize(menuGroup);
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string = "delete from MENUGROUP_DISCOUNT where MENUGROUP_ID='%s'";
            string = String.format(string, menuGroup.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            String string2 = "update MENU_ITEM set GROUP_ID=null where GROUP_ID='%s'";
            string2 = String.format(string2, menuGroup.getId());
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            session.delete((Object)menuGroup);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public boolean existsMenuGroups(MenuCategory menuCategory) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            Number number;
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuGroups(PaginationSupport paginationSupport, String string, MenuCategory menuCategory, String ... stringArray) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuGroup.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME));
            if (stringArray != null && stringArray.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String string2 : stringArray) {
                    projectionList.add((Projection)Projections.property((String)string2), string2);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuGroup.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuGroup> findGroupsWithInventoryItems() throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_MENU_GROUP_ID));
            List list = criteria.list();
            criteria = session.createCriteria(MenuGroup.class);
            if (!list.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_ID, (Collection)list));
            }
            List list2 = criteria.list();
            return list2;
        }
    }

    public MenuGroup findMenuGroupByName(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_NAME, (Object)string).ignoreCase());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuGroup menuGroup = (MenuGroup)list.get(0);
                return menuGroup;
            }
            MenuGroup menuGroup = null;
            return menuGroup;
        }
    }

    public List<MenuGroup> findAllUnSyncMenuGroup() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateMenuGroups(List<MenuGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (MenuGroup menuGroup : list) {
                MenuGroup menuGroup2 = this.get(menuGroup.getId());
                if (menuGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(menuGroup.getLastUpdateTime(), menuGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), menuGroup.getName() + " already updated");
                        continue;
                    }
                    String string = menuGroup2.getId();
                    long l = menuGroup2.getVersion();
                    List<MenuPage> list2 = menuGroup2.getMenuPages();
                    PropertyUtils.copyProperties((Object)menuGroup2, (Object)menuGroup);
                    menuGroup2.setId(string);
                    menuGroup2.setVersion(l);
                    menuGroup2.setMenuPages(list2);
                    menuGroup2.setUpdateLastUpdateTime(bl);
                    menuGroup2.setUpdateSyncTime(bl2);
                    this.update(menuGroup2, session);
                    continue;
                }
                menuGroup.setUpdateLastUpdateTime(bl);
                menuGroup.setUpdateSyncTime(bl2);
                this.save(menuGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void findGroups(PaginationSupport paginationSupport, String string, MenuCategory menuCategory) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuGroup.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            paginationSupport.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME).ignoreCase());
            paginationSupport.setRows(criteria.list());
        }
    }
}

