/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.BasePrinterGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PrinterGroupDAO
extends BasePrinterGroupDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PrinterGroup) {
            PrinterGroup printerGroup = (PrinterGroup)object;
            List<MenuItem> list = MenuItemDAO.getInstance().getMenuItemsByPrinterGroup(printerGroup, session);
            if (list != null && !list.isEmpty()) {
                String string = printerGroup.getName() + EMPTY_SPACE_STRING + Messages.getString("PrinterGroupDAO.0");
                String string2 = this.constructExceptionDetailsByMenuItems(printerGroup, list);
                throw new PosException(string, string2);
            }
            printerGroup.setDeleted(Boolean.TRUE);
            super.update(printerGroup, session);
        } else {
            super.delete(object, session);
        }
    }

    private String constructExceptionDetailsByMenuItems(PrinterGroup printerGroup, List<MenuItem> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(printerGroup.getName() + EMPTY_SPACE_STRING + Messages.getString("PrinterGroupDAO.1"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<PrinterGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdatePrinterGroup(List<PrinterGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (PrinterGroup printerGroup : list) {
                PrinterGroup printerGroup2 = this.get(printerGroup.getId());
                if (printerGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(printerGroup.getLastUpdateTime(), printerGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), printerGroup.getName() + " already updated");
                        continue;
                    }
                    long l = printerGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)printerGroup2, (Object)printerGroup);
                    printerGroup2.setVersion(l);
                    printerGroup2.setUpdateLastUpdateTime(bl);
                    printerGroup2.setUpdateSyncTime(bl2);
                    this.update(printerGroup2);
                    continue;
                }
                printerGroup.setVersion(0L);
                printerGroup.setUpdateLastUpdateTime(bl);
                printerGroup.setUpdateSyncTime(bl2);
                this.save(printerGroup);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    public PrinterGroup findByName(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)PrinterGroup.PROP_NAME, (Object)string));
        return (PrinterGroup)criteria.uniqueResult();
    }

    public PrinterGroup findByName(String string) {
        try (Session session = this.createNewSession();){
            PrinterGroup printerGroup = this.findByName(string, session);
            return printerGroup;
        }
    }

    public PrinterGroup getDefaultPrinterGroup() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)PrinterGroup.PROP_IS_DEFAULT, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                PrinterGroup printerGroup = (PrinterGroup)list.get(0);
                return printerGroup;
            }
            PrinterGroup printerGroup = null;
            return printerGroup;
        }
    }

    public List<PrinterGroup> getPrinterGroupsByVirtualPrinter(VirtualPrinter virtualPrinter, Session session) {
        ArrayList<PrinterGroup> arrayList = null;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        List list = criteria.list();
        if (list != null && !list.isEmpty()) {
            arrayList = new ArrayList<PrinterGroup>();
            for (PrinterGroup printerGroup : list) {
                if (!printerGroup.getPrinterNames().contains(virtualPrinter.getName())) continue;
                arrayList.add(printerGroup);
            }
        }
        return arrayList;
    }
}

