/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class MemberPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    @Override
    public String getName() {
        return Messages.getString("MemberAccount");
    }

    @Override
    public void pay(Ticket ticket, double d, SettleTicketProcessor settleTicketProcessor) throws Exception {
        Comparable<Double> comparable;
        Customer customer = this.doSetMember(ticket);
        if (customer != null) {
            comparable = customer.getCreditLimit();
            Double d2 = customer.getBalance();
            if (d > NumberUtil.round(d2 + (Double)comparable)) {
                throw new PosException(Messages.getString("CreditLimitExceed"));
            }
        }
        comparable = (CustomerAccountTransaction)PaymentType.MEMBER_ACCOUNT.createTransaction(ticket, d);
        settleTicketProcessor.settleTicket((PosTransaction)comparable, this);
    }

    @Override
    public String getId() {
        return "MEMBER_ACCOUNT";
    }

    @Override
    public void paymentDone(PosTransaction posTransaction, Session session) {
        Ticket ticket = posTransaction.getTicket();
        Customer customer = ticket.getCustomer();
        customer.setBalance(customer.getBalance() - posTransaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
        ticket.updateCustomerRef(customer);
    }

    public void doRefund(Ticket ticket, List<PosTransaction> list) throws Exception {
        Transaction transaction = null;
        try (Session session = null;){
            Customer customer = this.doSetMember(ticket);
            double d = this.getRefundableAmount(ticket);
            double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("MemberPaymentPlugin.1"), d);
            if (d2 <= 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MemberPaymentPlugin.2"));
                return;
            }
            if (d2 > d) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MemberPaymentPlugin.3") + NumberUtil.round(d));
                return;
            }
            double d3 = this.calculateTaxAmount(ticket);
            Double d4 = NumberUtil.roundToTwoDigit(d3 * d2 / ticket.getPaidAmount());
            User user = Application.getCurrentUser();
            session = CustomerDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            PosTransactionService posTransactionService = PosTransactionService.getInstance();
            RefundTransaction refundTransaction = posTransactionService.createRefundTransaction(ticket, null, d2, PaymentType.MEMBER_ACCOUNT, null);
            refundTransaction.setPaymentType(PaymentType.MEMBER_ACCOUNT);
            refundTransaction.setCustomPaymentFieldName("MEMBER ID");
            refundTransaction.setCustomPaymentRef(customer.getId());
            refundTransaction.setUser(user);
            refundTransaction.setAmount(d2);
            refundTransaction.setTaxAmount(d4);
            refundTransaction.setCustomerId(customer.getId());
            customer.setBalance(customer.getBalance() + d2);
            ticket.setRefundAmount(ticket.getRefundAmount() + d2);
            ticket.addTotransactions(refundTransaction);
            ticket.calculatePrice();
            CustomerDAO.getInstance().saveOrUpdate(customer, session);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MemberPaymentPlugin.5") + CurrencyUtil.getCurrencySymbol() + d2);
            transaction.commit();
        }
    }

    public Customer doSetMember(Ticket ticket) {
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (ticket != null) {
                customerSelectorDialog.setTicket(ticket);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (customerSelectorDialog.isCanceled()) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            customer = customerSelectorDialog.getSelectedCustomer();
            if (customer == null) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            ticket.setCustomer(customer);
            OrderController.saveOrder(ticket);
        }
        CustomerDAO.getInstance().refresh(customer);
        return customer;
    }

    @Override
    public void voidPayment(PosTransaction posTransaction, Session session) {
        String string = posTransaction.getCustomerId();
        if (StringUtils.isEmpty((String)string)) {
            string = posTransaction.getTicket().getCustomerId();
        }
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("MemberPaymentPlugin.8"));
        }
        Customer customer = CustomerDAO.getInstance().get(string);
        customer.setBalance(customer.getBalance() + posTransaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
    }

    @Override
    public String getProductName() {
        return null;
    }
}

