/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.OpenTicketSummaryReport;
import com.floreantpos.report.Report;
import com.floreantpos.report.VoidItemReport;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.swingx.JXDatePicker;

public class ReportViewer
extends JPanel {
    private JButton a;
    private JButton b;
    private JLabel c;
    private JComboBox d;
    private JXDatePicker e;
    private JXDatePicker f;
    private JComboBox<Date> g;
    private JComboBox<Date> h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JCheckBox l;
    private JCheckBox m;
    private JLabel n;
    private JComboBox o;
    private JLabel p;
    private JComboBox<OrderType> q;
    private TransparentPanel r;
    private TransparentPanel s;
    private Report t;
    private MultiSelectComboBox<MenuGroup> u;
    private JPanel v;
    private JPanel w;
    private JPanel x;
    private JPanel y;
    private JPanel z;
    private JPanel A;

    public ReportViewer() {
        this.a();
    }

    public ReportViewer(Report report) {
        this.a();
        this.u.setItems(MenuGroupDAO.getInstance().findAll());
        TerminalDAO terminalDAO = new TerminalDAO();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(0, POSConstants.ALL);
        List<Terminal> list = terminalDAO.findAll();
        for (Terminal terminal : list) {
            if (!terminal.isHasCashDrawer().booleanValue()) continue;
            arrayList.add(terminal);
        }
        this.d.setModel(new ListComboBoxModel(arrayList));
        this.setReport(report);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.r = new TransparentPanel();
        WrapLayout wrapLayout = new WrapLayout(0, 5, 5);
        this.r.setLayout(wrapLayout);
        this.c = new JLabel(Messages.getString("ReportViewer.4"));
        this.u = new MultiSelectComboBox();
        this.k = new JLabel(Messages.getString("ReportViewer.3"));
        this.d = new JComboBox();
        this.i = new JLabel(POSConstants.START_DATE + ":");
        this.f = UiUtil.getCurrentMonthStart();
        TimeComboBox timeComboBox = new TimeComboBox();
        this.g = timeComboBox.getDefaultTimeComboBox();
        this.j = new JLabel(POSConstants.END_DATE + ":");
        this.e = UiUtil.getCurrentMonthEnd();
        this.h = timeComboBox.getDefaultTimeComboBox();
        this.l = new JCheckBox(Messages.getString("ReportViewer.6"));
        this.m = new JCheckBox(Messages.getString("ReportViewer.5"));
        this.n = new JLabel(Messages.getString("ReportViewer.7"));
        this.o = new JComboBox();
        this.p = new JLabel(Messages.getString("ReportViewer.0"));
        this.q = new JComboBox();
        this.a = new JButton(Messages.getString("ReportViewer.2"));
        this.s = new TransparentPanel();
        this.a.addActionListener(actionEvent -> this.a(actionEvent));
        this.b = new JButton(Messages.getString("ReportViewer.8"));
        this.b.addActionListener(actionEvent -> this.doClear(actionEvent));
        this.v = new JPanel();
        this.v.add(this.c);
        this.v.add(this.u);
        this.w = new JPanel();
        this.w.add(this.k);
        this.w.add(this.d);
        this.x = new JPanel();
        this.x.add(this.i);
        this.x.add((Component)this.f);
        this.x.add(this.g);
        this.y = new JPanel();
        this.y.add(this.j);
        this.y.add((Component)this.e);
        this.y.add(this.h);
        this.r.add(this.v);
        this.r.add(this.w);
        this.r.add(this.x);
        this.r.add(this.y);
        this.r.add(this.l);
        this.r.add(this.m);
        this.r.add(this.a);
        this.s.setLayout(new BorderLayout(5, 5));
        this.s.add((Component)new JSeparator(0), "North");
        this.add((Component)this.r, "North");
        this.add((Component)this.s, "Center");
    }

    private void a(ActionEvent actionEvent) {
        try {
            Date date = this.f.getDate();
            Date date2 = this.e.getDate();
            DateUtil.validateDate(date, date2);
            Date date3 = (Date)this.g.getSelectedItem();
            Date date4 = (Date)this.h.getSelectedItem();
            date = DateUtil.copyTime(date, date3);
            date2 = DateUtil.copyTime(date2, date4);
            this.s.removeAll();
            this.s.revalidate();
            this.s.add((Component)new JSeparator(0), "North");
            if (this.t != null) {
                UserType userType = null;
                if (this.o.getSelectedItem() instanceof UserType) {
                    userType = (UserType)this.o.getSelectedItem();
                }
                this.t.setUserType(userType);
                OrderType orderType = null;
                if (this.q.getSelectedItem() instanceof OrderType) {
                    orderType = (OrderType)this.q.getSelectedItem();
                }
                this.t.setOrderType(orderType);
                Terminal terminal = null;
                if (this.d.getSelectedItem() instanceof Terminal) {
                    terminal = (Terminal)this.d.getSelectedItem();
                }
                this.t.setMenuGroups(this.u.getSelectedItems());
                this.t.setTerminal(terminal);
                this.t.setStartDate(date);
                this.t.setEndDate(date2);
                this.t.setIncludeFreeItems(this.l.isSelected());
                this.t.setShowInGroups(this.m.isSelected());
                this.t.refresh();
                if (this.t != null && this.t.getViewer() != null) {
                    this.s.add((Component)this.t.getViewer());
                    this.s.revalidate();
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doClear(ActionEvent actionEvent) {
        if (this.t != null) {
            this.q.setSelectedIndex(0);
            this.o.setSelectedIndex(0);
            this.d.setSelectedIndex(0);
        }
    }

    public Report getReport() {
        return this.t;
    }

    public void setReport(Report report) {
        this.t = report;
        if (report instanceof VoidItemReport) {
            this.r.removeAll();
            this.r.add(this.w);
            this.r.add(this.x);
            this.r.add(this.y);
            this.r.add(this.a);
        }
        if (report instanceof OpenTicketSummaryReport) {
            this.r.removeAll();
            UserTypeDAO userTypeDAO = new UserTypeDAO();
            List<UserType> list = userTypeDAO.findAll();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(0, POSConstants.ALL);
            arrayList.addAll(list);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(0, POSConstants.ALL);
            arrayList2.addAll(OrderTypeDAO.getInstance().findAll());
            this.o.setModel(new ListComboBoxModel(arrayList));
            this.z = new JPanel();
            this.z.add(this.n);
            this.z.add(this.o);
            this.r.add(this.z);
            this.q.setModel(new ListComboBoxModel(arrayList2));
            this.A = new JPanel();
            this.A.add(this.p);
            this.A.add(this.q);
            this.r.add(this.A);
            this.r.add(this.x);
            this.r.add(this.y);
            this.r.add(this.w);
            this.r.add(this.a);
            this.r.add(this.b);
        }
    }
}

