/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TicketReportModel
extends AbstractTableModel {
    private String[] a = new String[]{"id", "date", "orderType", "owner", "total", "due"};
    private List<Ticket> b;
    private double c;
    private double d;

    @Override
    public int getRowCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.a[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Ticket ticket = this.b.get(n);
        switch (n2) {
            case 0: {
                return String.valueOf(ticket.getId());
            }
            case 1: {
                return DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate());
            }
            case 2: {
                return ticket.getOrderType().getName();
            }
            case 3: {
                return ticket.getOwner() == null ? "" : ticket.getOwner().getFullName();
            }
            case 4: {
                return NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            }
            case 5: {
                return NumberUtil.formatNumber(ticket.getDueAmount());
            }
        }
        return null;
    }

    public List<Ticket> getItems() {
        return this.b;
    }

    public void setItems(List<Ticket> list) {
        this.b = list;
    }

    public String getGrandTotalAsString() {
        return NumberUtil.formatNumber(this.c);
    }

    public void setGrandTotal(double d) {
        this.c = d;
    }

    public void calculateGrandTotal() {
        this.c = 0.0;
        if (this.b == null) {
            return;
        }
        for (Ticket ticket : this.b) {
            this.c += ticket.getTotalAmount().doubleValue();
        }
    }

    public String getTotalDueAsString() {
        return NumberUtil.formatNumber(this.d);
    }

    public void setTotalDue(double d) {
        this.d = d;
    }

    public void calculateTotalDue() {
        this.d = 0.0;
        if (this.b == null) {
            return;
        }
        for (Ticket ticket : this.b) {
            this.d += ticket.getDueAmount().doubleValue();
        }
    }
}

