/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class DeliverySummaryReportModel
extends ListTableModel {
    public DeliverySummaryReportModel() {
        super(new String[]{"empName", "customerName", "ticketId", "ticketAmt", "serviceCharge", "tips", "tax", "total", "memberCharge", "creditCard", "cashPymt", "othersPayment", "discount", "createdDate", "deliveryDate"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DeliverySummaryReportData deliverySummaryReportData = (DeliverySummaryReportData)this.rows.get(n);
        switch (n2) {
            case 0: {
                return deliverySummaryReportData.getEmployeeId() + " - " + deliverySummaryReportData.getEmployeeName();
            }
            case 1: {
                String string = deliverySummaryReportData.getCustomerName();
                String string2 = deliverySummaryReportData.getMemberId() == null ? "" : deliverySummaryReportData.getMemberId() + " - ";
                return string == null ? Messages.getString("GUEST") : string2 + string;
            }
            case 2: {
                return deliverySummaryReportData.getTicketId();
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getNetAmount());
            }
            case 4: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getServiceCharge());
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getGratuityAmount());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getTaxAmount());
            }
            case 7: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getTotalAmount() + deliverySummaryReportData.getGratuityAmount());
            }
            case 8: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getMemberCharge());
            }
            case 9: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getCreditCardPayment());
            }
            case 10: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getCashPayment());
            }
            case 11: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getOthersPayment());
            }
            case 12: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getDiscount());
            }
            case 13: {
                return DateUtil.tweentyFourHoursDateFormat(deliverySummaryReportData.getCreatedDate());
            }
            case 14: {
                return DateUtil.tweentyFourHoursDateFormat(deliverySummaryReportData.getDeliveryDate());
            }
        }
        return null;
    }
}

