/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ItemSearchDialog
extends OkCancelOptionDialog {
    private JComboBox a;
    private JComboBox b;
    private JTextField c;
    private PosButton d;
    private JTable e;
    private BeanTableModel<MenuItem> f;
    private MenuItem g;
    private OrderType h;
    private static ItemSearchDialog i;

    private ItemSearchDialog() {
        super(POSUtil.getFocusedWindow(), POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(PosUIManager.getSize(900, 700));
        this.a();
    }

    private ItemSearchDialog(Frame frame) {
        super((Window)frame, POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(PosUIManager.getSize(900, 700));
        this.a();
    }

    private void a() {
        this.setTitle(Messages.getString("TicketView.7"));
        this.setResizable(false);
        JPanel jPanel = this.getContentPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 15, 0, 15));
        MigLayout migLayout = new MigLayout("fillx, inset 0");
        jPanel.setLayout((LayoutManager)migLayout);
        this.e = new JTable();
        this.e.setRowHeight(40);
        this.e.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.e.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ItemSearchDialog.this.doOk();
                }
            }
        });
        this.e.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ItemSearchDialog.this.doOk();
                }
            }
        });
        this.f = new BeanTableModel(MenuItem.class, 20);
        this.f.addColumn(Messages.getString("ItemSearchDialog.1").toUpperCase(), "barcode");
        this.f.addColumn(Messages.getString("ItemSearchDialog.2"), "sku");
        this.f.addColumn(POSConstants.NAME.toUpperCase(), "displayName");
        this.f.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.f.addColumn(Messages.getString("MenuItemExplorer.14").toUpperCase(), "availableUnit");
        this.e.setModel(this.f);
        this.c = new JTextField();
        this.c.setFont(this.c.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.c.setBackground(Color.WHITE);
        this.d = new PosButton(Messages.getString("Search"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemSearchDialog.this.e();
            }
        };
        this.c.addActionListener(actionListener);
        this.d.addActionListener(actionListener);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (ItemSearchDialog.this.c.getText().length() > 2) {
                    ItemSearchDialog.this.e();
                } else if (ItemSearchDialog.this.c.getText().isEmpty()) {
                    ItemSearchDialog.this.f.removeAll();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.c.addKeyListener(keyListener);
        jPanel.add((Component)this.c(), "spanx ,grow");
        jPanel.add((Component)this.c, "spanx,split 2, grow");
        jPanel.add((Component)this.d, "gaptop 0, wrap");
        jPanel.add((Component)new PosScrollPane(this.e), "span, grow");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        qwertyKeyPad.setKeyPadListener(keyListener);
        jPanel.add((Component)((Object)qwertyKeyPad), "spanx ,grow");
        this.resizeColumnWidth(this.e);
        this.c.setFocusable(true);
        this.c.requestFocus();
    }

    public static synchronized ItemSearchDialog getInstance() {
        if (i == null) {
            i = new ItemSearchDialog();
            i.pack();
        }
        return i;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    public void updateFilterPanel(OrderType orderType) {
        this.h = orderType;
        this.b.removeAllItems();
        this.a.removeAllItems();
        this.b.addItem(Messages.getString("ALL"));
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
        for (MenuCategory object2 : list) {
            this.b.addItem(object2);
        }
        this.a.addItem(Messages.getString("ALL"));
        List<MenuGroup> list2 = MenuGroupDAO.getInstance().loadActiveGroupsByOrderType(orderType);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            MenuGroup menuGroup = (MenuGroup)iterator.next();
            this.a.addItem(menuGroup);
        }
        this.b();
    }

    private void b() {
        try {
            TableColumn tableColumn = this.e.getColumnModel().getColumn(3);
            tableColumn.setHeaderValue(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")");
            this.e.getTableHeader().repaint();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private JPanel c() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("ins 0", "[][]15[][]", "[]5[]"));
        JLabel jLabel = new JLabel(Messages.getString("ItemSearchDialog.11"));
        this.b = new JComboBox();
        JLabel jLabel2 = new JLabel(Messages.getString("ItemSearchDialog.12"));
        this.a = new JComboBox();
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemSearchDialog.this.f();
            }
        });
        this.a(jLabel, this.b, jLabel2, this.a);
        this.b.setMinimumSize(PosUIManager.getSize(150, 30));
        this.a.setMinimumSize(PosUIManager.getSize(150, 30));
        jPanel.add(jLabel);
        jPanel.add(this.b);
        jPanel.add(jLabel2);
        jPanel.add(this.a);
        return jPanel;
    }

    private void a(Component ... componentArray) {
        for (Component component : componentArray) {
            component.setFocusable(false);
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(250);
        arrayList.add(50);
        arrayList.add(50);
        return arrayList;
    }

    @Override
    public void doOk() {
        int n = this.e.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("ItemSearchDialog.3"));
            return;
        }
        this.g = this.f.getRow(n);
        this.f.removeAll();
        this.c.setText("");
        this.setCanceled(false);
        this.dispose();
    }

    public MenuItem getMenuItem() {
        return this.g;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.g = menuItem;
    }

    private void e() {
        List<MenuItem> list;
        String string = this.c.getText();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("ItemSearchDialog.0"));
            return;
        }
        this.f.removeAll();
        MenuItemDAO menuItemDAO = new MenuItemDAO();
        MenuCategory menuCategory = null;
        Object object = this.b.getSelectedItem();
        if (object instanceof MenuCategory) {
            menuCategory = (MenuCategory)this.b.getSelectedItem();
        }
        Object object2 = this.a.getSelectedItem();
        MenuGroup menuGroup = null;
        if (object2 instanceof MenuGroup) {
            menuGroup = (MenuGroup)this.a.getSelectedItem();
        }
        if ((list = menuItemDAO.getMenuItemsByNameOrBarcode(this.h, menuCategory, menuGroup, string, true)) != null && list.size() > 0) {
            this.f.addRows(list);
        }
        this.e.repaint();
    }

    private void f() {
        try {
            Object object = this.b.getSelectedItem();
            MenuCategory menuCategory = null;
            if (object instanceof MenuCategory) {
                menuCategory = (MenuCategory)this.b.getSelectedItem();
            }
            List<MenuGroup> list = null;
            list = menuCategory == null ? MenuGroupDAO.getInstance().loadActiveGroupsByOrderType(this.h) : MenuGroupDAO.getInstance().findByParent(menuCategory);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.a.getModel();
            defaultComboBoxModel.removeAllElements();
            defaultComboBoxModel.addElement(Messages.getString("ALL"));
            for (MenuGroup menuGroup : list) {
                defaultComboBoxModel.addElement(menuGroup);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }
}

