/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.LicenseSelectionAction;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.licensemanager.OroLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class OroLicenseInfoDialog
extends POSDialog {
    private OroLicense a;

    public OroLicenseInfoDialog(OroLicense oroLicense) {
        super(POSUtil.getFocusedWindow(), "", true);
        this.a = oroLicense;
        this.a();
    }

    public OroLicenseInfoDialog() {
        super(POSUtil.getBackOfficeWindow());
    }

    private void a() {
        this.setSize(500, 400);
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setTitle(VersionInfo.getAppName());
        Image image = Application.getApplicationIcon().getImage();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx"));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fillx,center,inset 20", "[][]", ""));
        jPanel3.setBorder(new LineBorder(Color.gray));
        jPanel3.setBackground(Color.white);
        JLabel jLabel = new JLabel("License Information");
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 24));
        jLabel.setOpaque(true);
        JLabel jLabel2 = new JLabel(new ImageIcon(image), 0);
        jLabel2.setBackground(Color.WHITE);
        jLabel2.setOpaque(true);
        jPanel2.add((Component)jLabel2, "split 2");
        jPanel2.add((Component)jLabel, "h 40!,grow,center,wrap");
        jPanel2.add((Component)new JSeparator(), "grow,span");
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel3 = new JLabel("Product Name");
        JLabel jLabel4 = new JLabel(this.a.getProductName());
        jPanel3.add(jLabel3);
        jPanel3.add((Component)jLabel4, "wrap");
        JLabel jLabel5 = new JLabel("Version ");
        JLabel jLabel6 = new JLabel(this.a.getProductVersion());
        jPanel3.add(jLabel5);
        jPanel3.add((Component)jLabel6, "wrap");
        JLabel jLabel7 = new JLabel("Issuer Name");
        JLabel jLabel8 = new JLabel(this.a.getIssuer());
        jPanel3.add(jLabel7);
        jPanel3.add((Component)jLabel8, "wrap");
        JLabel jLabel9 = new JLabel("Holder Name");
        JLabel jLabel10 = new JLabel(this.a.getHolderName());
        jPanel3.add(jLabel9);
        jPanel3.add((Component)jLabel10, "wrap");
        JLabel jLabel11 = new JLabel("Holder Email");
        JLabel jLabel12 = new JLabel(this.a.getHolderEmail());
        jLabel12.setForeground(Color.blue);
        jPanel3.add(jLabel11);
        jPanel3.add((Component)jLabel12, "wrap");
        JLabel jLabel13 = new JLabel("Issue Date");
        JLabel jLabel14 = new JLabel(new SimpleDateFormat("dd MMM yyyy hh:mm a").format(this.a.getIssueDate()));
        jPanel3.add(jLabel13);
        jPanel3.add((Component)jLabel14, "wrap");
        JLabel jLabel15 = new JLabel("Expiry Date");
        long l = 86400000L;
        long l2 = this.a.getExpiryDate().getTime() - new Date().getTime();
        long l3 = Math.round((double)l2 / (double)l);
        JLabel jLabel16 = new JLabel(new SimpleDateFormat("dd MMM yyyy hh:mm a").format(this.a.getExpiryDate()) + " (" + l3 + (Math.abs(l3) > 1L ? " days)" : " day)"));
        jPanel3.add(jLabel15);
        jPanel3.add((Component)jLabel16, "wrap");
        jPanel.add(jPanel3);
        PosButton posButton = new PosButton(POSConstants.CLOSE);
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OroLicenseInfoDialog.this.dispose();
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("OroLicenseInfoDialog.19"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OroLicenseInfoDialog.this.dispose();
                    LicenseSelectionAction licenseSelectionAction = new LicenseSelectionAction(OroLicenseInfoDialog.this, Application.getInstance().getProductName(), Application.getInstance().getProductVersion());
                    licenseSelectionAction.execute();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(posButton2);
        jPanel4.add(posButton);
        jPanel.add((Component)jPanel4, "South");
        this.setContentPane(jPanel);
    }

    @Override
    public void setVisible(boolean bl) {
        this.setLocationRelativeTo(null);
        super.setVisible(bl);
    }

    public OroLicense getLicense() {
        return this.a;
    }

    public void setLicense(OroLicense oroLicense) {
        this.a = oroLicense;
        this.a();
    }
}

