/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class OrderTypeBaseTaxPanel
extends TransparentPanel
implements IUpdatebleView<MenuItem> {
    private List<OrderTypeTax> a = new ArrayList<OrderTypeTax>();
    private List<TaxGroup> b;
    private JButton c = new JButton();
    private String d;
    private boolean e;
    private JPanel f;

    public OrderTypeBaseTaxPanel() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.f = new JPanel();
        this.f.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 2,insets 20", "[][]", ""));
        this.c.setText(POSConstants.APPLY_OTHER_ITEMS);
        this.c.addActionListener(actionEvent -> this.c());
        JScrollPane jScrollPane = new JScrollPane(this.f);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    public void setTaxGroups(List<TaxGroup> list) {
        this.b = list;
    }

    @Override
    public void initView(MenuItem menuItem) {
        if (this.e) {
            return;
        }
        this.d = menuItem.getId();
        this.b();
        List<OrderType> list = DataProvider.get().getOrderTypes();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (OrderType orderType : list) {
            if (!orderType.isHasForHereAndToGo().booleanValue()) {
                this.a(menuItem, orderType, "", "");
                continue;
            }
            menuItem.removeProperty(orderType.getId() + ".taxgroup");
            this.a(menuItem, orderType, SubOrderType.FOR_HERE.getDisplayString(), ".for_here");
            this.a(menuItem, orderType, SubOrderType.TO_GO.getDisplayString(), ".to_go");
        }
        this.f.add((Component)this.c, "skip 1,right");
        this.e = true;
    }

    private void b() {
        this.f.removeAll();
        this.a.clear();
    }

    @Override
    public boolean updateModel(MenuItem menuItem) {
        if (!this.e) {
            return true;
        }
        this.updateOrderTypeBaseTaxProperty(menuItem);
        return true;
    }

    public void updateOrderTypeBaseTaxProperty(MenuItem menuItem) {
        if (this.a == null || this.a.isEmpty()) {
            return;
        }
        for (OrderTypeTax orderTypeTax : this.a) {
            TaxGroup taxGroup = orderTypeTax.getSelectedTaxGroup();
            menuItem.addProperty(orderTypeTax.getPropertyName(), taxGroup == null ? null : taxGroup.getId());
        }
    }

    private void a(MenuItem menuItem, OrderType orderType, String string, String string2) {
        OrderTypeTax orderTypeTax = new OrderTypeTax();
        orderTypeTax.initData(this.b);
        String string3 = orderType.getId() + string2 + ".taxgroup";
        this.f.add(orderTypeTax.getLabel());
        this.f.add((Component)orderTypeTax.getComboBox(), "gapleft 10");
        if (StringUtils.isNotBlank((String)string)) {
            string = " (" + string + ")";
        }
        orderTypeTax.updateView(string3, orderType.getName() + string, menuItem.getProperty(string3));
        this.a.add(orderTypeTax);
    }

    private void c() {
        try {
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>(), true);
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(800, 600));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            if (list == null || list.size() == 0) {
                return;
            }
            Iterator<MenuItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem = iterator.next();
                if (StringUtils.isNotBlank((String)this.d) && this.d.equals(menuItem.getId())) {
                    iterator.remove();
                    continue;
                }
                this.updateOrderTypeBaseTaxProperty(menuItem);
            }
            if (list.size() == 0) {
                return;
            }
            MenuItemDAO.getInstance().saveOrUpdateMenuItems(list);
            POSMessageDialog.showMessage(this, Messages.getString("OrderTypeBaseTaxPanel.6"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private class OrderTypeTax {
        private JComboBox<TaxGroup> b;
        private JLabel c = new JLabel();
        private String d;

        public OrderTypeTax() {
            this.b = new JComboBox();
            this.b.setMinimumSize(PosUIManager.getSize(200, 0));
        }

        public void initData(List<TaxGroup> list) {
            ComboBoxModel comboBoxModel = new ComboBoxModel();
            comboBoxModel.addElement((Object)null);
            if (list != null && list.size() > 0) {
                for (TaxGroup taxGroup : list) {
                    comboBoxModel.addElement(taxGroup);
                }
            }
            this.b.setModel(comboBoxModel);
        }

        public void updateView(String string, String string2, String string3) {
            this.d = string;
            this.c.setText(string2);
            this.b.setSelectedItem(DataProvider.get().getTaxGroupById(string3));
        }

        public JLabel getLabel() {
            return this.c;
        }

        public JComboBox getComboBox() {
            return this.b;
        }

        public String getPropertyName() {
            return this.d;
        }

        public TaxGroup getSelectedTaxGroup() {
            return (TaxGroup)this.b.getSelectedItem();
        }
    }
}

