/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;

class AuthorizationDialog
extends POSDialog
implements Runnable {
    private JLabel a;
    private JTextArea b;
    private PosButton c;
    private List<PosTransaction> d;

    public AuthorizationDialog(POSDialog pOSDialog, List<PosTransaction> list) {
        this.d = list;
        this.a();
        this.setTitle(Messages.getString("PaymentProcessWaitDialog.0"));
        this.setIconImage(Application.getPosWindow().getIconImage());
        this.setLocationRelativeTo(pOSDialog);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            Thread thread = new Thread(this);
            thread.start();
        }
        super.setVisible(bl);
    }

    @Override
    public void run() {
        Iterator<PosTransaction> iterator = this.d.iterator();
        while (iterator.hasNext()) {
            PosTransaction posTransaction = iterator.next();
            try {
                Object object;
                Object object2;
                String string = posTransaction.getCardReader();
                CardReader cardReader = CardReader.fromString(string);
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    posTransaction.setCaptured(true);
                    PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
                    this.b.append(Messages.getString("AuthorizationDialog.1") + posTransaction.getId() + Messages.getString("AuthorizationDialog.2"));
                    continue;
                }
                String string2 = posTransaction.getCardMerchantGateway();
                if (StringUtils.isEmpty((String)string2)) {
                    object2 = Messages.getString("AuthorizationDialog.3");
                    object2 = String.format((String)object2, posTransaction.getId());
                    throw new PosException((String)object2);
                }
                object2 = CardConfig.getPaymentGatewayByName(string2);
                if (object2 == null) {
                    object = Messages.getString("AuthorizationDialog.5");
                    object = String.format((String)object, string2);
                    throw new PosException((String)object);
                }
                object = ((PaymentGatewayPlugin)object2).getProcessor();
                object.captureAuthAmount(posTransaction);
                posTransaction.setCaptured(true);
                PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
                this.b.append(Messages.getString("AuthorizationDialog.1") + posTransaction.getId() + Messages.getString("AuthorizationDialog.2"));
                if (!iterator.hasNext()) continue;
                Thread.sleep(6000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
                this.b.append(Messages.getString("AuthorizationDialog.1") + posTransaction.getId() + Messages.getString("AuthorizationDialog.4") + exception.getMessage() + "\n");
            }
        }
        this.a.setText(Messages.getString("AuthorizationDialog.0"));
        this.c.setVisible(true);
    }

    private void a() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new BorderLayout());
        transparentPanel.setOpaque(true);
        this.a = new JLabel(Messages.getString("PaymentProcessWaitDialog.1"));
        this.a.setHorizontalAlignment(0);
        this.a.setFont(this.a.getFont().deriveFont(24).deriveFont(1));
        JLabel jLabel = new JLabel(Messages.getString("PaymentProcessWaitDialog.8") + CardConfig.getPaymentGateway().getProductName());
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(this.a.getFont().deriveFont(24).deriveFont(1));
        this.b = new JTextArea();
        this.b.setEditable(false);
        this.b.setLineWrap(true);
        transparentPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(20, 30, 20, 30), jScrollPane.getBorder()));
        transparentPanel.add((Component)jScrollPane, "Center");
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout(new FlowLayout(1, 10, 5));
        this.c = new PosButton();
        this.c.setText(POSConstants.FINISH);
        this.c.setPreferredSize(new Dimension(140, 50));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthorizationDialog.this.a(actionEvent);
            }
        });
        this.c.setVisible(false);
        transparentPanel2.add(this.c);
        transparentPanel.add((Component)transparentPanel2, "South");
        this.getContentPane().add((Component)this.a, "North");
        this.getContentPane().add((Component)transparentPanel, "Center");
        this.setSize(500, 400);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
    }

    private void a(ActionEvent actionEvent) {
        this.dispose();
    }
}

