/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeletedData;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.base.BaseDepartment;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.base.BaseTerminalType;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DeclaredTipsDAO;
import com.floreantpos.model.dao.DeletedDataDAO;
import com.floreantpos.model.dao.DeliveryAddressDAO;
import com.floreantpos.model.dao.DeliveryChargeDAO;
import com.floreantpos.model.dao.DeliveryInstructionDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.GratuityPaymentHistoryDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryClosingBalanceDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PackagingUnitDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopFloorTemplateDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.dao.StockCountDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.DataMismatchMessageDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.XMLTransientUtil;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.server.BaseDataServiceDao;
import com.orocube.rest.service.server.TicketDataServiceDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CloudDataDownloader {
    private static Logger a = Logger.getLogger(CloudDataDownloader.class);
    private ProgressObserver b;
    private PosWebService c;
    private int d;
    private int e;
    private Integer f = 0;
    private List<Department> g = null;
    private List<OrderType> h = null;
    private List<TerminalType> i = null;
    private List<String> j = new ArrayList<String>();

    public PosWebService getPosWebService() {
        if (this.c == null) {
            this.c = PosWebService.get();
        }
        return this.c;
    }

    public void downloadStore(ProgressObserver progressObserver) throws Exception {
        this.b = progressObserver;
        this.c = this.getPosWebService();
        this.b.progress(0, Messages.getString("CloudDataDownloader.56"));
        this.c();
    }

    public Integer downloadAllData(ProgressObserver progressObserver, Integer n) throws Exception {
        this.d = 0;
        this.b = progressObserver;
        this.c = this.getPosWebService();
        this.f = n;
        this.g = null;
        this.h = null;
        this.i = null;
        this.a("=======================Checking for download=================");
        this.b.progress(this.f, "Downloading...");
        List<DataSyncInfo> list = this.b();
        if (list == null || list.isEmpty()) {
            this.a("Nothing to download. Everything is up to date.");
            return this.f;
        }
        PosLog.info(this.getClass(), list.size() + " table data found to update");
        for (DataSyncInfo dataSyncInfo : list) {
            this.a("Table - " + dataSyncInfo.getRef() + ": " + dataSyncInfo.getRowCount());
        }
        this.a("=======================Starting Download=======================");
        this.e = 50 / list.size();
        if (this.e == 0) {
            this.e = 1;
        }
        for (DataSyncInfo dataSyncInfo : list) {
            this.a(dataSyncInfo);
        }
        this.a(this.g, this.h, this.i);
        this.a("=======================Download Complete=======================");
        return this.f;
    }

    public int getErrorCount() {
        return this.d;
    }

    private void a(DataSyncInfo dataSyncInfo) throws Exception {
        this.f = this.f + this.e;
        switch (dataSyncInfo.getRef()) {
            case "Outlet": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.0"));
                this.y();
                break;
            }
            case "OrderType": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.7"));
                this.h = this.L();
                break;
            }
            case "ImageResource": {
                this.b.progress(this.f, "Downloading image resourses");
                this.az();
                break;
            }
            case "Currency": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.1"));
                this.ab();
                break;
            }
            case "StoreSession": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.2"));
                this.i();
                break;
            }
            case "StoreSessionControl": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.57"));
                this.a();
                break;
            }
            case "CashDrawer": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.3"));
                this.h();
                break;
            }
            case "TerminalType": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.4"));
                this.i = this.K();
                break;
            }
            case "Terminal": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.5"));
                this.J();
                break;
            }
            case "CashBreakdown": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.6"));
                this.j();
                break;
            }
            case "TaxGroup": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.11"));
                this.ac();
                break;
            }
            case "Tax": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.12"));
                this.ad();
                break;
            }
            case "Department": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.8"));
                this.g = this.aa();
                break;
            }
            case "UserType": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.9"));
                this.I();
                break;
            }
            case "User": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.10"));
                this.H();
                break;
            }
            case "Customer": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.13"));
                this.x();
                break;
            }
            case "MenuItemSize": {
                this.b.progress(this.f, "Downloading menu items size..");
                this.E();
                break;
            }
            case "PizzaCrust": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.52"));
                this.ag();
                break;
            }
            case "PizzaPrice": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.53"));
                this.af();
                break;
            }
            case "MenuModifier": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.14"));
                this.B();
                break;
            }
            case "ModifierGroup": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.15"));
                this.C();
                break;
            }
            case "MenuCategory": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.16"));
                this.G();
                break;
            }
            case "MenuGroup": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.17"));
                this.F();
                break;
            }
            case "AttributeGroup": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.18"));
                this.ay();
                break;
            }
            case "Attribute": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.19"));
                this.ax();
                break;
            }
            case "MenuItem": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.20"));
                this.D();
                break;
            }
            case "InventoryVendor": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.21"));
                this.w();
                break;
            }
            case "InventoryVendorItems": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.22"));
                this.v();
                break;
            }
            case "InventoryUnitGroup": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.23"));
                this.p();
                break;
            }
            case "InventoryUnit": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.24"));
                this.q();
                break;
            }
            case "PackagingUnit": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.25"));
                this.r();
                break;
            }
            case "InventoryStockUnit": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.26"));
                this.s();
                break;
            }
            case "InventoryLocation": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.27"));
                this.u();
                break;
            }
            case "InventoryTransaction": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.28"));
                this.t();
                break;
            }
            case "InventoryStock": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.29"));
                this.o();
                break;
            }
            case "InventoryClosingBalance": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.30"));
                this.n();
                break;
            }
            case "ShopFloor": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.31"));
                this.m();
                break;
            }
            case "ShopTable": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.32"));
                this.l();
                break;
            }
            case "BookingInfo": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.33"));
                this.k();
                break;
            }
            case "Ticket": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.34"));
                this.g();
                break;
            }
            case "Shift": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.35"));
                this.f();
                break;
            }
            case "Address": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.36"));
                this.e();
                break;
            }
            case "AttendenceHistory": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.37"));
                this.d();
                break;
            }
            case "CookingInstruction": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.38"));
                this.av();
                break;
            }
            case "Course": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.39"));
                this.au();
                break;
            }
            case "CustomerGroup": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.40"));
                this.at();
                break;
            }
            case "CustomPayment": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.41"));
                this.as();
                break;
            }
            case "DeclaredTips": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.42"));
                this.ar();
                break;
            }
            case "DeliveryAddress": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.43"));
                this.aq();
                break;
            }
            case "DeliveryCharge": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.44"));
                this.ap();
                break;
            }
            case "Discount": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.45"));
                this.ao();
                break;
            }
            case "GiftCard": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.46"));
                this.am();
                break;
            }
            case "GratuityPaymentHistory": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.47"));
                this.al();
                break;
            }
            case "DeliveryInstruction": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.48"));
                this.ak();
                break;
            }
            case "Multiplier": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.49"));
                this.aj();
                break;
            }
            case "MenuItemModifierSpec": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.50"));
                this.ai();
                break;
            }
            case "MenuItemModifierPage": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.51"));
                this.ah();
                break;
            }
            case "MenuPage": {
                this.b.progress(this.f, "Downloading MenuPage..");
                this.ae();
                break;
            }
            case "SalesArea": {
                this.b.progress(this.f, Messages.getString("CloudDataDownloader.54"));
                this.M();
                break;
            }
            case "PriceTable": {
                this.b.progress(this.f, "Downloading Price Table");
                this.z();
                break;
            }
            case "PriceRule": {
                this.b.progress(this.f, "Downloading Price Rules");
                this.A();
                break;
            }
            case "ReportGroup": {
                this.b.progress(this.f, "Downloading Report Groups");
                this.N();
                break;
            }
            case "PrinterGroup": {
                this.b.progress(this.f, "Downloading Printer Groups");
                this.O();
                break;
            }
            case "VirtualPrinter": {
                this.b.progress(this.f, "Downloading Printers");
                this.Z();
                break;
            }
            case "VoidReason": {
                this.b.progress(this.f, "Downloading Void Reasons");
                this.P();
                break;
            }
            case "ShopTableType": {
                this.b.progress(this.f, "Downloading table types");
                this.Q();
                break;
            }
            case "ActionHistory": {
                this.b.progress(this.f, "Downloading action histories");
                this.S();
                break;
            }
            case "VoidItem": {
                this.b.progress(this.f, "Downloading void items");
                this.T();
                break;
            }
            case "Recepie": {
                this.b.progress(this.f, "Downloading recipes");
                this.U();
                break;
            }
            case "PurchaseOrder": {
                this.b.progress(this.f, "Downloading purchase orders");
                this.V();
                break;
            }
            case "StockCount": {
                this.b.progress(this.f, "Downloading stock counts");
                this.W();
                break;
            }
            case "ShopFloorTemplate": {
                this.b.progress(this.f, "Downloading shop floor templates");
                this.X();
                break;
            }
            case "CronJob": {
                this.b.progress(this.f, "Downloading cron jobs");
                this.Y();
                break;
            }
            case "Gratuity": {
                this.b.progress(this.f, "Downloading gratuity");
                this.an();
                break;
            }
            case "SlideShowImage": {
                this.b.progress(this.f, "Downloading slide images");
                this.R();
                break;
            }
            case "DeletedData": {
                this.b.progress(this.f, "Downloading deleted data");
                this.aw();
                break;
            }
            default: {
                PosLog.debug(this.getClass(), "Download skipped for " + dataSyncInfo.getRef());
            }
        }
        this.b.progress(50, Messages.getString("CloudDataDownloader.55"));
    }

    private void a(List<Department> list, List<OrderType> list2, List<TerminalType> list3) {
        List<OrderType> list4;
        TimedModel timedModel;
        if (list != null && list.size() > 0) {
            for (Department timedModel2 : list) {
                timedModel = DepartmentDAO.getInstance().get(timedModel2.getId());
                if (timedModel == null) continue;
                list4 = timedModel2.getOrderTypes();
                this.a(list4);
                ((BaseDepartment)((Object)timedModel)).setOrderTypes(list4);
                ((BaseDepartment)((Object)timedModel)).setOutlets(timedModel2.getOutlets());
                ((Department)timedModel).setUpdateLastUpdateTime(false);
                DepartmentDAO.getInstance().update((Department)timedModel);
            }
        }
        if (list3 != null && list3.size() > 0) {
            for (TerminalType terminalType : list3) {
                timedModel = TerminalTypeDAO.getInstance().get(terminalType.getId());
                if (timedModel == null) continue;
                ((BaseTerminalType)((Object)timedModel)).setCategories(terminalType.getCategories());
                list4 = terminalType.getOrderTypes();
                this.a(list4);
                ((BaseTerminalType)((Object)timedModel)).setOrderTypes(list4);
                ((TerminalType)timedModel).setUpdateLastUpdateTime(false);
                TerminalTypeDAO.getInstance().update((TerminalType)timedModel);
            }
        }
        if (list2 != null && list2.size() > 0) {
            this.a(list2);
            for (OrderType orderType : list2) {
                timedModel = OrderTypeDAO.getInstance().get(orderType.getId());
                if (timedModel == null) continue;
                ((BaseOrderType)((Object)timedModel)).setTerminalTypes(orderType.getTerminalTypes());
                ((BaseOrderType)((Object)timedModel)).setCategories(orderType.getCategories());
                ((BaseOrderType)((Object)timedModel)).setDepartments(orderType.getDepartments());
                ((OrderType)timedModel).setUpdateLastUpdateTime(false);
                OrderTypeDAO.getInstance().update((OrderType)timedModel);
            }
        }
    }

    private void a(List<OrderType> list) {
        if (this.j == null || this.j.size() == 0) {
            return;
        }
        if (list != null && list.size() > 0) {
            Iterator<OrderType> iterator = list.iterator();
            while (iterator.hasNext()) {
                OrderType orderType = iterator.next();
                if (!this.j.contains(orderType.getId())) continue;
                iterator.remove();
            }
        }
    }

    private void a() {
        try {
            List<StoreSessionControl> list = this.c.getAllStoreSessionControls();
            this.a("Downloading " + list.size() + " store session control.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                StoreSessionControlDAO.getInstance().saveOrUpdateStoreSessionControl(list, false, true);
                this.a(StoreSessionControl.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading store session control failed...";
            this.a(string, exception);
        }
    }

    private List<DataSyncInfo> b() {
        List<DataSyncInfo> list = SyncService.getSyncModelClasses();
        for (DataSyncInfo object : list) {
            try {
                Date exception = this.c.getLastUpdateTime(object.getBeanClass());
                object.setLastUpdateTime(exception);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        try {
            return this.c.getUpdatedRowCount((GenericEntity)new GenericEntity<List<DataSyncInfo>>(list){});
        }
        catch (Exception exception) {
            String string = Messages.getString("CloudDataUploader.60");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            return null;
        }
    }

    private void c() throws PosException {
        try {
            List list = this.c.getAllStores();
            this.a("Downloading " + list.size() + " store.");
            if (list != null && list.size() > 0) {
                for (Store store : list) {
                    boolean bl = false;
                    Store store2 = StoreDAO.getInstance().get(store.getId());
                    if (store2 == null) continue;
                    if (BaseDataServiceDao.get().shouldSave(store.getLastUpdateTime(), store2.getLastUpdateTime())) {
                        Address address;
                        store2.setName(store.getName());
                        Address address2 = store.getAddress();
                        if (address2 != null && (address = AddressDAO.getInstance().get(address2.getId())) != null) {
                            address2.setVersion(address.getVersion());
                        }
                        store2.setAddress(address2);
                        store2.setAddressLine1(store.getAddressLine1());
                        store2.setAddressLine2(store.getAddressLine2());
                        store2.setAddressLine3(store.getAddressLine3());
                        store2.setZipCode(store.getZipCode());
                        store2.setTelephone(store.getTelephone());
                        store2.setDefaultGratuityPercentage(store.getDefaultGratuityPercentage());
                        store2.setServiceChargePercentage(store.getServiceChargePercentage());
                        store2.setDateFormat(store.getDateFormat());
                        store2.addProperty("logo.imageid", store.getProperty("logo.imageid"));
                        bl = true;
                    }
                    store2.setUuid(store.getUuid());
                    if (!bl && (!StringUtils.isNotBlank((String)store2.getUuid()) || !StringUtils.isNotBlank((String)store.getUuid()) || store2.getUuid().equals(store.getUuid()))) continue;
                    StoreDAO.getInstance().update(store2);
                    DataProvider.get().refreshStore();
                }
            }
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("Connection refused")) {
                throw new PosException("Connection failed.");
            }
            String string = "Downloading store failed...";
            this.a(string, exception);
        }
    }

    private void d() throws Exception {
        try {
            List<AttendenceHistory> list = this.c.getAllAttendenceHistories();
            this.a("Downloading " + list.size() + " attendence history.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                AttendenceHistoryDAO.getInstance().saveOrUpdateAttendenceHistoryList(list, false, true);
                this.a(AttendenceHistory.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading address failed...";
            this.a(string, exception);
        }
    }

    private void e() throws Exception {
        try {
            List<Address> list = this.c.getAllAddress();
            this.a("Downloading " + list.size() + " address.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                AddressDAO.getInstance().saveOrUpdateAddressList(list, false, true);
                this.a(Address.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading address failed...";
            this.a(string, exception);
        }
    }

    private void f() throws Exception {
        try {
            List<Shift> list = this.c.getAllShifts();
            this.a("Downloading " + list.size() + " shift.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                ShiftDAO.getInstance().saveOrUpdateShifts(list, false, true);
                this.a(Shift.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading shift failed...";
            this.a(string, exception);
        }
    }

    private void g() throws Exception {
        try {
            Object object;
            List<Ticket> list = this.c.getAllTickets();
            this.a("Downloading " + list.size() + " ticket.");
            Date date = new Date();
            if (this.j.size() > 0) {
                object = list.iterator();
                while (object.hasNext()) {
                    Ticket ticket = (Ticket)object.next();
                    if (StringUtils.isNotBlank((String)ticket.getOrderTypeId()) && this.j.contains(ticket.getOrderTypeId())) {
                        PosLog.debug(this.getClass(), "Ignored: Conflicted order type ticket# " + ticket.getId() + " :" + ticket.getOrderTypeId());
                        object.remove();
                        continue;
                    }
                    PosLog.debug(this.getClass(), "Accepted: Order type ticket# " + ticket.getId() + " :" + ticket.getOrderTypeId());
                }
            }
            object = new ArrayList();
            for (Ticket ticket : list) {
                try {
                    TicketDataServiceDao.get().saveOrUpdateTicket(ticket, false, true);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), "Failed to save ticket " + ticket.getId());
                    object.add(ticket);
                }
            }
            if (object.size() == 0) {
                this.a(Ticket.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading ticket failed...";
            this.a(string, exception);
            throw exception;
        }
    }

    private void h() throws Exception {
        try {
            List<CashDrawer> list = this.c.getAllCashDrawer();
            this.a("Downloading " + list.size() + " cash drawer .");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                CashDrawerDAO.getInstance().saveOrUpdateCashDrawer(list, false, true);
                this.a(CashDrawer.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading cash drawer failed...";
            this.a(string, exception);
        }
    }

    private void i() throws Exception {
        try {
            List<StoreSession> list = this.c.getAllStoreSession();
            this.a("Downloading " + list.size() + " store session.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                StoreSessionDAO.getInstance().saveOrUpdateStoreSessions(list, false, true);
                this.a(StoreSession.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading store session failed...";
            this.a(string, exception);
        }
    }

    private void j() throws Exception {
        this.a("Note: Cash breakdown linked with cash drawer.");
        this.a(CashBreakdown.class, new Date());
    }

    private void k() throws Exception {
        try {
            List<BookingInfo> list = this.c.getBookingInfos();
            this.a("Downloading " + list.size() + " booking info.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                BookingInfoDAO.getInstance().saveOrUpdateBookingInfos(list, false, true);
                this.a(BookingInfo.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading booking info failed...";
            this.a(string, exception);
        }
    }

    private void l() throws Exception {
        try {
            List<ShopTable> list = this.c.getShopTables();
            this.a("Downloading " + list.size() + " shop table .");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                ShopTableDAO.getInstance().saveOrUpdateShoptables(list, false, true);
                this.a(ShopTable.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading shop table failed...";
            this.a(string, exception);
        }
    }

    private void m() throws Exception {
        try {
            List<ShopFloor> list = this.c.getShopFloors();
            this.a("Downloading " + list.size() + " shop floor.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                ShopFloorDAO.getInstance().saveOrUpdateShopFloors(list, false, true);
                this.a(ShopFloor.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading shop floor failed...";
            this.a(string, exception);
        }
    }

    private void n() throws Exception {
        try {
            List<InventoryClosingBalance> list = this.c.getInventoryClosingBalance();
            this.a("Downloading " + list.size() + " inventory closing balance.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                InventoryClosingBalanceDAO.getInstance().saveOrUpdateInventoryClosingBalances(list, false, true);
                this.a(InventoryClosingBalance.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory closing balance failed...";
            this.a(string, exception);
        }
    }

    private void o() throws Exception {
        try {
            Date date = new Date();
            PosLog.info(this.getClass(), "Note: Menu Item Inventory Status && Inventory stock will be adjusted using inventory transaction.");
            this.a(InventoryStock.class, date);
        }
        catch (Exception exception) {
            String string = "Downloading inventory stock failed...";
            this.a(string, exception);
        }
    }

    private void p() throws Exception {
        try {
            List<InventoryUnitGroup> list = this.c.getAllInventoryUnitGroups();
            this.a("Downloading " + list.size() + " inventory unit group.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                InventoryUnitGroupDAO.getInstance().saveOrUpdateInventoryUnitGroups(list, false, true);
                this.a(InventoryUnitGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory unit group failed...";
            this.a(string, exception);
        }
    }

    private void q() throws Exception {
        try {
            List<InventoryUnit> list = this.c.getAllInventoryUnits();
            this.a("Downloading " + list.size() + " inventory unit.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                InventoryUnitDAO.getInstance().saveOrUpdateInventoryUnits(list, false, true);
                this.a(InventoryUnit.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory unit failed...";
            this.a(string, exception);
        }
    }

    private void r() throws Exception {
        try {
            List<PackagingUnit> list = this.c.getAllPackagingUnits();
            this.a("Downloading " + list.size() + " packaging unit.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                PackagingUnitDAO.getInstance().saveOrUpdatePackagingUnits(list, false, true);
                this.a(PackagingUnit.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading packaging unit failed...";
            this.a(string, exception);
        }
    }

    private void s() throws Exception {
        this.a("Note: Inventory stock unit linked with menu item");
        this.a(InventoryStockUnit.class, new Date());
    }

    private void t() throws Exception {
        try {
            List<InventoryTransaction> list = this.c.getInventoryTransactions();
            this.a("Downloading " + list.size() + " inventory transaction.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                BaseDataServiceDao.get().saveOrUpdateInventoryTransactions(list, false, true);
                this.a(InventoryTransaction.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory transaction failed...";
            this.a(string, exception);
        }
    }

    private void u() throws Exception {
        try {
            List<InventoryLocation> list = this.c.getInventoryLocations();
            this.a("Downloading " + list.size() + " inventory location.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                InventoryLocationDAO.getInstance().saveOrUpdateInventoryLocation(list, false, true);
                this.a(InventoryLocation.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory locations failed...";
            this.a(string, exception);
        }
    }

    private void v() throws Exception {
        try {
            List<InventoryVendorItems> list = this.c.getInventoryVendorItems();
            this.a("Downloading " + list.size() + " inventory vendor item.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                InventoryVendorItemsDAO.getInstance().saveOrUpdateInventoryVendorItems(list, false, true);
                this.a(InventoryVendorItems.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory vendor items failed...";
            this.a(string, exception);
        }
    }

    private void w() throws Exception {
        try {
            List<InventoryVendor> list = this.c.getInventoryVendors();
            this.a("Downloading " + list.size() + " inventory vendor.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                InventoryVendorDAO.getInstance().saveOrUpdateInventoryVendors(list, false, true);
                this.a(InventoryVendor.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading inventory vendor failed...";
            this.a(string, exception);
        }
    }

    private void a(Class<?> clazz, Date date) {
        GenericDAO.getInstance().updateLastUpdateTimeProperty(clazz, date);
    }

    private void x() throws Exception {
        try {
            List<Customer> list = this.c.getCustomers();
            this.a("Downloading " + list.size() + " customer.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                CustomerDAO.getInstance().saveOrUpdateCustomers(list, false, true);
                this.a(Customer.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading customer failed...";
            this.a(string, exception);
        }
    }

    private void y() throws Exception {
        try {
            List<Outlet> list = this.c.getOutlets();
            this.a("Downloading " + list.size() + " outlets.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                OutletDAO.getInstance().saveOrUpdateOutlets(list, false, true);
                this.a(Outlet.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading outlet failed...";
            this.a(string, exception);
        }
    }

    private void z() throws Exception {
        List<PriceTable> list = this.c.getPriceList();
        this.a("Downloading " + list.size() + " price list.");
        if (list != null && list.size() > 0) {
            Date date = new Date();
            for (PriceTable priceTable : list) {
                Object object;
                PriceTableDAO priceTableDAO = PriceTableDAO.getInstance();
                PriceTable priceTable2 = PriceTableDAO.getInstance().get(priceTable.getId());
                if (priceTable2 != null) {
                    object = priceTable2.getId();
                    long l = priceTable2.getVersion();
                    PropertyUtils.copyProperties((Object)priceTable2, (Object)priceTable);
                    priceTable2.setId((String)object);
                    priceTable2.setVersion(l);
                    priceTableDAO.update(priceTable2);
                } else {
                    priceTable.setVersion(0L);
                    priceTableDAO.save(priceTable);
                }
                if ((object = priceTable.getPriceTableItems()) == null) continue;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    PriceTableItem priceTableItem = (PriceTableItem)iterator.next();
                    PriceTableItem priceTableItem2 = PriceTableItemDAO.getInstance().get(priceTableItem.getId());
                    if (priceTableItem2 != null) {
                        String string = priceTableItem2.getId();
                        long l = priceTableItem2.getVersion();
                        PropertyUtils.copyProperties((Object)priceTableItem2, (Object)priceTableItem);
                        priceTableItem2.setId(string);
                        priceTableItem2.setVersion(l);
                        PriceTableItemDAO.getInstance().update(priceTableItem2);
                        continue;
                    }
                    priceTableItem.setVersion(0L);
                    PriceTableItemDAO.getInstance().save(priceTableItem);
                }
            }
            this.a(PriceTable.class, date);
        }
    }

    private void A() throws Exception {
        List<PriceRule> list = this.c.getPriceRules();
        this.a("Downloading " + list.size() + " price rule.");
        if (list != null && list.size() > 0) {
            for (PriceRule priceRule : list) {
                PriceShift priceShift = priceRule.getPriceShift();
                if (priceShift != null) {
                    priceRule.setPriceShift((PriceShift)ShiftDAO.getInstance().findByName(priceShift.getName()));
                }
                PriceRuleDAO priceRuleDAO = PriceRuleDAO.getInstance();
                PriceRule priceRule2 = PriceRuleDAO.getInstance().get(priceRule.getId());
                if (priceRule2 != null) {
                    String string = priceRule2.getId();
                    long l = priceRule2.getVersion();
                    PropertyUtils.copyProperties((Object)priceRule2, (Object)priceRule);
                    priceRule2.setId(string);
                    priceRule2.setVersion(l);
                    priceRuleDAO.update(priceRule2);
                    continue;
                }
                priceRule.setVersion(0L);
                priceRuleDAO.save(priceRule);
            }
        }
        Date date = new Date();
        this.a(PriceRule.class, date);
    }

    private void B() throws Exception {
        try {
            List<MenuModifier> list = this.c.getMenuModifiers();
            this.a("Downloading " + list.size() + " menu modifier.");
            if (list != null) {
                Date date = new Date();
                BaseDataServiceDao.get().saveOrUpdateMenuModifiers(list, false, true);
                this.a(MenuModifier.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu modifier failed...";
            this.a(string, exception);
        }
    }

    private void C() throws Exception {
        try {
            List<ModifierGroup> list = this.c.getModifierGroups();
            this.a("Downloading " + list.size() + " menu modifier group.");
            if (list != null) {
                Date date = new Date();
                ModifierGroupDAO.getInstance().saveOrUpdateModifierGroups(list, false, true);
                this.a(ModifierGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu modifier group failed...";
            this.a(string, exception);
        }
    }

    private void D() throws Exception {
        try {
            boolean bl = false;
            boolean bl2 = true;
            List<MenuItem> list = this.c.getMenuItems();
            this.a("Downloading " + list.size() + " menu item .");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.get();
                List<MenuItem> list2 = baseDataServiceDao.saveOrUpdateMenuItems(list, bl, bl2);
                if (list2 != null && list2.size() > 0) {
                    list2 = baseDataServiceDao.saveOrUpdateMenuItems(list2, bl, bl2);
                }
                if (list2 == null || list2.size() == 0) {
                    this.a(MenuItem.class, date);
                }
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu item failed...";
            this.a(string, exception);
        }
    }

    private void E() throws Exception {
        try {
            boolean bl = false;
            boolean bl2 = true;
            List<MenuItemSize> list = this.c.getMenuItemSize();
            this.a("Downloading " + list.size() + " menu item size.");
            if (list != null) {
                Date date = new Date();
                MenuItemSizeDAO.getInstance().saveOrUpdateMenuItemSize(list, bl, bl2);
                this.a(MenuItemSize.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu item size failed...";
            this.a(string, exception);
        }
    }

    private void F() throws Exception {
        try {
            List<MenuGroup> list = this.c.getMenuGroups();
            this.a("Downloading " + list.size() + " menu group.");
            if (list != null) {
                Date date = new Date();
                MenuGroupDAO.getInstance().saveOrUpdateMenuGroups(list, false, true);
                this.a(MenuGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu groups failed...";
            this.a(string, exception);
        }
    }

    private void G() throws Exception {
        try {
            List<MenuCategory> list = this.c.getMenuCategories();
            this.a("Downloading " + list.size() + " menu category.");
            if (list != null) {
                Date date = new Date();
                MenuCategoryDAO.getInstance().saveOrUpdateMenuCategorys(list, false, true);
                this.a(MenuCategory.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu category failed...";
            this.a(string, exception);
        }
    }

    private void H() throws Exception {
        try {
            List<User> list = this.c.getUsers();
            this.a("Downloading " + list.size() + " user.");
            if (list != null) {
                Date date = new Date();
                BaseDataServiceDao.getInstance().saveOrUpdateUsers(list, false, true);
                this.a(User.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading user failed...";
            this.a(string, exception);
        }
    }

    private void I() throws Exception {
        try {
            List<UserType> list = this.c.getUserTypes();
            this.a("Downloading " + list.size() + " user type.");
            if (list != null) {
                Date date = new Date();
                UserTypeDAO.getInstance().saveOrUpdateUserTypes(list, false, true);
                this.a(UserType.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading user type failed...";
            this.a(string, exception);
        }
    }

    private void J() throws Exception {
        try {
            List<Terminal> list = this.c.getTerminals();
            this.a("Downloading " + list.size() + " termianl.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                TerminalDAO.getInstance().saveOrUpdateTerminal(list, false, true);
                this.a(Terminal.class, date);
                if (list.indexOf(Application.getInstance().getTerminal()) != -1) {
                    Application.getInstance().refreshAndGetTerminal();
                }
            }
        }
        catch (Exception exception) {
            String string = "Downloading terminal failed...";
            this.a(string, exception);
        }
    }

    private List<TerminalType> K() throws Exception {
        ArrayList<TerminalType> arrayList = new ArrayList<TerminalType>();
        try {
            List<TerminalType> list = this.c.getTerminalTypes();
            this.a("Downloading " + list.size() + " terminalType.");
            if (list != null) {
                for (TerminalType terminalType : list) {
                    TerminalType terminalType2 = XMLTransientUtil.getLazyData(terminalType);
                    if (terminalType2 != null) {
                        arrayList.add(terminalType2);
                    }
                    XMLTransientUtil.makeXMLTransient(terminalType);
                }
                Date date = new Date();
                TerminalTypeDAO.getInstance().saveOrUpdateTerminalTypes(list, false, true);
                this.a(TerminalType.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading terminal type failed...";
            this.a(string, exception);
        }
        return arrayList;
    }

    private List<OrderType> L() throws Exception {
        ArrayList<OrderType> arrayList = new ArrayList<OrderType>();
        try {
            List<OrderType> list = this.c.getOrderTypes();
            this.a("Downloading " + list.size() + " ordertype.");
            if (list != null) {
                this.b(list);
                Object object = list.iterator();
                while (object.hasNext()) {
                    OrderType orderType = object.next();
                    if (this.j.size() > 0 && this.j.contains(orderType.getId())) {
                        PosLog.debug(this.getClass(), "Ignored conflicted order type: " + orderType.getId());
                        object.remove();
                        continue;
                    }
                    OrderType orderType2 = XMLTransientUtil.getLazyData(orderType);
                    if (orderType2 != null) {
                        arrayList.add(orderType2);
                    }
                    XMLTransientUtil.makeXMLTransient(orderType);
                }
                if (list.size() > 0) {
                    object = new Date();
                    OrderTypeDAO.getInstance().saveOrUpdateOrderTypes(list, false, true);
                    this.a(OrderType.class, (Date)object);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            String string = "Downloading order type failed...";
            this.a(string, exception);
        }
        return arrayList;
    }

    private void b(List<OrderType> list) throws InterruptedException {
        this.j.clear();
        String string = StoreDAO.getRestaurant().getProperty("sync.conflict_resolve_option");
        if (string != null && string.equalsIgnoreCase(Messages.getString("Merge"))) {
            return;
        }
        for (OrderType orderType : list) {
            if (orderType.isDeleted().booleanValue()) continue;
            try {
                GenericDAO.getInstance().checkIdOrNameExists(orderType.getId(), orderType.getName(), OrderType.class);
            }
            catch (DuplicateDataException duplicateDataException) {
                this.j.add(orderType.getId());
            }
        }
        if (string != null && string.equalsIgnoreCase(Messages.getString("Ignore"))) {
            return;
        }
        if (this.j.size() > 0) {
            String string2 = DataMismatchMessageDialog.show(POSConstants.CONFIRM, Messages.getString("DataMismatchPromptMsg"), new String[]{Messages.getString("Merge"), Messages.getString("Ignore")});
            if (string2 == null || string2.equals(POSConstants.CANCEL)) {
                throw new InterruptedException(Messages.getString("SyncCancelled"));
            }
            if (string2.equals(Messages.getString("Merge"))) {
                this.j.clear();
                return;
            }
        }
    }

    private void M() throws Exception {
        try {
            List<SalesArea> list = this.c.getSalesArea();
            this.a("Downloading " + list.size() + " salesArea.");
            if (list != null) {
                Date date = new Date();
                SalesAreaDAO.getInstance().saveOrUpdateSalesArea(list, false, true);
                this.a(SalesArea.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading salesarea failed...";
            this.a(string, exception);
        }
    }

    private void N() throws Exception {
        try {
            List<ReportGroup> list = this.c.getReportGroup();
            this.a("Downloading " + list.size() + " reportGroup.");
            if (list != null) {
                Date date = new Date();
                ReportGroupDAO.getInstance().saveOrUpdateReportGroup(list, false, true);
                this.a(ReportGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading reportGroup failed...";
            this.a(string, exception);
        }
    }

    private void O() throws Exception {
        try {
            List<PrinterGroup> list = this.c.getPrinterGroup();
            this.a("Downloading " + list.size() + " printerGroup.");
            if (list != null) {
                Date date = new Date();
                PrinterGroupDAO.getInstance().saveOrUpdatePrinterGroup(list, false, true);
                this.a(PrinterGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading printerGroup failed...";
            this.a(string, exception);
        }
    }

    private void P() throws Exception {
        try {
            List<VoidReason> list = this.c.getVoidReason();
            this.a("Downloading " + list.size() + " voidReason.");
            if (list != null) {
                Date date = new Date();
                VoidReasonDAO.getInstance().saveOrUpdateVoidReason(list, false, true);
                this.a(VoidReason.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading voidReason failed...";
            this.a(string, exception);
        }
    }

    private void Q() throws Exception {
        try {
            List<ShopTableType> list = this.c.getShopTableType();
            this.a("Downloading " + list.size() + " table types.");
            if (list != null) {
                Date date = new Date();
                ShopTableTypeDAO.getInstance().saveOrUpdateShopTableType(list, false, true);
                this.a(ShopTableType.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading table types failed...";
            this.a(string, exception);
        }
    }

    private void R() throws Exception {
        try {
            List<SlideShowImage> list = this.c.getSlideShowImage();
            this.a("Downloading " + list.size() + " slide images.");
            if (list != null) {
                Date date = new Date();
                SlideShowImageDAO.getInstance().saveOrUpdateSlideShowImage(list, false, true);
                this.a(SlideShowImage.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading slide images failed...";
            this.a(string, exception);
        }
    }

    private void S() throws Exception {
        try {
            List<ActionHistory> list = this.c.getActionHistory();
            this.a("Downloading " + list.size() + " action histories.");
            if (list != null) {
                Date date = new Date();
                ActionHistoryDAO.getInstance().saveOrUpdateActionHistory(list, false, true);
                this.a(ActionHistory.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading action histories failed...";
            this.a(string, exception);
        }
    }

    private void T() throws Exception {
        try {
            List<VoidItem> list = this.c.getVoidItem();
            this.a("Downloading " + list.size() + " void items.");
            if (list != null) {
                Date date = new Date();
                VoidItemDAO.getInstance().saveOrUpdateVoidItem(list, false, true);
                this.a(VoidItem.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading void items failed...";
            this.a(string, exception);
        }
    }

    private void U() throws Exception {
        try {
            List<Recepie> list = this.c.getRecipe();
            this.a("Downloading " + list.size() + " recipes.");
            if (list != null) {
                Date date = new Date();
                RecepieDAO.getInstance().saveOrUpdateRecipes(list, false, true);
                this.a(Recepie.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading recipes failed...";
            this.a(string, exception);
        }
    }

    private void V() throws Exception {
        try {
            List<PurchaseOrder> list = this.c.getPurchaseOrder();
            this.a("Downloading " + list.size() + " purchase orders.");
            if (list != null) {
                Date date = new Date();
                PurchaseOrderDAO.getInstance().saveOrUpdatePurchaseOrders(list, false, true);
                this.a(PurchaseOrder.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading purchase orders failed...";
            this.a(string, exception);
        }
    }

    private void W() throws Exception {
        try {
            List<StockCount> list = this.c.getStockCount();
            this.a("Downloading " + list.size() + " stock counts.");
            if (list != null) {
                Date date = new Date();
                StockCountDAO.getInstance().saveOrUpdateStockCounts(list, false, true);
                this.a(StockCount.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading stock counts failed...";
            this.a(string, exception);
        }
    }

    private void X() throws Exception {
        try {
            List<ShopFloorTemplate> list = this.c.getShopFloorTemplate();
            this.a("Downloading " + list.size() + " shop floor templates.");
            if (list != null) {
                Date date = new Date();
                ShopFloorTemplateDAO.getInstance().saveOrUpdateShopFloorTemplates(list, false, true);
                this.a(ShopFloorTemplate.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading shop floor templates failed...";
            this.a(string, exception);
        }
    }

    private void Y() throws Exception {
        try {
            List<CronJob> list = this.c.getCronJob();
            this.a("Downloading " + list.size() + " cron jobs.");
            if (list != null) {
                Date date = new Date();
                CronJobDAO.getInstance().saveOrUpdateCronJob(list, false, true);
                for (CronJob cronJob : list) {
                    OroCronJobManager.getInstance().reScheduleJob(cronJob);
                }
                this.a(CronJob.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading cron jobs failed...";
            this.a(string, exception);
        }
    }

    private void Z() throws Exception {
        try {
            List<VirtualPrinter> list = this.c.getVirtualPrinter();
            this.a("Downloading " + list.size() + " virtualPrinter.");
            if (list != null) {
                Date date = new Date();
                VirtualPrinterDAO.getInstance().saveOrUpdateVirtualPrinter(list, false, true);
                this.a(VirtualPrinter.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading virtualPrinter failed...";
            this.a(string, exception);
        }
    }

    private List<Department> aa() throws Exception {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        try {
            List<Department> list = this.c.getDepartments();
            this.a("Downloading " + list.size() + " department.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                for (Department department : list) {
                    Department department2 = XMLTransientUtil.getLazyData(department);
                    if (department2 != null) {
                        arrayList.add(department2);
                    }
                    XMLTransientUtil.makeXMLTransient(department);
                }
                DepartmentDAO.getInstance().saveOrUpdateDepartments(list, false, true);
                this.a(Department.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading departments failed...";
            this.a(string, exception);
        }
        return arrayList;
    }

    private void a(Object object, Object object2) {
        try {
            BeanUtils.copyProperties((Object)object, (Object)object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ab() throws Exception {
        try {
            List<Currency> list = this.c.getCurrencies();
            this.a("Downloading " + list.size() + " currency.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                CurrencyDAO.getInstance().saveOrUpdateCurrency(list, false, true);
                this.a(Currency.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading currencies failed...";
            this.a(string, exception);
        }
    }

    private void ac() throws Exception {
        try {
            boolean bl = false;
            boolean bl2 = true;
            List<TaxGroup> list = this.c.getTaxGroups();
            this.a("Downloading " + list.size() + " tax-group.");
            Date date = new Date();
            if (list != null && list.size() > 0) {
                for (TaxGroup taxGroup : list) {
                    Object object;
                    ArrayList<Tax> arrayList = new ArrayList<Tax>();
                    if (taxGroup.getTaxes() != null) {
                        for (Tax tax : taxGroup.getTaxes()) {
                            object = TaxDAO.getInstance().get(tax.getId());
                            if (arrayList == null) continue;
                            arrayList.add((Tax)object);
                        }
                    }
                    taxGroup.setTaxes(arrayList);
                    TaxGroupDAO taxGroupDAO = TaxGroupDAO.getInstance();
                    TaxGroup comparable2 = taxGroupDAO.get(taxGroup.getId());
                    if (comparable2 != null) {
                        object = comparable2.getId();
                        long l = comparable2.getVersion();
                        PropertyUtils.copyProperties((Object)comparable2, (Object)taxGroup);
                        comparable2.setId((String)object);
                        comparable2.setVersion(l);
                        comparable2.setUpdateLastUpdateTime(bl);
                        comparable2.setUpdateSyncTime(bl2);
                        taxGroupDAO.update(comparable2);
                        continue;
                    }
                    taxGroup.setVersion(0L);
                    taxGroup.setUpdateLastUpdateTime(bl);
                    taxGroup.setUpdateSyncTime(bl2);
                    taxGroupDAO.save(taxGroup);
                }
                this.a(TaxGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading tax-group failed...";
            this.a(string, exception);
        }
    }

    private void ad() throws Exception {
        try {
            List<Tax> list = this.c.getTaxes();
            this.a("Downloading " + list.size() + " tax.");
            if (list != null && list.size() > 0) {
                Date date = new Date();
                TaxDAO.getInstance().saveOrUpdateTaxs(list, false, true);
                this.a(Tax.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading tax failed...";
            this.a(string, exception);
        }
    }

    private void ae() throws Exception {
        try {
            List<MenuPage> list = this.c.getMenuPage();
            this.a("Downloading " + list.size() + " menu page.");
            if (list != null) {
                Date date = new Date();
                Iterator<MenuPage> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MenuPage menuPage = iterator.next();
                    if (!StringUtils.isNotBlank((String)menuPage.getOrderTypeId()) || !this.j.contains(menuPage.getOrderTypeId())) continue;
                    iterator.remove();
                }
                MenuPageDAO.getInstance().saveOrUpdateMenuPageList(list, false, true);
                this.a(MenuPage.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading menu page failed...";
            this.a(string, exception);
        }
    }

    private void af() throws Exception {
        try {
            List<PizzaPrice> list = this.c.getPizzaPrice();
            this.a("Downloading " + list.size() + " pizza price.");
            if (list != null) {
                Date date = new Date();
                if (this.j != null && this.j.size() > 0) {
                    Iterator<PizzaPrice> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        PizzaPrice pizzaPrice = iterator.next();
                        OrderType orderType = pizzaPrice.getOrderType();
                        if (orderType == null || !this.j.contains(orderType.getId())) continue;
                        iterator.remove();
                    }
                }
                PizzaPriceDAO.getInstance().saveOrUpdatePizzaPriceList(list, false, true);
                this.a(PizzaPrice.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading pizza price failed...";
            this.a(string, exception);
        }
    }

    private void ag() throws Exception {
        try {
            List<PizzaCrust> list = this.c.getPizzaCrust();
            this.a("Downloading " + list.size() + " pizza crust.");
            if (list != null) {
                Date date = new Date();
                PizzaCrustDAO.getInstance().saveOrUpdatePizzaCrustList(list, false, true);
                this.a(PizzaCrust.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading pizza crust failed...";
            this.a(string, exception);
        }
    }

    private void ah() throws Exception {
        this.a("Note: Menu item modifier page linked with menu item spec.");
        this.a(MenuItemModifierPage.class, new Date());
    }

    private void ai() throws Exception {
        this.a("Note: Menu item modifier spec linked with menu item.");
        this.a(MenuItemModifierSpec.class, new Date());
    }

    private void aj() throws Exception {
        try {
            List<Multiplier> list = this.c.getMultiplier();
            this.a("Downloading " + list.size() + " multiplier.");
            if (list != null) {
                Date date = new Date();
                MultiplierDAO.getInstance().saveOrUpdateMultiplierList(list, false, true);
                this.a(Multiplier.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading multiplier failed...";
            this.a(string, exception);
        }
    }

    private void ak() throws Exception {
        try {
            List<DeliveryInstruction> list = this.c.getDeliveryInstruction();
            this.a("Downloading " + list.size() + " delivery instruction.");
            if (list != null) {
                Date date = new Date();
                DeliveryInstructionDAO.getInstance().saveOrUpdateDeliveryInstructionList(list, false, true);
                this.a(DeliveryInstruction.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading delivery instruction failed...";
            this.a(string, exception);
        }
    }

    private void al() throws Exception {
        try {
            List<GratuityPaymentHistory> list = this.c.getGratuityPaymentHistory();
            this.a("Downloading " + list.size() + " gratuity payment history.");
            if (list != null) {
                Date date = new Date();
                GratuityPaymentHistoryDAO.getInstance().saveOrUpdateGratuityPaymentHistoryList(list, false, true);
                this.a(GratuityPaymentHistory.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading gratuity payment history failed...";
            this.a(string, exception);
        }
    }

    private void am() throws Exception {
        try {
            List<GiftCard> list = this.c.getGiftCard();
            this.a("Downloading " + list.size() + " gift card.");
            if (list != null) {
                Date date = new Date();
                GiftCardDAO.getInstance().saveOrUpdateGiftCardList(list, false, true);
                this.a(GiftCard.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading gift card failed...";
            this.a(string, exception);
        }
    }

    private void an() throws Exception {
        try {
            List<Gratuity> list = this.c.getGratuity();
            this.a("Downloading " + list.size() + " gratuity.");
            if (list != null) {
                Date date = new Date();
                GratuityDAO.getInstance().saveOrUpdateGratuityList(list, false, true);
                this.a(Gratuity.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading gratuity failed...";
            this.a(string, exception);
        }
    }

    private void ao() throws Exception {
        try {
            List<Discount> list = this.c.getDiscount();
            this.a("Downloading " + list.size() + " discount.");
            if (list != null) {
                Date date = new Date();
                DiscountDAO.getInstance().saveOrUpdateDiscountList(list, false, true);
                this.a(Discount.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading discount failed...";
            this.a(string, exception);
        }
    }

    private void ap() throws Exception {
        try {
            List<DeliveryCharge> list = this.c.getDeliveryCharge();
            this.a("Downloading " + list.size() + " delivery charge .");
            if (list != null) {
                Date date = new Date();
                DeliveryChargeDAO.getInstance().saveOrUpdateDeliveryChargeList(list, false, true);
                this.a(DeliveryCharge.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading delivery charge  failed...";
            this.a(string, exception);
        }
    }

    private void aq() throws Exception {
        try {
            List<DeliveryAddress> list = this.c.getDeliveryAddress();
            this.a("Downloading " + list.size() + " delivery address.");
            if (list != null) {
                Date date = new Date();
                DeliveryAddressDAO.getInstance().saveOrUpdateDeliveryAddressList(list, false, true);
                this.a(DeliveryAddress.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading delivery address failed...";
            this.a(string, exception);
        }
    }

    private void ar() throws Exception {
        try {
            List<DeclaredTips> list = this.c.getDeclaredTips();
            this.a("Downloading " + list.size() + " declared tips.");
            if (list != null) {
                Date date = new Date();
                DeclaredTipsDAO.getInstance().saveOrUpdateDeclaredTipsList(list, false, true);
                this.a(DeclaredTips.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading declared tips failed...";
            this.a(string, exception);
        }
    }

    private void as() throws Exception {
        try {
            List<CustomPayment> list = this.c.getCustomPayment();
            this.a("Downloading " + list.size() + " custom payment.");
            if (list != null) {
                Date date = new Date();
                CustomPaymentDAO.getInstance().saveOrUpdateCustomPaymentList(list, false, true);
                this.a(CustomPayment.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading custom payment failed...";
            this.a(string, exception);
        }
    }

    private void at() throws Exception {
        try {
            List<CustomerGroup> list = this.c.getCustomerGroup();
            this.a("Downloading " + list.size() + " customer group.");
            if (list != null) {
                Date date = new Date();
                CustomerGroupDAO.getInstance().saveOrUpdateCustomerGroupList(list, false, true);
                this.a(CustomerGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading customer group failed...";
            this.a(string, exception);
        }
    }

    private void au() throws Exception {
        try {
            List<Course> list = this.c.getCourses();
            this.a("Downloading " + list.size() + " course.");
            if (list != null) {
                Date date = new Date();
                CourseDAO.getInstance().saveOrUpdateCourseList(list, false, true);
                this.a(Course.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading course failed...";
            this.a(string, exception);
        }
    }

    private void av() throws Exception {
        try {
            List<CookingInstruction> list = this.c.getCookingInstructions();
            this.a("Downloading " + list.size() + " cooking instruction.");
            if (list != null) {
                Date date = new Date();
                CookingInstructionDAO.getInstance().saveOrUpdateCookingInstructionList(list, false, true);
                this.a(CookingInstruction.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading cooking instruction failed...";
            this.a(string, exception);
        }
    }

    private void aw() throws Exception {
        try {
            List<DeletedData> list = this.c.getDeletedDataList();
            this.a("Downloading " + list.size() + " deleted data.");
            if (list != null) {
                Date date = new Date();
                DeletedDataDAO.getInstance().saveOrUpdateDeletedDataList(list, false, true);
                this.a(DeletedData.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading deleted data failed...";
            this.a(string, exception);
        }
    }

    private void ax() throws Exception {
        try {
            List<Attribute> list = this.c.getAttributes();
            this.a("Downloading " + list.size() + " attribute.");
            if (list != null) {
                Date date = new Date();
                AttributeDAO.getInstance().saveOrUpdateAttributeList(list, false, true);
                this.a(Attribute.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading attribute failed...";
            this.a(string, exception);
        }
    }

    private void ay() throws Exception {
        try {
            List<AttributeGroup> list = this.c.getAttributeGroups();
            this.a("Downloading " + list.size() + " attribute groups.");
            if (list != null) {
                Date date = new Date();
                AttributeGroupDAO.getInstance().saveOrUpdateAttributeGroupList(list, false, true);
                this.a(AttributeGroup.class, date);
            }
        }
        catch (Exception exception) {
            String string = "Downloading attribute groups failed...";
            this.a(string, exception);
        }
    }

    private void az() throws Exception {
        try {
            List<ImageResource> list = this.c.getImageResources();
            if (list != null) {
                this.a("Downloading " + list.size() + " image resource.");
                Date date = new Date();
                ImageResourceDAO.getInstance().saveOrUpdateImageResourceList(list, false, true);
                this.a(ImageResource.class, date);
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            String string = "Downloading image resource failed...";
            this.a(string, exception);
        }
    }

    private void a(String string, Exception exception) {
        ++this.d;
        a.error((Object)string, (Throwable)exception);
    }

    public static CloudDataDownloader get() {
        return new CloudDataDownloader();
    }

    private void a(String string) {
        a.info((Object)string);
    }
}

