/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.util.Arrays;

public class TicketReopenAction
extends PosAction {
    private Ticket a;

    public TicketReopenAction() {
        super(POSConstants.REOPEN_TICKET_BUTTON_TEXT);
    }

    public TicketReopenAction(Ticket ticket) {
        super(POSConstants.REOPEN_TICKET_BUTTON_TEXT);
        this.a = ticket;
    }

    public TicketReopenAction(DataChangeListener dataChangeListener) {
        super(POSConstants.REOPEN_TICKET_BUTTON_TEXT, dataChangeListener);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            if (!this.a.isClosed().booleanValue()) {
                throw new PosException(POSConstants.TICKET_IS_NOT_CLOSED);
            }
            if (this.a.isVoided().booleanValue()) {
                throw new PosException(Messages.getString("SwitchboardView.11"));
            }
            this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            this.a.setClosed(false);
            this.a.setClosingDate(null);
            this.a.setReOpened(true);
            TicketDAO.getInstance().saveOrUpdate(this.a);
            object = new OrderInfoView(Arrays.asList(this.a));
            OrderInfoDialog orderInfoDialog = new OrderInfoDialog((OrderInfoView)object);
            orderInfoDialog.setSize(PosUIManager.getSize(400), PosUIManager.getSize(600));
            orderInfoDialog.setDefaultCloseOperation(2);
            orderInfoDialog.setLocationRelativeTo(Application.getPosWindow());
            orderInfoDialog.setVisible(true);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

