/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;

public abstract class BeanTableExplorerView<E>
extends TransparentPanel
implements RefreshableView {
    protected Class<?> beanClass;
    private JXTable a;
    protected JButton editButton;
    protected JButton deleteButton;
    private BeanTableModel<E> b;
    private TransparentPanel c = new TransparentPanel();
    private TransparentPanel d = new TransparentPanel();

    public BeanTableExplorerView(Class<?> clazz) {
        this.beanClass = clazz;
        this.a();
        this.initData();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(this.beanClass);
        this.initTableModel(this.b);
        this.a = UiUtil.createJXTable(this.b, this.geTableCellRenderer());
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BeanTableExplorerView.this.c();
                }
            }
        });
        this.initTopPanel();
        this.initDefaultBottomActionButtons();
        this.add((Component)this.c, "North");
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)this.d, "South");
    }

    public abstract void initTableModel(BeanTableModel<E> var1);

    public abstract E createNew();

    public abstract E editSelectedRow(E var1);

    public abstract boolean delete(E var1);

    public abstract void initData();

    public void initTopPanel() {
        this.c.setLayout((LayoutManager)new MigLayout("ins 5 5 0 0"));
        JButton jButton = new JButton(POSConstants.REFRESH);
        jButton.addActionListener(actionEvent -> this.initData());
        this.c.add(jButton);
    }

    public void initDefaultBottomActionButtons() {
        JButton jButton = new JButton(POSConstants.ADD);
        this.editButton = new JButton(POSConstants.EDIT);
        this.deleteButton = new JButton(POSConstants.DELETE);
        jButton.addActionListener(actionEvent -> this.b());
        this.editButton.addActionListener(actionEvent -> this.c());
        this.deleteButton.addActionListener(actionEvent -> this.d());
        this.d.add(jButton);
        this.d.add(this.editButton);
        this.d.add(this.deleteButton);
    }

    private void b() {
        try {
            E e = this.createNew();
            if (e == null) {
                return;
            }
            this.b.addRow(e);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() {
        try {
            E e = this.editSelectedRow(this.b.getRow(this.getSelectedIndexToEdit()));
            if (e == null) {
                return;
            }
            this.a.repaint();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        try {
            int n = this.getSelectedIndexToDelete();
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            if (!this.delete(this.b.getRow(n))) {
                return;
            }
            this.b.removeRow(n);
            this.e();
        }
        catch (PosException posException) {
            if (StringUtils.isBlank((String)posException.getDetails())) {
                POSMessageDialog.showError(posException.getMessage());
                return;
            }
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void setRows(List<E> list) {
        this.b.setRows(list);
    }

    public List<E> getRows() {
        return this.b.getRows();
    }

    public JXTable getTable() {
        return this.a;
    }

    public DefaultTableCellRenderer geTableCellRenderer() {
        return null;
    }

    public void hideTopPanel() {
        this.c.setVisible(false);
    }

    public void setColumnWidth(Integer ... integerArray) {
        if (integerArray == null || integerArray.length == 0) {
            return;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (Integer n : integerArray) {
            linkedList.add(n);
        }
        TableColumnModel tableColumnModel = this.a.getColumnModel();
        for (int i = 0; i < this.a.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)linkedList.get(i));
        }
    }

    public E getSelectedRow() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        n = this.a.convertRowIndexToModel(n);
        return this.b.getRow(n);
    }

    public E getFirstSelectedRow() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            throw new PosException(POSConstants.PLEASE_SELECT_ROW);
        }
        n = this.a.convertRowIndexToModel(n);
        return this.b.getRow(n);
    }

    public int getSelectedIndexToEdit() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            throw new PosException(Messages.getString("SelectToEdit"));
        }
        n = this.a.convertRowIndexToModel(n);
        return n;
    }

    public int getSelectedIndexToDelete() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            throw new PosException(Messages.getString("SelectToDelete"));
        }
        n = this.a.convertRowIndexToModel(n);
        return n;
    }

    public TransparentPanel getTopPanel() {
        return this.c;
    }

    public TransparentPanel getBottomActionPanel() {
        return this.d;
    }

    private void e() {
        if (this.beanClass == null) {
            return;
        }
        if (DataProvider.get().isCaching(this.beanClass)) {
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "4");
        }
    }

    public E openEditForm(BeanEditor<E> beanEditor) {
        return this.openEditForm(beanEditor, 0, 0);
    }

    public E openEditForm(BeanEditor<E> beanEditor, int n, int n2) {
        if (beanEditor.getBean() != null) {
            this.b.setRow(this.getSelectedIndexToEdit(), beanEditor.getBean());
        }
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), beanEditor);
        if (n > 0 && n2 > 0) {
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(n, n2));
        }
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return null;
        }
        return beanEditor.getBean();
    }

    public E openNewForm(BeanEditor<E> beanEditor) {
        return this.openNewForm(beanEditor, 0, 0);
    }

    public E openNewForm(BeanEditor<E> beanEditor, int n, int n2) {
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), beanEditor);
        if (n > 0 && n2 > 0) {
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(n, n2));
        }
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return null;
        }
        return beanEditor.getBean();
    }

    @Override
    public void refresh() {
        this.initData();
    }

    public void checkDataValidation(Boolean bl, String string) {
        if (bl.booleanValue()) {
            this.refresh();
            throw new PosException(Messages.getString("BeanTableExplorerView.3") + " " + string + Messages.getString("BeanTableExplorerView.4"));
        }
    }
}

