/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.PrintServiceComboRenderer;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.SerialPortUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;

public class PeripheralConfigurationView
extends ConfigurationView
implements ItemListener {
    public static final String CONFIG_TAB_PERIPHERAL = Messages.getString("PeripheralConfigurationView.0");
    private JCheckBox a;
    private JPanel b;
    private JPanel c;
    private JRadioButton d;
    private JRadioButton e;
    private JTextField f = new JTextField(10);
    private JTextField g = new JTextField(15);
    private JLabel h;
    private JComboBox i;
    private JLabel j;
    private JComboBox k;
    private List<PrinterModel> l;
    private JTextField m = new JTextField(15);
    private DoubleTextField n = new DoubleTextField(6);
    private JCheckBox o;
    private JTextField p;
    private JTextField q;
    private JCheckBox r;
    private JTextField s;
    private FixedLengthTextField t;
    private List<ConfigurationSubEditor> u = new ArrayList<ConfigurationSubEditor>();

    public PeripheralConfigurationView() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][]"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", ""));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.4")));
        this.a = new JCheckBox(Messages.getString("TerminalConfigurationView.15"));
        jPanel2.add((Component)this.a, "span 5, wrap");
        JLabel jLabel = new JLabel(Messages.getString("PeripheralConfigurationView.2"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.e = new JRadioButton(KickDrawerType.Printer.getDisplayString());
        this.d = new JRadioButton(KickDrawerType.Drawer_Trigger.getDisplayString());
        this.e.addItemListener(this);
        this.d.addItemListener(this);
        buttonGroup.add(this.e);
        buttonGroup.add(this.d);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("", "0[]8[]", ""));
        jPanel3.add(jLabel);
        jPanel3.add(this.e);
        jPanel3.add(this.d);
        jPanel2.add((Component)jPanel3, "span 5, wrap");
        this.b = new JPanel((LayoutManager)new MigLayout("", "0[][][]", ""));
        this.b.add(new JLabel(Messages.getString("TerminalConfigurationView.25")));
        this.b.add((Component)this.f, "");
        this.b.add((Component)new JLabel(Messages.getString("TerminalConfigurationView.27")), "newline");
        this.b.add((Component)this.g, "");
        JButton jButton = new JButton(Messages.getString("TerminalConfigurationView.11"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PeripheralConfigurationView.this.g.getText();
                if (StringUtils.isEmpty((String)string)) {
                    string = TerminalConfig.getDefaultDrawerControlCodes();
                }
                String[] stringArray = string.split(",");
                char[] cArray = new char[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        cArray[i] = (char)Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        cArray[i] = 48;
                    }
                }
                DrawerUtil.kickDrawerUsingSerialPort(PeripheralConfigurationView.this.f.getText(), cArray);
            }
        });
        this.b.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("TerminalConfigurationView.32"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeripheralConfigurationView.this.f.setText("COM1");
                PeripheralConfigurationView.this.g.setText(TerminalConfig.getDefaultDrawerControlCodes());
            }
        });
        this.b.add(jButton2);
        jPanel2.add(this.b);
        this.c = new JPanel((LayoutManager)new MigLayout("", "0[][][]", ""));
        this.h = new JLabel(Messages.getString("AddPrinterDialog.9"));
        this.i = new JComboBox();
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        this.i.addItem(null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i]);
        }
        this.i.setModel(new ComboBoxModel(arrayList));
        this.i.setRenderer(new PrintServiceComboRenderer());
        this.c.add((Component)this.h, "alignx trailing");
        this.c.add((Component)this.i, "growx,split 2");
        this.j = new JLabel(Messages.getString("PeripheralConfigurationView.1"));
        this.k = new JComboBox();
        this.c();
        this.k.setModel(new ComboBoxModel(this.l));
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                PrinterModel printerModel = (PrinterModel)jComboBox.getSelectedItem();
                PeripheralConfigurationView.this.m.setText(printerModel.drawerCode);
            }
        });
        this.c.add((Component)this.j, "newline,alignx trailing");
        this.c.add((Component)this.k, "growx,split 2");
        this.c.add(new JLabel(Messages.getString("TerminalConfigurationView.27")));
        this.c.add((Component)this.m, "");
        JButton jButton3 = new JButton(Messages.getString("TerminalConfigurationView.11"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintService printService = (PrintService)PeripheralConfigurationView.this.i.getSelectedItem();
                try {
                    DrawerUtil.kickDrawerUsingDevicePrinter(printService.getName(), PeripheralConfigurationView.this.m.getText());
                }
                catch (Exception exception) {
                    PosLog.error(PeripheralConfigurationView.class, exception);
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE);
                }
            }
        });
        this.c.add(jButton3);
        jPanel2.add(this.c);
        jPanel.add((Component)jPanel2, "span 3, grow, wrap");
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.5")));
        this.o = new JCheckBox(Messages.getString("PeripheralConfigurationView.6"));
        this.p = new JTextField(20);
        this.q = new FixedLengthTextField(20);
        JButton jButton4 = new JButton(Messages.getString("PeripheralConfigurationView.7"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerUtil.setCustomerDisplayMessage(PeripheralConfigurationView.this.p.getText(), String.format("%200s", ""));
                DrawerUtil.setCustomerDisplayMessage(PeripheralConfigurationView.this.p.getText(), PeripheralConfigurationView.this.q.getText());
            }
        });
        JButton jButton5 = new JButton(Messages.getString("TerminalConfigurationView.32"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeripheralConfigurationView.this.p.setText(Messages.getString("PeripheralConfigurationView.8"));
                PeripheralConfigurationView.this.q.setText(Messages.getString("PeripheralConfigurationView.9"));
            }
        });
        jPanel4.add((Component)this.o, "wrap");
        jPanel4.add(new JLabel(Messages.getString("PeripheralConfigurationView.11")));
        jPanel4.add((Component)this.p, "wrap");
        jPanel4.add(new JLabel(Messages.getString("PeripheralConfigurationView.13")));
        jPanel4.add(this.q);
        jPanel4.add(jButton4);
        jPanel4.add(jButton5);
        jPanel.add((Component)jPanel4, "grow,wrap");
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.15")));
        this.r = new JCheckBox(Messages.getString("PeripheralConfigurationView.16"));
        this.s = new JTextField(20);
        this.t = new FixedLengthTextField(20);
        JButton jButton6 = new JButton(Messages.getString("PeripheralConfigurationView.17"));
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeripheralConfigurationView.this.b();
            }
        });
        JButton jButton7 = new JButton(Messages.getString("TerminalConfigurationView.32"));
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeripheralConfigurationView.this.s.setText(Messages.getString("PeripheralConfigurationView.18"));
            }
        });
        jPanel5.add((Component)this.r, "wrap");
        jPanel5.add(new JLabel(Messages.getString("PeripheralConfigurationView.20")));
        jPanel5.add(this.s);
        jPanel5.add(jButton6);
        jPanel5.add(jButton7);
        if (TerminalConfig.getScaleActivationValue().equals("cas10")) {
            jPanel.add((Component)jPanel5, "grow,wrap");
        }
        for (FloreantPlugin floreantPlugin : ExtensionManager.getPlugins()) {
            List<ConfigurationSubEditor> list = floreantPlugin.getSubEditors();
            if (list == null) continue;
            this.u.addAll(list);
            for (ConfigurationSubEditor configurationSubEditor : list) {
                jPanel.add((Component)configurationSubEditor, "grow,wrap");
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    protected void doEnableDisableDrawerPull() {
        boolean bl = this.a.isSelected();
        this.f.setEnabled(bl);
        this.m.setEnabled(bl);
        this.n.setEnabled(bl);
    }

    @Override
    public boolean save() throws Exception {
        Iterator<ConfigurationSubEditor> iterator;
        TerminalConfig.setCustomerDisplay(this.o.isSelected());
        TerminalConfig.setCustomerDisplayPort(this.p.getText());
        TerminalConfig.setCustomerDisplayMessage(this.q.getText());
        TerminalConfig.setScaleDisplay(this.r.isSelected());
        TerminalConfig.setScalePort(this.s.getText());
        TerminalConfig.setScaleDisplayMessage(this.t.getText());
        TerminalDAO terminalDAO = TerminalDAO.getInstance();
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        String string = null;
        if (this.e.isSelected()) {
            string = KickDrawerType.Printer.name();
            iterator = (PrintService)this.i.getSelectedItem();
            terminal.addProperty("cashdrawer.deviceName", iterator.getName());
            PrinterModel object = (PrinterModel)this.k.getSelectedItem();
            terminal.addProperty("cashdrawer.deviceModel", object.model);
            terminal.addProperty("cashdrawer.controlCode", this.m.getText());
        } else if (this.d.isSelected()) {
            string = KickDrawerType.Drawer_Trigger.name();
            TerminalConfig.setDrawerPortName(this.f.getText());
            iterator = this.g.getText();
            if (StringUtils.isNotEmpty((String)((Object)iterator))) {
                iterator = ((String)((Object)iterator)).replaceAll(",", "_");
            }
            TerminalConfig.setDrawerControlCodes((String)((Object)iterator));
        }
        terminal.addProperty("cashdrawer.kickType", string);
        terminal.setHasCashDrawer(this.a.isSelected());
        terminalDAO.saveOrUpdate(terminal);
        if (this.u != null) {
            for (ConfigurationSubEditor configurationSubEditor : this.u) {
                configurationSubEditor.save();
            }
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        Object object2;
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        this.a.setSelected(terminal.isHasCashDrawer());
        this.f.setText(TerminalConfig.getDrawerPortName());
        String string = TerminalConfig.getDrawerControlCodes();
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("_", ",");
        }
        this.g.setText(string);
        String string2 = terminal.getProperty("cashdrawer.deviceName");
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.i.getModel();
        List list = comboBoxModel.getDataList();
        for (Object object2 : list) {
            if (!object2.getName().equals(string2)) continue;
            this.i.setSelectedItem(object2);
            break;
        }
        String string3 = terminal.getProperty("cashdrawer.deviceModel");
        object2 = (ComboBoxModel)this.k.getModel();
        List list2 = ((ComboBoxModel)object2).getDataList();
        for (Object object3 : list2) {
            if (!((PrinterModel)object3).model.equals(string3)) continue;
            this.k.setSelectedItem(object3);
            break;
        }
        this.m.setText(terminal.getProperty("cashdrawer.controlCode"));
        String string4 = terminal.getProperty("cashdrawer.kickType");
        if (StringUtils.isNotBlank((String)string4)) {
            if (string4.equals(KickDrawerType.Drawer_Trigger.name())) {
                this.d.setSelected(true);
            } else if (string4.equals(KickDrawerType.Printer.name())) {
                this.e.setSelected(true);
            }
        } else {
            this.e.setSelected(true);
        }
        this.o.setSelected(TerminalConfig.isActiveCustomerDisplay());
        this.p.setText(TerminalConfig.getCustomerDisplayPort());
        this.q.setText(TerminalConfig.getCustomerDisplayMessage());
        this.r.setSelected(TerminalConfig.isActiveScaleDisplay());
        this.s.setText(TerminalConfig.getScalePort());
        this.t.setText(TerminalConfig.getScaleDisplayMessage());
        if (this.u != null) {
            for (ConfigurationSubEditor configurationSubEditor : this.u) {
                configurationSubEditor.initialize();
            }
        }
        this.setInitialized(true);
    }

    private void b() {
        try {
            String string = SerialPortUtil.readWeight(this.s.getText());
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            LogFactory.getLog(PeripheralConfigurationView.class).error((Object)exception);
        }
    }

    @Override
    public String getName() {
        return CONFIG_TAB_PERIPHERAL;
    }

    private void c() {
        String string = "util/drawer-codes.txt";
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            PosLog.error(this.getClass(), "Unable to find drawer codes file " + string);
            return;
        }
        this.l = new ArrayList<PrinterModel>();
        PrinterModel printerModel = new PrinterModel();
        printerModel.model = "";
        printerModel.drawerCode = "";
        this.l.add(printerModel);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(uRL.getFile()));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("=");
                PrinterModel printerModel2 = new PrinterModel();
                printerModel2.model = stringArray[0];
                printerModel2.drawerCode = stringArray[1];
                this.l.add(printerModel2);
            }
        }
        catch (IOException iOException) {
            PosLog.error(this.getClass(), "Error reading file " + string);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.d) {
            if (this.d.isSelected()) {
                this.b.setVisible(true);
                this.c.setVisible(false);
            }
        } else if (itemEvent.getSource() == this.e && this.e.isSelected()) {
            this.c.setVisible(true);
            this.b.setVisible(false);
        }
    }

    public static enum KickDrawerType {
        Printer("Printer"),
        Drawer_Trigger("Drawer trigger");

        private String a;

        private KickDrawerType(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }

        public String getDisplayString() {
            return this.a;
        }
    }

    private class PrinterModel {
        public String model;
        public String drawerCode;

        private PrinterModel() {
        }

        public String toString() {
            return this.model;
        }
    }
}

