/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.EmailReportJob;
import com.floreantpos.model.CronJob;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

@PluginImplementation
public class EmailReportJobPlugin
extends CronJobPlugin {
    private JTextField a;
    private JLabel b;
    private HashMap<String, ReportRow> c = new HashMap();
    private JPanel d;

    @Override
    public String getProductName() {
        return Messages.getString("EmailReportJobPlugin.0");
    }

    @Override
    public String getId() {
        return "email-report";
    }

    @Override
    public void initializeConfigurationPaneByProperties() {
        try {
            if (this.getCronJob() != null && StringUtils.isNotEmpty((String)this.getCronJob().getProperties())) {
                Map map = (Map)new ObjectMapper().readValue(this.getCronJob().getProperties(), (TypeReference)new TypeReference<Map<String, String>>(){});
                this.a.setText((String)map.get("EMAIL"));
                this.a((String)map.get("EMAIL_REPORTS_LIST"));
            }
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private void a(String string) {
        List<String> list = string == null ? null : Arrays.asList(string.split(","));
        for (String string2 : this.c.keySet()) {
            ReportRow reportRow = this.c.get(string2);
            reportRow.a.setSelected(string != null && list.contains(string2));
        }
    }

    @Override
    public void updatePropertiesFromConfigurationPane() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<ReportRow> arrayList = new ArrayList<ReportRow>();
            for (ReportRow reportRow : this.c.values()) {
                if (!reportRow.a.isSelected()) continue;
                arrayList.add(reportRow);
            }
            Iterator<ReportRow> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ReportRow reportRow;
                reportRow = iterator.next();
                stringBuilder.append(reportRow.a.getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            hashMap.put("EMAIL", this.a.getText());
            hashMap.put("EMAIL_REPORTS_LIST", stringBuilder.toString());
            this.getCronJob().setProperties(new ObjectMapper().writeValueAsString(hashMap));
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    @Override
    public JPanel getConfigurationPane() throws Exception {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "[][grow]", ""));
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.b = new JLabel(Messages.getString("EmailSalesReportJobPlugin.8"));
        this.a = new JTextField(28);
        jPanel.add(this.b);
        jPanel.add((Component)this.a, "growx,wrap");
        this.d = new JPanel((LayoutManager)new MigLayout("", "[][grow]", ""));
        for (ReportName reportName : ReportName.values()) {
            ReportRow reportRow = new ReportRow(String.valueOf(reportName.getId()), reportName.getName(), false);
            this.d.add((Component)reportRow.a, "wrap");
        }
        JScrollPane jScrollPane = new JScrollPane(this.d);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Report"));
        jPanel.add((Component)jScrollPane, "skip 1,grow");
        return jPanel;
    }

    public String toString() {
        return this.getProductName();
    }

    @Override
    public CronJob convertToActualCronJob() {
        EmailReportJob emailReportJob = new EmailReportJob();
        emailReportJob.setExecutionTime(this.getCronJob().getExecutionTime());
        emailReportJob.setFrequency(this.getCronJob().getFrequency());
        emailReportJob.setId(this.getCronJob().getId());
        emailReportJob.setJobId(this.getCronJob().getJobId());
        emailReportJob.setJobName(this.getCronJob().getJobName());
        emailReportJob.setLastSyncTime(this.getCronJob().getLastSyncTime());
        emailReportJob.setLastUpdateTime(this.getCronJob().getLastUpdateTime());
        emailReportJob.setProperties(this.getCronJob().getProperties());
        emailReportJob.setVersion(this.getCronJob().getVersion());
        emailReportJob.setActive(this.getCronJob().isActive());
        return emailReportJob;
    }

    @Override
    public void validateRequireFields() throws PosException {
        if (StringUtils.isBlank((String)this.a.getText())) {
            throw new PosException(Messages.getString("EmailSalesBalanceReportJobPlugin.1"));
        }
        if (!EmailValidator.getInstance().isValid(this.a.getText())) {
            throw new PosException(Messages.getString("EmailSalesBalanceReportJobPlugin.2"));
        }
        if (this.c != null) {
            ArrayList<ReportRow> arrayList = new ArrayList<ReportRow>();
            for (ReportRow reportRow : this.c.values()) {
                if (!reportRow.a.isSelected()) continue;
                arrayList.add(reportRow);
            }
            if (arrayList.size() == 0) {
                throw new PosException(Messages.getString("EmailReportJobPlugin.1"));
            }
        }
    }

    static enum ReportName {
        Email_payout_report(1, Messages.getString("EmailReportJobPlugin.2")),
        Email_sales_balance_report(2, Messages.getString("EmailReportJobPlugin.3")),
        Email_sales_report(3, Messages.getString("EmailReportJobPlugin.4"));

        private int a;
        private String b;

        private ReportName(int n2, String string2) {
            this.setId(n2);
            this.setName(string2);
        }

        public static ReportName getReportName(int n) {
            for (ReportName reportName : ReportName.values()) {
                if (reportName.getId() != n) continue;
                return reportName;
            }
            return null;
        }

        public static String getReportNameById(int n) {
            return ReportName.getReportName(n) == null ? "" : ReportName.getReportName(n).getName();
        }

        public int getId() {
            return this.a;
        }

        public void setId(int n) {
            this.a = n;
        }

        public String getName() {
            return this.b;
        }

        public void setName(String string) {
            this.b = string;
        }
    }

    class ReportRow
    implements ItemListener {
        JCheckBox a;

        public ReportRow(String string, String string2, boolean bl) {
            this.a = new JCheckBox(string2, bl);
            this.a.setName(string);
            EmailReportJobPlugin.this.c.put(string, this);
            this.a.addItemListener(this);
        }

        public boolean isSelected() {
            return this.a.isSelected();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
            EmailReportJobPlugin.this.c.put(jCheckBox.getName(), this);
        }
    }
}

