/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GlobalIdGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"image", "properties", "modifierGroups"})
@XmlRootElement
public class MenuModifier
extends BaseMenuModifier
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient MenuItemModifierSpec menuItemModifierGroup;
    private String pageItemId;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public MenuModifier() {
    }

    public MenuModifier(String string) {
        super(string);
    }

    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String string = null;
        if (taxGroup != null) {
            string = taxGroup.getId();
        }
        super.setTaxGroupId(string);
    }

    public MenuItemModifierSpec getMenuItemModifierGroup() {
        return this.menuItemModifierGroup;
    }

    public void setMenuItemModifierGroup(MenuItemModifierSpec menuItemModifierSpec) {
        this.menuItemModifierGroup = menuItemModifierSpec;
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @Override
    public Integer getButtonColor() {
        Integer n = super.getButtonColor();
        if (n == null || n == 0 || n == -1316371) {
            n = Color.WHITE.getRGB();
        }
        return n;
    }

    @Override
    public Integer getTextColor() {
        Integer n = super.getTextColor();
        return n == 0 ? null : n;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menu_modifier_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getPriceForSize(MenuItemSize menuItemSize, boolean bl) {
        double d = this.getPrice();
        if (menuItemSize == null) {
            return d;
        }
        List<PizzaModifierPrice> list = this.getPizzaModifierPriceList();
        if (list == null) {
            return d;
        }
        for (PizzaModifierPrice pizzaModifierPrice : list) {
            if (!menuItemSize.equals(pizzaModifierPrice.getSize())) continue;
            if (bl) {
                return pizzaModifierPrice.getExtraPrice();
            }
            return pizzaModifierPrice.getPrice();
        }
        return d;
    }

    public double getPriceForMultiplier(Multiplier multiplier) {
        double d = this.getPrice();
        if (multiplier == null || multiplier.isMain().booleanValue()) {
            return d;
        }
        List<ModifierMultiplierPrice> list = this.getMultiplierPriceList();
        if (list == null || list.isEmpty()) {
            return d * multiplier.getRate() / 100.0;
        }
        for (ModifierMultiplierPrice modifierMultiplierPrice : list) {
            if (modifierMultiplierPrice.getMultiplier() == null || !multiplier.getId().equals(modifierMultiplierPrice.getMultiplier().getId())) continue;
            return modifierMultiplierPrice.getPrice();
        }
        return d * multiplier.getRate() / 100.0;
    }

    public double getPriceForSizeAndMultiplier(MenuItemSize menuItemSize, boolean bl, Multiplier multiplier) {
        List<PizzaModifierPrice> list = this.getPizzaModifierPriceList();
        double d = 0.0;
        if (this.isPizzaModifier().booleanValue() && list != null) {
            for (PizzaModifierPrice pizzaModifierPrice : list) {
                List<ModifierMultiplierPrice> list2;
                if (menuItemSize == null || !menuItemSize.equals(pizzaModifierPrice.getSize()) || (list2 = pizzaModifierPrice.getMultiplierPriceList()) == null) continue;
                Double d2 = null;
                for (ModifierMultiplierPrice modifierMultiplierPrice : list2) {
                    String string = modifierMultiplierPrice.getMultiplier().getId();
                    if (string.equals("Regular")) {
                        d = modifierMultiplierPrice.getPrice();
                        if (!multiplier.getId().equals("Regular")) continue;
                        return d;
                    }
                    if (!string.equals(multiplier.getId())) continue;
                    d2 = modifierMultiplierPrice.getPrice();
                }
                if (d2 == null) continue;
                return d2;
            }
        }
        return d * multiplier.getRate() / 100.0;
    }

    public List<TicketItemTax> getTaxByOrderType(OrderType orderType) {
        return this.getTaxByOrderType(orderType, null);
    }

    public List<TicketItemTax> getTaxByOrderType(OrderType orderType, TicketItem ticketItem) {
        if (!this.isTaxable().booleanValue()) {
            return null;
        }
        Boolean bl = this.getBooleanProperty("tax.same.as.item", false);
        if (bl.booleanValue() && ticketItem != null) {
            return ticketItem.getTaxes();
        }
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup == null) {
            return null;
        }
        ArrayList<TicketItemTax> arrayList = new ArrayList<TicketItemTax>();
        List<Tax> list = taxGroup.getTaxes();
        if (list != null) {
            for (Tax tax : list) {
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(GlobalIdGenerator.generateGlobalId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setRate(tax.getRate());
                arrayList.add(ticketItemTax);
            }
        }
        return arrayList;
    }

    @XmlTransient
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonImage();
        }
        return null;
    }

    public void setPageItemId(String string) {
        this.pageItemId = string;
    }

    public String getPageItemId() {
        return this.pageItemId;
    }

    @XmlTransient
    public double getTotalTaxRate() {
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup != null) {
            return taxGroup.getTotalTaxRate();
        }
        return 0.0;
    }

    public void setTotalTaxRate(double d) {
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        try {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @XmlTransient
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }
}

