/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.WorkingHours;
import com.floreantpos.model.base.BaseStore;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.siiopa.common.model.SubscriptionStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"storeLogo", "loginScreenBackground", "loginScreenBgImageResource", "databaseVersion", "softwareVersion", "softwareNumericVersion", "tableSeatForeColor", "tableServingForeColor", "tableServingBGColor", "tableBookForeColor", "tableBookBGColor", "tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatBGColor", "workingHours"})
@XmlRootElement(name="restaurant")
public class Store
extends BaseStore
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String STORE_PROP_DEFAULT_RESERVATION_OWNER = "Reservation.owner";
    public static final String STORE_PROP_DEFAULT_RESERVATION_ORDERTYPE = "Reservation.ordertype";
    public static final String STORE_PROP_RESERVATION_MERGE_IF_SAME_USER = "Reservation.Merge_If_Same_Member";
    public static final String STORE_PROP_RESERVATION_LOGGED_IN_USER = "Reservation.Logged_In_User_As_Owner";
    public static final String STORE_PROP_RESERVATION_DEFAULT_SALES_AREA = "Reservation.Default_Sales_Area";
    public static final String STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED = "Charges.Automatically_Sync_Day";
    public static final String STORE_PROP_SUBSCRIPTION_SUFFIX = ".subscribed";
    public static final String STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX = ".status";
    public static final String STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX = ".subscription.start_date";
    public static final String STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX = ".subscription.end_date";
    public static final String STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX = ".plan_id";
    public static final String STORE_PROP_EXTRA_MULTIPLIER = "multiplier.extra";
    public static final String STORE_PROP_HALF_MULTIPLIER = "multiplier.half";
    public static final String STORE_PROP_QUARTER_MULTIPLIER = "multiplier.quarter";
    public static final String STORE_PROP_SUPPRESS_ZERO_COST_MODIFIER = "suppress.zerocost.modifiers";
    public static final String STORE_PROP_FLORIDA_TAX_RULE = "tax.apply_florida_rule";
    public static final String RESET_TOKEN = "reset.token";
    public static final String TOKEN_NO_START_FROM = "token_no.start";
    public static final String ONLINE_PICKUP_ORDER_TYPE = "online.ordertype.pickup";
    public static final String ONLINE_DELIVERY_ORDER_TYPE = "online.ordertype.delivery";
    public static final String ONLINE_ORDER_PAYMENT_CASH_ON_DELIVERY = "online_order.payment.cash_on_delivery";
    public static final String ONLINE_ORDER_PAYMENT_CARD = "online_order.payment.card";
    public static final String ONLINE_ORDER_PAYMENT_CARD_GATEWAY = "online_order.payment.card.gateway";
    public static final String ONLINE_ORDER_AUTHNET_MERCHANTE_ID = "online_order.auth_net.merchantId";
    public static final String ONLINE_ORDER_AUTHNET_API_LOGIN_ID = "online_order.auth_net.apiLoginId";
    public static final String ONLINE_ORDER_AUTHNET_SANDBOX_MODE = "online_order.auth_net.sandbox_mode";
    public static final String SYNC_CONFLICT_RESOLVE_OPTION = "sync.conflict_resolve_option";
    @XmlTransient
    private ImageIcon storeLogo;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private List<WorkingHours> workingHours;

    public Store() {
    }

    public Store(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public String getProperty(String string) {
        Map<String, String> map = this.getProperties();
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperties().get(string);
        if (StringUtils.isEmpty((String)string3)) {
            string3 = string2;
        }
        return string3;
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperties().get(string);
        if (StringUtils.isBlank((String)string2)) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public void addProperty(String string, String string2) {
        this.getProperties().put(string, string2);
    }

    @Override
    public String getCurrencyName() {
        String string = super.getCurrencyName();
        if (StringUtils.isEmpty((String)string)) {
            return "Sample Currency";
        }
        return string;
    }

    @Override
    public String getCurrencySymbol() {
        String string = super.getCurrencySymbol();
        if (StringUtils.isEmpty((String)string)) {
            string = "$";
        }
        return string;
    }

    public boolean isAllwMemberbasedPOI() {
        String string = this.getProperty("inventory.allowMemberPOI");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateOnHandBlncForSale() {
        String string = this.getProperty("inventory.updateOnHandBlnceForSale");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateAvlBlncForSale() {
        String string = this.getProperty("inventory.updateAvlBlnceForSale");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public boolean isAllwNegOnHandBlnce() {
        String string = this.getProperty("inventory.allowNegetiveOnHandBalance");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateAvlBlncForPOCreated() {
        String string = this.getProperty("inventory.updateAvailBalanceForPurchaseOrderCreated");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isUpdateOnHandBlncForPORec() {
        String string = this.getProperty("inventory.updateOnHandBalanceForPurchaseOrderReceived");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public String getImageId() {
        String string;
        String string2 = this.getProperty("logo.imageid");
        if (StringUtils.isEmpty((String)string2) && (string = this.getProperty("ticket.header.logo.imageid")) != null) {
            this.addProperty("logo.imageid", string);
            return string;
        }
        return string2;
    }

    @XmlTransient
    public ImageIcon getStoreLogo() {
        if (this.storeLogo == null) {
            String string = this.getImageId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            ImageResource imageResource = DataProvider.get().getImageResource(string);
            if (imageResource != null) {
                this.storeLogo = imageResource.getButtonBigImage();
            }
        }
        return this.storeLogo;
    }

    public boolean isInventoryAvgPricingMethod() {
        String string = this.getProperty("inventory.pricing.method");
        if (string == null) {
            return false;
        }
        return string.equals("avg");
    }

    public void setStoreLogo(ImageIcon imageIcon) {
        this.storeLogo = imageIcon;
    }

    @XmlTransient
    public ImageIcon getLoginScreenBackground() {
        String string = this.getProperty("loginscreen.background");
        if (string == null) {
            return null;
        }
        ImageResource imageResource = IconFactory.getImageResource(string);
        if (imageResource != null && imageResource.getImageBytes() != null) {
            return new ImageIcon(imageResource.getImageBytes());
        }
        return null;
    }

    @XmlTransient
    public ImageResource getLoginScreenBgImageResource() {
        String string = this.getProperty("loginscreen.background");
        if (string == null) {
            return null;
        }
        return IconFactory.getImageResource(string);
    }

    public void setLoginScreenBackgroundId(String string) {
        this.addProperty("loginscreen.background", string);
    }

    public static String getWebServiceUrl() {
        Store store = DataProvider.get().getStore();
        return store.getProperty("web.service.url") + "/service/data/store/" + store.getProperty("web.service.schema");
    }

    public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
        try {
            String string = this.getProperty("tips.receiver.delivery");
            if (StringUtils.isNotEmpty((String)string)) {
                return TipsReceivedBy.valueOf(string);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("Store.8"));
        }
    }

    public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
        try {
            String string = this.getProperty("tips.receiver.nonDelivery");
            if (StringUtils.isNotEmpty((String)string)) {
                return TipsReceivedBy.valueOf(string);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("Store.9"));
        }
    }

    public double getOvertimeMarkup() {
        try {
            String string = this.getProperty("overtime.markup");
            if (StringUtils.isNotEmpty((String)string)) {
                return NumberUtil.parseDouble(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public boolean hasCreateMemberPermission() {
        try {
            String string = this.getProperty("member.create.permission");
            if (StringUtils.isNotEmpty((String)string)) {
                return Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Integer getDatabaseVersion() {
        String string = this.getProperty("database.version");
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDatabaseVersion(int n) {
        this.addProperty("database.version", String.valueOf(n));
    }

    @XmlTransient
    @JsonIgnoreProperties
    public String getSoftwareVersion() {
        return this.getProperty("software.version");
    }

    public void setSoftwareVersion(String string) {
        this.addProperty("software.version", string);
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Integer getSoftwareNumericVersion() {
        String string = this.getProperty("software.numeric.version");
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setSoftwareNumericVersion(int n) {
        this.addProperty("software.numeric.version", String.valueOf(n));
    }

    public boolean isAutoSyncCharges() {
        return this.getBooleanProperty(STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED, Boolean.FALSE);
    }

    public boolean isAllowPenyRounding() {
        try {
            String string = this.getProperty("store.peny.rounding");
            if (StringUtils.isNotEmpty((String)string)) {
                return Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isAllowMulDiscount() {
        try {
            String string = this.getProperty("store.allow.multiple.discount");
            if (StringUtils.isNotEmpty((String)string)) {
                return Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isShowVoidedItemsOnTicket() {
        String string = this.getProperty("ticket.show_voided_item");
        if (StringUtils.isNotEmpty((String)string)) {
            return Boolean.valueOf(string);
        }
        return true;
    }

    public void setShowVoidedItemsOnTicket(boolean bl) {
        this.addProperty("ticket.show_voided_item", String.valueOf(bl));
    }

    public int getCustomerMonitorDisplayOption() {
        try {
            String string = this.getProperty("customer.monitor.display.option");
            if (StringUtils.isNotEmpty((String)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getCustomerMonitorDisplaySlideDuration() {
        try {
            String string = this.getProperty("customer.monitor.slide.duration");
            if (StringUtils.isNotEmpty((String)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    public String getServerUrl() {
        try {
            String string = this.getProperty("update_server_url");
            if (StringUtils.isNotEmpty((String)string)) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void setTablePrimaryFontSize(int n) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(n));
    }

    public int getTablePrimaryFontSize() {
        return this.getProperty("floorplan.primaryFontSize") == null ? 14 : Integer.valueOf(this.getProperty("floorplan.primaryFontSize"));
    }

    public void setTableSecondaryFontSize(int n) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(n));
    }

    public int getTableSecondaryFontSize() {
        return this.getProperty("floorplan.secondaryFontSize") == null ? 9 : Integer.valueOf(this.getProperty("floorplan.secondaryFontSize"));
    }

    public void setTableBtnWidth(int n) {
        this.addProperty("floorplan.btnWidth", String.valueOf(n));
    }

    public int getTableBtnWidth() {
        return this.getProperty("floorplan.btnWidth") == null ? 100 : Integer.valueOf(this.getProperty("floorplan.btnWidth"));
    }

    public void setTableBtnHeight(int n) {
        this.addProperty("floorplan.btnHeight", String.valueOf(n));
    }

    public int getTableBtnHeight() {
        return this.getProperty("floorplan.btnHeight") == null ? 80 : Integer.valueOf(this.getProperty("floorplan.btnHeight"));
    }

    public void setTableSeatForeColor(Color color) {
        this.addProperty("floorplan.seatForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatForeColor() {
        return Color.BLACK;
    }

    public void setTableSeatBGColor(Color color) {
        this.addProperty("floorplan.seatBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatBGColor() {
        return new Color(249, 105, 14);
    }

    public void setTableServingForeColor(Color color) {
        this.addProperty("floorplan.servingForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingForeColor() {
        return Color.WHITE;
    }

    public void setTableServingBGColor(Color color) {
        this.addProperty("floorplan.servingBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingBGColor() {
        return new Color(240, 52, 52);
    }

    public void setTableBookForeColor(Color color) {
        this.addProperty("floorplan.bookForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookForeColor() {
        return Color.BLACK;
    }

    public void setTableBookBGColor(Color color) {
        this.addProperty("floorplan.bookBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookBGColor() {
        return Color.YELLOW;
    }

    public void setTableFreeForeColor(Color color) {
        this.addProperty("floorplan.freeForeColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeForeColor() {
        return Color.black;
    }

    public void setTableFreeBGColor(Color color) {
        this.addProperty("floorplan.freeBGColor", color != null ? String.valueOf(color.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeBGColor() {
        return Color.white;
    }

    public boolean isShowTableNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableName", "false"));
    }

    public boolean isShowTableNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableNumber", "true"));
    }

    public boolean isShowServerNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showServerName", "true"));
    }

    public boolean isShowTokenNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTokenName", "true"));
    }

    public void setShowTableNameOnTable(boolean bl) {
        this.addProperty("floorplan.showTableName", String.valueOf(bl));
    }

    public void setShowTableNumberOnTable(boolean bl) {
        this.addProperty("floorplan.showTableNumber", String.valueOf(bl));
    }

    public void setShowServerNameOnTable(boolean bl) {
        this.addProperty("floorplan.showServerName", String.valueOf(bl));
    }

    public void setShowTokenNumberOnTable(boolean bl) {
        this.addProperty("floorplan.showTokenName", String.valueOf(bl));
    }

    public boolean isShowCustomerNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showCustomerName", "false"));
    }

    public void setShowCustomerNameOnTable(boolean bl) {
        this.addProperty("floorplan.showCustomerName", String.valueOf(bl));
    }

    public boolean isShowResIdOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showResId", "false"));
    }

    public void setShowResIdOnTable(boolean bl) {
        this.addProperty("floorplan.showResId", String.valueOf(bl));
    }

    public boolean isShowTableStatusOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableStatus", "false"));
    }

    public void setShowTableStatusOnTable(boolean bl) {
        this.addProperty("floorplan.showTableStatus", String.valueOf(bl));
    }

    public boolean isKDSenabled() {
        return Boolean.valueOf(this.getProperty("kdsenabled", "false"));
    }

    public void setKDSenabled(boolean bl) {
        this.addProperty("kdsenabled", Boolean.toString(bl));
    }

    @Deprecated
    public boolean isShowTransparentBtnOnTable() {
        return false;
    }

    @Deprecated
    public void setShowTransparentBtnOnTable(boolean bl) {
    }

    public String getSendGridSenderEmail() {
        return this.getProperty("store.sendgrid.sender.email", null);
    }

    public void setSendGridSenderEmail(String string) {
        this.addProperty("store.sendgrid.sender.email", string);
    }

    public String getSendGridApiKey() {
        return this.getProperty("store.sendgrid.api.key", null);
    }

    public void setSendGridApiKey(String string) {
        this.addProperty("store.sendgrid.api.key", string);
    }

    public String getAdminEmail() {
        return this.getProperty("store.admin.email", null);
    }

    public void setAdminEmail(String string) {
        this.addProperty("store.admin.email", string);
    }

    public void setDateFormat(String string) {
        this.addProperty("default_date_format", string);
    }

    public String getDateFormat() {
        return this.getProperty("default_date_format", "dd-MMM-yy");
    }

    public Boolean isSubscriptionActive(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Boolean bl = this.isSubscribed(string);
        SubscriptionStatus subscriptionStatus = this.getSubscriptionStatus(string);
        return bl != false && (subscriptionStatus == SubscriptionStatus.ACTIVE || subscriptionStatus == SubscriptionStatus.TRIALING);
    }

    public void setSubscribed(String string, Boolean bl) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_SUFFIX;
        String string3 = String.valueOf(bl != null && bl != false);
        this.addProperty(string2, string3);
    }

    public Boolean isSubscribed(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_SUFFIX;
        String string3 = this.getProperty(string2);
        if (StringUtils.isNotEmpty((String)string3)) {
            return Boolean.parseBoolean(string3);
        }
        return Boolean.FALSE;
    }

    public void setSubscriptionStatus(String string, SubscriptionStatus subscriptionStatus) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX;
        this.addProperty(string2, subscriptionStatus.getStatusName());
    }

    public SubscriptionStatus getSubscriptionStatus(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX;
        String string3 = this.getProperty(string2);
        return SubscriptionStatus.fromName((String)string3);
    }

    public void setSubscriptionStartDate(String string, Long l) {
        if (StringUtils.isEmpty((String)string) || l == null) {
            return;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX;
        this.addProperty(string2, String.valueOf(l));
    }

    public Long getSubscriptionStartDate(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX;
        String string3 = this.getProperty(string2);
        if (StringUtils.isEmpty((String)string3)) {
            return null;
        }
        return Long.parseLong(string3);
    }

    public void setSubscriptionEndDate(String string, Long l) {
        if (StringUtils.isEmpty((String)string) || l == null) {
            return;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX;
        this.addProperty(string2, String.valueOf(l));
    }

    public Long getSubscriptionEndDate(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX;
        String string3 = this.getProperty(string2);
        if (StringUtils.isEmpty((String)string3)) {
            return null;
        }
        return Long.parseLong(string3);
    }

    public void setSubscriptionPlanId(String string, String string2) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string3 = string + STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX;
        this.addProperty(string3, string2);
    }

    public String getSubscriptionPlanId(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        String string2 = string + STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX;
        String string3 = this.getProperty(string2);
        return string3;
    }

    public Boolean hasExtraMultiplier() {
        String string = this.getProperty(STORE_PROP_EXTRA_MULTIPLIER);
        return StringUtils.isNotEmpty((String)string);
    }

    public Multiplier getExtraMultiplier() {
        return this.getExtraMultiplier(null);
    }

    public Multiplier getExtraMultiplier(Multiplier multiplier) {
        if (this.hasExtraMultiplier().booleanValue()) {
            String string = this.getProperty(STORE_PROP_EXTRA_MULTIPLIER);
            Multiplier multiplier2 = DataProvider.get().getMultiplierById(string);
            return multiplier2;
        }
        return multiplier;
    }

    public Store setExtraMultiplier(Multiplier multiplier) {
        if (multiplier != null) {
            this.addProperty(STORE_PROP_EXTRA_MULTIPLIER, multiplier.getId());
        } else {
            this.addProperty(STORE_PROP_EXTRA_MULTIPLIER, null);
        }
        return this;
    }

    public Boolean hasHalfMultiplier() {
        String string = this.getProperty(STORE_PROP_HALF_MULTIPLIER);
        return StringUtils.isNotEmpty((String)string);
    }

    public Multiplier getHalfMultiplier() {
        return this.getHalfMultiplier(null);
    }

    public Multiplier getHalfMultiplier(Multiplier multiplier) {
        if (this.hasHalfMultiplier().booleanValue()) {
            String string = this.getProperty(STORE_PROP_HALF_MULTIPLIER);
            Multiplier multiplier2 = DataProvider.get().getMultiplierById(string);
            return multiplier2;
        }
        return multiplier;
    }

    public Store setHalfMultiplier(Multiplier multiplier) {
        if (multiplier != null) {
            this.addProperty(STORE_PROP_HALF_MULTIPLIER, multiplier.getId());
        } else {
            this.addProperty(STORE_PROP_HALF_MULTIPLIER, null);
        }
        return this;
    }

    public Boolean hasQuarterMultiplier() {
        String string = this.getProperty(STORE_PROP_QUARTER_MULTIPLIER);
        return StringUtils.isNotEmpty((String)string);
    }

    public Multiplier getQuarterMultiplier() {
        return this.getQuarterMultiplier(null);
    }

    public Multiplier getQuarterMultiplier(Multiplier multiplier) {
        if (this.hasQuarterMultiplier().booleanValue()) {
            String string = this.getProperty(STORE_PROP_QUARTER_MULTIPLIER);
            Multiplier multiplier2 = DataProvider.get().getMultiplierById(string);
            return multiplier2;
        }
        return multiplier;
    }

    public Store setQuarterMultiplier(Multiplier multiplier) {
        if (multiplier != null) {
            this.addProperty(STORE_PROP_QUARTER_MULTIPLIER, multiplier.getId());
        } else {
            this.addProperty(STORE_PROP_QUARTER_MULTIPLIER, null);
        }
        return this;
    }

    public boolean isEnableFloridaTaxRule() {
        String string = this.getProperty(STORE_PROP_FLORIDA_TAX_RULE);
        if (StringUtils.isBlank((String)string)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(string);
    }

    public void setEnableFloridaTaxRule(boolean bl) {
        this.addProperty(STORE_PROP_FLORIDA_TAX_RULE, String.valueOf(bl));
    }

    @XmlTransient
    public List<WorkingHours> getWorkingHours() {
        if (this.workingHours == null) {
            this.workingHours = new ArrayList<WorkingHours>();
            for (int i = 1; i <= 7; ++i) {
                WorkingHours workingHours = this.getWorkingHours(i);
                if (workingHours == null) continue;
                this.workingHours.add(workingHours);
            }
        }
        return this.workingHours;
    }

    public WorkingHours getWorkingHours(int n) {
        if (!this.getBooleanProperty(n + ".Open", true)) {
            return null;
        }
        String string = WorkingHours.days[n];
        return new WorkingHours(n, this.getProperty(string + ".StartTime"), this.getProperty(string + ".EndTime"));
    }

    public void setWorkingHours(List<WorkingHours> list) {
        this.workingHours = list;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isShowSubtotalWithoutTax() {
        return POSUtil.getBoolean(this.getProperty("show_subtotal.without_tax"));
    }

    public int getDecimalPlace() {
        String string = this.getProperty("decimal.place");
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return 2;
            }
        }
        return 2;
    }
}

