/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.CardReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PanelTester;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class CreditCardReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public CreditCardReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(actionEvent -> this.a());
    }

    private void a() {
        try {
            Class clazz22;
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            Class[] classArray = new Class[]{CreditCardTransaction.class, DebitCardTransaction.class, CustomPaymentTransaction.class, CustomerAccountTransaction.class};
            for (Class clazz22 : classArray) {
                List<? extends PosTransaction> list = PosTransactionDAO.getInstance().findTransactions(null, null, clazz22, date, date2, true, false, true);
                for (PosTransaction posTransaction : list) {
                    ++n;
                    d += posTransaction.getAmount().doubleValue();
                    d2 += posTransaction.getTipsAmount().doubleValue();
                    arrayList.add(posTransaction);
                }
            }
            HashMap hashMap = new HashMap();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            hashMap.put("reportTitle", Messages.getString("CreditCardReportView.0"));
            hashMap.put("saleCount", String.valueOf(n));
            hashMap.put("totalSales", NumberUtil.formatNumber(d - d2));
            hashMap.put("totalTips", NumberUtil.formatNumber(d2));
            hashMap.put("total", NumberUtil.formatNumber(d));
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("credit-card-report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new CardReportModel(arrayList)));
            clazz22 = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)((Object)clazz22));
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("colTicketNo", Messages.getString("TicketNo"));
        hashMap.put("colPaymentType", Messages.getString("SettleTicketDialog.9"));
        hashMap.put("colCardType", Messages.getString("TransactionListView.3"));
        hashMap.put("colMember", Messages.getString("MEMBER"));
        hashMap.put("colDate", POSConstants.DATE);
        hashMap.put("colServer", POSConstants.SERVER);
        hashMap.put("colAuthC", Messages.getString("AuthCode"));
        hashMap.put("tips", Messages.getString("CreditCardReportView.2") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("totalHeader", Messages.getString("CreditCardReportView.6") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("rowTSCount", Messages.getString("TSCount"));
        hashMap.put("rowTSales", Messages.getString("TotalSales"));
        hashMap.put("rowTTips", Messages.getString("TotalTips"));
        hashMap.put("rowTotal", POSConstants.TOTAL);
    }

    public static void main(String[] stringArray) {
        PanelTester.width = 800;
        PanelTester.height = 500;
        PanelTester.test(new CreditCardReportView());
    }
}

