/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ListTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JournalReportModel {
    private Date a;
    private Date b;
    private Date c;
    private List<JournalReportData> d = new ArrayList<JournalReportData>();
    private JournalReportTableModel e;

    public JournalReportTableModel getTableModel() {
        if (this.e == null) {
            this.e = new JournalReportTableModel(this.d);
        }
        return this.e;
    }

    public Date getFromDate() {
        if (this.a == null) {
            return DateUtil.startOfDay(new Date());
        }
        return this.a;
    }

    public void setFromDate(Date date) {
        this.a = date;
    }

    public Date getReportTime() {
        return this.c;
    }

    public void setReportTime(Date date) {
        this.c = date;
    }

    public Date getToDate() {
        if (this.b == null) {
            return DateUtil.endOfDay(new Date());
        }
        return this.b;
    }

    public void setToDate(Date date) {
        this.b = date;
    }

    public void addReportData(JournalReportData journalReportData) {
        this.d.add(journalReportData);
    }

    public static class JournalReportTableModel
    extends ListTableModel {
        public JournalReportTableModel(List<JournalReportData> list) {
            super(new String[]{"time", "action", "user", "comment"}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            JournalReportData journalReportData = (JournalReportData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return ReportService.formatFullDate(journalReportData.getTime());
                }
                case 1: {
                    return journalReportData.getAction();
                }
                case 2: {
                    return journalReportData.getUserInfo();
                }
                case 3: {
                    return journalReportData.getComments();
                }
            }
            return null;
        }
    }

    public static class JournalReportData {
        private Date a;
        private String b;
        private String c;
        private String d;

        public String getAction() {
            return this.b;
        }

        public void setAction(String string) {
            this.b = string;
        }

        public String getComments() {
            return this.d;
        }

        public void setComments(String string) {
            this.d = string;
        }

        public Date getTime() {
            return this.a;
        }

        public void setTime(Date date) {
            this.a = date;
        }

        public String getUserInfo() {
            return this.c;
        }

        public void setUserInfo(String string) {
            this.c = string;
        }
    }
}

