/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.SystemProperties;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LabelPrinterTableModel
extends AbstractReportDataSource {
    private Store a = DataProvider.get().getStore();

    public LabelPrinterTableModel(List<LabelItem> list) {
        super(new String[]{"barcodeNumber", "itemName", "memberPrice", "retailPrice", "showBarcode"});
        this.setRows(list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LabelItem labelItem = (LabelItem)this.rows.get(n);
        MenuItem menuItem = labelItem.getMenuItem();
        menuItem = MenuItemDAO.getInstance().get(menuItem.getId());
        switch (n2) {
            case 0: {
                if (POSUtil.getBoolean(this.a.getProperty("label.barcode"))) {
                    return menuItem.getBarcode();
                }
                return "";
            }
            case 1: {
                if (StringUtils.isNotBlank((String)menuItem.getTranslatedName()) && POSUtil.getBoolean(this.a.getProperty("label.print_translated_name"))) {
                    return "<html><body>" + menuItem.getTranslatedName() + "</body></html>";
                }
                return "<html><body>" + menuItem.getName() + "</body></html>";
            }
            case 2: {
                if (POSUtil.getBoolean(this.a.getProperty("label.member.price"))) {
                    return "<html><body>" + Messages.getString("LabelPrinterTableModel.1") + NumberUtil.getCurrencyFormat(menuItem.getPrice()) + "</body></html>";
                }
                return "";
            }
            case 3: {
                if (SystemProperties.isForeTees() && POSUtil.getBoolean(this.a.getProperty("label.isPrint.retail.price"))) {
                    return "<html><body>" + Messages.getString("LabelPrinterTableModel.2") + NumberUtil.getCurrencyFormat(menuItem.getRetailPrice()) + "</body></html>";
                }
                return "";
            }
            case 4: {
                if (!POSUtil.getBoolean(this.a.getProperty("label.barcode"))) {
                    return false;
                }
                return StringUtils.isNotBlank((String)menuItem.getBarcode());
            }
        }
        return null;
    }
}

