/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.swing.ListTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SalesDetailedReport {
    private Date j;
    private Date k;
    private Date l;
    int a;
    double b;
    int c;
    double d;
    int e;
    double f;
    double g;
    double h;
    double i;
    private List<DrawerPullData> m = new ArrayList<DrawerPullData>();
    private Map<String, CreditCardData> n = new HashMap<String, CreditCardData>();
    private Map<String, OtherPaymentData> o = new HashMap<String, OtherPaymentData>();

    public void addCreditCardData(CreditCardTransaction creditCardTransaction) {
        CreditCardData creditCardData = this.n.get(creditCardTransaction.getCardType());
        if (creditCardData == null) {
            creditCardData = new CreditCardData();
            creditCardData.setCardName(creditCardTransaction.getCardType());
            this.n.put(creditCardTransaction.getCardType(), creditCardData);
        }
        creditCardData.setSalesCount(creditCardData.getSalesCount() + 1);
        creditCardData.setSalesAmount(creditCardData.getSalesAmount() + creditCardTransaction.getAmount());
        creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() + creditCardTransaction.getAmount());
    }

    public void addCreditCardData(DebitCardTransaction debitCardTransaction) {
        CreditCardData creditCardData = this.n.get(debitCardTransaction.getCardType());
        if (creditCardData == null) {
            creditCardData = new CreditCardData();
            creditCardData.setCardName(debitCardTransaction.getCardType());
            this.n.put(debitCardTransaction.getCardType(), creditCardData);
        }
        creditCardData.setSalesCount(creditCardData.getSalesCount() + 1);
        creditCardData.setSalesAmount(creditCardData.getSalesAmount() + debitCardTransaction.getAmount());
        creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() + debitCardTransaction.getAmount());
    }

    public void addPaymentData(PosTransaction posTransaction) {
        PaymentType paymentType = posTransaction.getPaymentType();
        if (posTransaction instanceof RefundTransaction) {
            if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
                CreditCardData creditCardData = this.n.get(posTransaction.getCardType());
                if (creditCardData == null) {
                    creditCardData = new CreditCardData();
                    creditCardData.setCardName(posTransaction.getCardType().replaceAll("_", " "));
                    this.n.put(posTransaction.getCardType(), creditCardData);
                }
                creditCardData.setReturnCount(creditCardData.getReturnCount() + 1);
                creditCardData.setReturnAmount(creditCardData.getReturnAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
                creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() - (posTransaction.getAmount() - posTransaction.getTipsAmount()));
                creditCardData.setNetTipsAmount(creditCardData.getNetTipsAmount() - posTransaction.getTipsAmount());
            } else {
                OtherPaymentData otherPaymentData = this.o.get(posTransaction.getPaymentTypeString());
                if (otherPaymentData == null) {
                    otherPaymentData = new OtherPaymentData();
                    otherPaymentData.setPaymentName(posTransaction.getPaymentType().getDisplayString());
                    this.o.put(posTransaction.getPaymentTypeString(), otherPaymentData);
                }
                otherPaymentData.setReturnCount(otherPaymentData.getReturnCount() + 1);
                otherPaymentData.setReturnAmount(otherPaymentData.getReturnAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
                otherPaymentData.setNetSalesAmount(otherPaymentData.getNetSalesAmount() - (posTransaction.getAmount() - posTransaction.getTipsAmount()));
                otherPaymentData.setNetTipsAmount(otherPaymentData.getNetTipsAmount() - posTransaction.getTipsAmount());
            }
            this.i -= posTransaction.getAmount() - posTransaction.getTipsAmount();
        } else if (paymentType == PaymentType.CUSTOM_PAYMENT) {
            if (posTransaction.isVoided().booleanValue()) {
                return;
            }
            OtherPaymentData otherPaymentData = this.o.get(posTransaction.getCustomPaymentName());
            if (otherPaymentData == null) {
                otherPaymentData = new OtherPaymentData();
                otherPaymentData.setPaymentName(posTransaction.getCustomPaymentName());
                this.o.put(posTransaction.getCustomPaymentName(), otherPaymentData);
            }
            otherPaymentData.setSalesCount(otherPaymentData.getSalesCount() + 1);
            otherPaymentData.setSalesAmount(otherPaymentData.getSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetSalesAmount(otherPaymentData.getNetSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetTipsAmount(otherPaymentData.getNetTipsAmount() + posTransaction.getTipsAmount());
            this.i += posTransaction.getAmount() - posTransaction.getTipsAmount();
        } else if (paymentType == PaymentType.CASH || paymentType == PaymentType.GIFT_CERTIFICATE) {
            if (posTransaction.isVoided().booleanValue()) {
                return;
            }
            OtherPaymentData otherPaymentData = this.o.get(posTransaction.getPaymentTypeString());
            if (otherPaymentData == null) {
                otherPaymentData = new OtherPaymentData();
                otherPaymentData.setPaymentName(posTransaction.getPaymentType().getDisplayString());
                this.o.put(posTransaction.getPaymentTypeString(), otherPaymentData);
            }
            otherPaymentData.setSalesCount(otherPaymentData.getSalesCount() + 1);
            otherPaymentData.setSalesAmount(otherPaymentData.getSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetSalesAmount(otherPaymentData.getNetSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetTipsAmount(otherPaymentData.getNetTipsAmount() + posTransaction.getTipsAmount());
            this.i += posTransaction.getAmount() - posTransaction.getTipsAmount();
        } else if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
            if (posTransaction.isVoided().booleanValue() && !posTransaction.hasProperty("REFUNDED_AMOUNT")) {
                return;
            }
            CreditCardData creditCardData = this.n.get(posTransaction.getCardType());
            if (creditCardData == null) {
                creditCardData = new CreditCardData();
                creditCardData.setCardName(posTransaction.getCardType().replaceAll("_", " "));
                this.n.put(posTransaction.getCardType(), creditCardData);
            }
            creditCardData.setSalesCount(creditCardData.getSalesCount() + 1);
            creditCardData.setSalesAmount(creditCardData.getSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            creditCardData.setNetTipsAmount(creditCardData.getNetTipsAmount() + posTransaction.getTipsAmount());
            this.i += posTransaction.getAmount() - posTransaction.getTipsAmount();
        }
    }

    public void addDrawerPullData(DrawerPullData drawerPullData) {
        this.m.add(drawerPullData);
    }

    public Date getFromDate() {
        return this.j;
    }

    public void setFromDate(Date date) {
        this.j = date;
    }

    public Date getReportTime() {
        return this.l;
    }

    public void setReportTime(Date date) {
        this.l = date;
    }

    public Date getToDate() {
        return this.k;
    }

    public void setToDate(Date date) {
        this.k = date;
    }

    public DrawerPullDataTableModel getDrawerPullDataTableModel() {
        DrawerPullDataTableModel drawerPullDataTableModel = new DrawerPullDataTableModel();
        drawerPullDataTableModel.setRows(this.m);
        return drawerPullDataTableModel;
    }

    public CreditCardDataTableModel getCreditCardDataTableModel() {
        CreditCardDataTableModel creditCardDataTableModel = new CreditCardDataTableModel();
        ArrayList<CreditCardData> arrayList = new ArrayList<CreditCardData>(this.n.values());
        creditCardDataTableModel.setRows(arrayList);
        for (CreditCardData creditCardData : arrayList) {
            double d = creditCardData.getNetSalesAmount() / this.i * 100.0;
            creditCardData.setPercentage(d);
        }
        return creditCardDataTableModel;
    }

    public OtherPaymentDataTableModel getOtherPaymentDataTableModel() {
        OtherPaymentDataTableModel otherPaymentDataTableModel = new OtherPaymentDataTableModel();
        ArrayList<OtherPaymentData> arrayList = new ArrayList<OtherPaymentData>(this.o.values());
        ArrayList<OtherPaymentData> arrayList2 = new ArrayList<OtherPaymentData>();
        for (OtherPaymentData otherPaymentData : arrayList) {
            double d = otherPaymentData.getNetSalesAmount() / this.i * 100.0;
            otherPaymentData.setPercentage(d);
            if (otherPaymentData.getPaymentName() != null && otherPaymentData.getPaymentName().equals(PaymentType.CASH.getDisplayString())) {
                arrayList2.add(0, otherPaymentData);
                continue;
            }
            arrayList2.add(otherPaymentData);
        }
        otherPaymentDataTableModel.setRows(arrayList2);
        return otherPaymentDataTableModel;
    }

    public double getChargedTips() {
        return this.f;
    }

    public void setChargedTips(double d) {
        this.f = d;
    }

    public double getGiftCertChangeAmount() {
        return this.d;
    }

    public void setGiftCertChangeAmount(double d) {
        this.d = d;
    }

    public int getGiftCertChangeCount() {
        return this.c;
    }

    public void setGiftCertChangeCount(int n) {
        this.c = n;
    }

    public double getGiftCertReturnAmount() {
        return this.b;
    }

    public void setGiftCertReturnAmount(double d) {
        this.b = d;
    }

    public int getGiftCertReturnCount() {
        return this.a;
    }

    public void setGiftCertReturnCount(int n) {
        this.a = n;
    }

    public double getTipsDifferential() {
        return this.h;
    }

    public void setTipsDifferential(double d) {
        this.h = d;
    }

    public double getTipsPaid() {
        return this.g;
    }

    public void setTipsPaid(double d) {
        this.g = d;
    }

    public int getTipsCount() {
        return this.e;
    }

    public void setTipsCount(int n) {
        this.e = n;
    }

    public class OtherPaymentDataTableModel
    extends ListTableModel<OtherPaymentData> {
        public OtherPaymentDataTableModel() {
            this.setColumnNames(new String[]{"paymentName", "salesCount", "salesAmount", "returnCount", "returnAmount", "netAmount", "netTipsAmount", "percentage"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            OtherPaymentData otherPaymentData = (OtherPaymentData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return otherPaymentData.a;
                }
                case 1: {
                    return otherPaymentData.b;
                }
                case 2: {
                    return otherPaymentData.c;
                }
                case 3: {
                    return otherPaymentData.d;
                }
                case 4: {
                    return otherPaymentData.e;
                }
                case 5: {
                    return otherPaymentData.f;
                }
                case 6: {
                    return otherPaymentData.g;
                }
                case 7: {
                    return otherPaymentData.h;
                }
            }
            return null;
        }
    }

    public class CreditCardDataTableModel
    extends ListTableModel<CreditCardData> {
        public CreditCardDataTableModel() {
            this.setColumnNames(new String[]{"creditCard", "salesCount", "salesAmount", "returnCount", "returnAmount", "netAmount", "netTipsAmount", "percentage"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CreditCardData creditCardData = (CreditCardData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return creditCardData.a;
                }
                case 1: {
                    return creditCardData.b;
                }
                case 2: {
                    return creditCardData.c;
                }
                case 3: {
                    return creditCardData.d;
                }
                case 4: {
                    return creditCardData.e;
                }
                case 5: {
                    return creditCardData.f;
                }
                case 6: {
                    return creditCardData.g;
                }
                case 7: {
                    return creditCardData.h;
                }
            }
            return null;
        }
    }

    public class DrawerPullDataTableModel
    extends ListTableModel {
        public DrawerPullDataTableModel() {
            this.setColumnNames(new String[]{"no", "count", "ideal", "actual", "variant"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DrawerPullData drawerPullData = (DrawerPullData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return POSConstants.DRAWER_PULL_ + drawerPullData.a;
                }
                case 1: {
                    return drawerPullData.getTicketCount();
                }
                case 2: {
                    return drawerPullData.c;
                }
                case 3: {
                    return drawerPullData.d;
                }
                case 4: {
                    return drawerPullData.getVarinceAmount();
                }
            }
            return null;
        }
    }

    public static class OtherPaymentData {
        String a;
        int b;
        double c;
        int d;
        double e;
        double f;
        double g;
        double h;

        public String getPaymentName() {
            return this.a;
        }

        public void setPaymentName(String string) {
            this.a = string;
        }

        public double getNetSalesAmount() {
            return this.f;
        }

        public void setNetSalesAmount(double d) {
            this.f = d;
        }

        public double getNetTipsAmount() {
            return this.g;
        }

        public void setNetTipsAmount(double d) {
            this.g = d;
        }

        public double getPercentage() {
            return this.h;
        }

        public void setPercentage(double d) {
            this.h = d;
        }

        public double getReturnAmount() {
            return this.e;
        }

        public void setReturnAmount(double d) {
            this.e = d;
        }

        public int getReturnCount() {
            return this.d;
        }

        public void setReturnCount(int n) {
            this.d = n;
        }

        public double getSalesAmount() {
            return this.c;
        }

        public void setSalesAmount(double d) {
            this.c = d;
        }

        public int getSalesCount() {
            return this.b;
        }

        public void setSalesCount(int n) {
            this.b = n;
        }
    }

    public static class CreditCardData {
        String a;
        int b;
        double c;
        int d;
        double e;
        double f;
        double g;
        double h;

        public String getCardName() {
            return this.a;
        }

        public void setCardName(String string) {
            this.a = string;
        }

        public double getNetSalesAmount() {
            return this.f;
        }

        public void setNetSalesAmount(double d) {
            this.f = d;
        }

        public double getNetTipsAmount() {
            return this.g;
        }

        public void setNetTipsAmount(double d) {
            this.g = d;
        }

        public double getPercentage() {
            return this.h;
        }

        public void setPercentage(double d) {
            this.h = d;
        }

        public double getReturnAmount() {
            return this.e;
        }

        public void setReturnAmount(double d) {
            this.e = d;
        }

        public int getReturnCount() {
            return this.d;
        }

        public void setReturnCount(int n) {
            this.d = n;
        }

        public double getSalesAmount() {
            return this.c;
        }

        public void setSalesAmount(double d) {
            this.c = d;
        }

        public int getSalesCount() {
            return this.b;
        }

        public void setSalesCount(int n) {
            this.b = n;
        }
    }

    public static class DrawerPullData {
        private String a;
        private int b;
        private double c;
        private double d;
        private double e;

        public double getActualAmount() {
            return this.d;
        }

        public void setActualAmount(double d) {
            this.d = d;
        }

        public String getDrawerPullId() {
            return this.a;
        }

        public void setDrawerPullId(String string) {
            this.a = string;
        }

        public double getIdealAmount() {
            return this.c;
        }

        public void setIdealAmount(double d) {
            this.c = d;
        }

        public int getTicketCount() {
            return this.b;
        }

        public void setTicketCount(int n) {
            this.b = n;
        }

        public double getVarinceAmount() {
            return this.e;
        }

        public void setVarinceAmount(double d) {
            this.e = d;
        }
    }
}

