/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class EndOfDaySummaryReportModel
extends ListTableModel {
    public EndOfDaySummaryReportModel() {
        super(new String[]{"empName", "customerName", "ticketId", "ticketAmt", "serviceCharge", "tips", "tax", "total", "memberCharge", "creditCard", "cashPymt", "othersPayment", "discount", "refund"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        EndOfDayReportData endOfDayReportData = (EndOfDayReportData)this.rows.get(n);
        switch (n2) {
            case 0: {
                return endOfDayReportData.getEmployeeId() + " - " + endOfDayReportData.getEmployeeName();
            }
            case 1: {
                String string = endOfDayReportData.getCustomerName();
                String string2 = endOfDayReportData.getMemberId() == null ? "" : endOfDayReportData.getMemberId() + " - ";
                return string == null ? Messages.getString("GUEST") : string2 + string;
            }
            case 2: {
                return endOfDayReportData.getTicketId();
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getNetAmount());
            }
            case 4: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getServiceCharge());
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getGratuityAmount());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getTaxAmount());
            }
            case 7: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getTotalTicketAmount() + endOfDayReportData.getGratuityAmount());
            }
            case 8: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getMemberCharge());
            }
            case 9: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getCreditCardPayment());
            }
            case 10: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getCashPayment());
            }
            case 11: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getOthersPayment());
            }
            case 12: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getDiscount());
            }
            case 13: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(endOfDayReportData.getRefundPaymentCredit());
            }
        }
        return null;
    }
}

