/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.StaffBankCloseAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseStore;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CashDropTransactionDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.GratuityDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PayoutDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.jdesktop.swingx.JXDatePicker;

public class CashDrawerReportDialog
extends POSDialog
implements ActionListener {
    private TitlePanel a;
    private CashDrawer b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private PosButton i;
    private User j;
    private Terminal k;
    private PosButton l;
    private PosButton m;
    private PosButton n;
    private List<CashDrawer> o;
    private JPanel p;
    private JPanel q;
    private JPanel r;
    private PosButton s;
    private boolean t;
    private JasperPrint u;
    private JasperPrint v;

    public CashDrawerReportDialog(CashDrawer cashDrawer) {
        this(null, cashDrawer);
    }

    public CashDrawerReportDialog(User user, CashDrawer cashDrawer) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.j = user;
        this.b = cashDrawer;
        this.k = cashDrawer.getTerminal();
        this.b();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void a() {
        boolean bl;
        if (this.t) {
            return;
        }
        if (this.b.getId() == null || this.b.isClosed()) {
            this.a(false);
            return;
        }
        boolean bl2 = this.b.getTerminal().getId().intValue() == Application.getInstance().getTerminal().getId().intValue();
        boolean bl3 = bl = this.b.getDrawerType() == DrawerType.STAFF_BANK;
        if (bl) {
            this.c.setText(Messages.getString("CloseStaffBank"));
        }
        this.c.setEnabled(this.b.getId() != null && this.b.isOpen());
        this.g.setEnabled(this.b.getId() != null && this.b.isOpen());
        this.i.setVisible(bl);
        this.h.setVisible(bl);
        this.g.setVisible(bl);
        this.d.setVisible(!bl);
        this.e.setVisible(!bl && bl2);
        this.f.setVisible(bl2);
        this.c.setVisible(!bl);
        this.n.setVisible(!bl);
    }

    private void a(boolean bl) {
        this.c.setEnabled(bl);
        this.g.setVisible(bl);
        this.i.setEnabled(bl);
        this.h.setEnabled(bl);
        this.g.setEnabled(bl);
        this.d.setEnabled(bl);
        this.f.setEnabled(bl);
        this.c.setVisible(bl);
        this.n.setVisible(bl);
    }

    public void showInfoOnly(boolean bl) {
        this.t = bl;
        this.q.setVisible(!bl);
        if (this.j == null) {
            return;
        }
        if (this.t) {
            this.r.removeAll();
            this.r.add((Component)new JSeparator(), "grow,span,wrap");
            this.r.add((Component)this.m, "grow");
            this.r.add((Component)this.l, "grow");
            this.r.add((Component)this.s, "grow");
            this.g.setVisible(!this.t);
            this.c.setVisible(!this.t);
        }
    }

    private void b() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.add((Component)this.a, "North");
        this.p = new JPanel(new BorderLayout());
        this.add(new PosScrollPane(this.p));
        this.r = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.l = new PosButton(POSConstants.PRINT);
        this.s = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.d = new PosButton(POSConstants.DRAWER_BLEED);
        this.e = new PosButton(Messages.getString("ManagerDialog.1"));
        this.f = new PosButton(POSConstants.PAYOUT_BUTTON_TEXT);
        this.c = new PosButton(Messages.getString("CashDrawerReportDialog.6"));
        this.d.addActionListener(this);
        this.e.addActionListener(this);
        this.f.addActionListener(this);
        this.c.addActionListener(actionEvent -> this.p());
        this.g = new PosButton(Messages.getString("CloseStaffBank"));
        this.g.addActionListener(actionEvent -> this.q());
        this.i = new PosButton(Messages.getString("DeclareTips"));
        this.i.addActionListener(actionEvent -> this.g());
        this.h = new PosButton(Messages.getString("CashDrawerReportDialog.9"));
        this.h.addActionListener(actionEvent -> this.h());
        this.q = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 0 20 0 20,wrap 1", "[120px,grow]", ""));
        this.r.add((Component)new JSeparator(), "grow,span,wrap");
        this.r.add((Component)this.l, "gapleft 160,grow");
        this.m = new PosButton(POSConstants.DETAILS);
        this.m.addActionListener(actionEvent -> this.d());
        this.n = new PosButton(Messages.getString("CashDrawerReportDialog.0"));
        this.n.addActionListener(actionEvent -> this.c());
        this.q.add((Component)this.d, "grow");
        this.q.add((Component)this.e, "grow");
        this.q.add((Component)this.f, "grow");
        this.r.add((Component)this.m, "grow");
        this.r.add((Component)this.n, "grow");
        this.r.add((Component)this.c, "grow");
        this.r.add((Component)this.g, "grow");
        this.q.add((Component)this.h, "grow");
        this.r.add((Component)this.s, "grow");
        this.add((Component)this.r, "South");
        this.add((Component)this.q, "West");
        this.s.addActionListener(actionEvent -> this.i());
        this.l.addActionListener(actionEvent -> this.j());
    }

    public void refreshReport() throws Exception {
        this.createReport(!this.t);
        this.a();
    }

    private void c() {
        try {
            UserListDialog userListDialog = new UserListDialog();
            userListDialog.pack();
            userListDialog.open();
            if (userListDialog.isCanceled()) {
                return;
            }
            User user = userListDialog.getSelectedUser();
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.16"));
                return;
            }
            CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
            cashDrawerDAO.refresh(this.b);
            String string = this.b.getAssignedUserId();
            if (string.equals(user.getId())) {
                POSMessageDialog.showError(Messages.getString("CashDrawerReportDialog.1"));
                return;
            }
            cashDrawerDAO.transferUser(this.b, user);
            POSMessageDialog.showMessage(Messages.getString("DrawerAssignmentAction.8") + " " + user.getFullName());
            this.refreshReport();
            this.a(this.b, string);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(CashDrawer cashDrawer, String string) {
        try {
            String string2 = String.format("Drawer id : %s is transfered from user %s to user %s", cashDrawer.getId(), string, cashDrawer.getAssignedUserId());
            ActionHistoryDAO.saveHistory(this.j, "Cash drawer assignment change", string2);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void d() {
        try {
            if (this.b == null) {
                return;
            }
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() throws Exception {
        this.f();
        DetailReportDialog detailReportDialog = new DetailReportDialog(this.u);
        detailReportDialog.setTitle(this.b.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? Messages.getString("CashDrawerReportDialog.13") : Messages.getString("CashDrawerReportDialog.14"));
        detailReportDialog.updateView();
        detailReportDialog.open();
    }

    private void f() throws JRException {
        Object object;
        Object object2;
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        if (this.o != null && this.o.size() > 0) {
            for (CashDrawer serializable2 : this.o) {
                object2 = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(serializable2.getId(), false);
                arrayList.addAll((Collection<PosTransaction>)object2);
            }
        } else {
            object = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(this.b.getId(), false);
            arrayList.addAll((Collection<PosTransaction>)object);
        }
        object = new CashDrawerTransactionReportModel();
        ((CashDrawerTransactionReportModel)object).setItems(arrayList);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object2 = DataProvider.get().getStore();
        ReportUtil.populatePatternExpression(hashMap, (Store)object2);
        hashMap.put("headerLine1", ((BaseStore)object2).getName());
        hashMap.put("headerLine2", ((BaseStore)object2).getAddressLine1());
        hashMap.put("receiptType", this.b.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? Messages.getString("CashDrawerReportDialog.13") : Messages.getString("CashDrawerReportDialog.14"));
        if (this.b.getAssignedUser() != null) {
            hashMap.put("serverName", Messages.getString("CashDrawerReportDialog.17") + this.b.getAssignedUser());
        }
        hashMap.put("startDate", Messages.getString("CashDrawerReportDialog.18") + DateUtil.formatFullDateAndTimeAsString(this.b.getStartTime()));
        hashMap.put("status", arrayList == null || arrayList.isEmpty() ? Messages.getString("NoTransactionFound") : null);
        JasperReport jasperReport = ReportUtil.getReport("transaction_report_receipt");
        this.u = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)object));
    }

    private void g() {
        try {
            if (this.b == null) {
                return;
            }
            Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), Messages.getString("CashDrawerReportDialog.21"), this.b.getTipsPaid());
            if (Double.isNaN(d)) {
                return;
            }
            this.b.setDeclaredTips(d);
            TerminalDAO.getInstance().performBatchSave(this.b);
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void h() {
        this.k();
    }

    private void i() {
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(VersionInfo.getAppName());
    }

    private void j() {
        try {
            PosPrintService.printReportByJasperPrint(this.v);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + exception.getMessage(), exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            PosButton posButton = (PosButton)actionEvent.getSource();
            if (posButton == this.d) {
                this.l();
                this.refreshReport();
            } else if (posButton == this.e) {
                this.m();
            } else if (posButton == this.f) {
                this.n();
                this.refreshReport();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void k() {
        GratuityDialog gratuityDialog = new GratuityDialog((Window)this, this.j);
        gratuityDialog.setCaption(Messages.getString("TipsManagement"));
        gratuityDialog.setOkButtonText(Messages.getString("PAY"));
        gratuityDialog.setSize(PosUIManager.getSize(780, 550));
        gratuityDialog.open();
        if (gratuityDialog.isCanceled()) {
            return;
        }
        try {
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void l() {
        try {
            DrawerUtil.kickDrawer();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("CashDropDialog.17"));
            numberSelectionDialog2.setFloatingPoint(true);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (!numberSelectionDialog2.isCanceled()) {
                double d = numberSelectionDialog2.getValue();
                CashDropTransaction cashDropTransaction = new CashDropTransaction();
                StoreSession storeSession = DataProvider.get().getStoreSession();
                cashDropTransaction.setDrawerResetted(false);
                cashDropTransaction.setTerminal(this.k);
                if (this.j.isStaffBankStarted().booleanValue()) {
                    cashDropTransaction.setCashDrawer(this.j.getActiveDrawerPullReport());
                } else {
                    cashDropTransaction.setCashDrawer(this.k.getCurrentCashDrawer());
                }
                cashDropTransaction.setPaymentType(PaymentType.CASH);
                cashDropTransaction.setUser(this.j);
                cashDropTransaction.setServer(this.j);
                cashDropTransaction.setTransactionTime(new Date());
                cashDropTransaction.setAmount(d);
                cashDropTransaction.setStoreSessionId(storeSession.getId());
                CashDropTransactionDAO cashDropTransactionDAO = new CashDropTransactionDAO();
                cashDropTransactionDAO.saveNewCashDrop(cashDropTransaction, this.k);
                this.a(d);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("CashDropDialog.18"), exception);
        }
    }

    private void a(double d) {
        try {
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            CashDrawer cashDrawer = terminal.getCurrentCashDrawer();
            String string = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", terminal.getId(), cashDrawer.getId(), NumberUtil.formatNumber(d));
            ActionHistoryDAO.saveHistory(this.j, "Cash drawer bleed", string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void m() {
        try {
            DrawerUtil.kickDrawer();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void n() {
        try {
            TerminalDAO.getInstance().refresh(this.k);
            if (!POSUtil.checkDrawerAssignment(this.k, this.j)) {
                return;
            }
            DrawerUtil.kickDrawer();
            PayoutDialog payoutDialog = new PayoutDialog((Dialog)this, this.j, this.k);
            payoutDialog.open();
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void o() {
        try {
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
            List<User> list = UserDAO.getInstance().findAll();
            JXDatePicker jXDatePicker = UiUtil.getCurrentMonthStart();
            JXDatePicker jXDatePicker2 = UiUtil.getCurrentMonthEnd();
            jPanel.add((Component)new JLabel(POSConstants.SELECT_USER + ":"), "grow");
            JComboBox jComboBox = new JComboBox(new ListComboBoxModel(list));
            jPanel.add(jComboBox, "grow, wrap");
            jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
            jPanel.add((Component)jXDatePicker, "wrap");
            jPanel.add((Component)new JLabel(POSConstants.TO_), "grow");
            jPanel.add((Component)jXDatePicker2);
            int n = JOptionPane.showOptionDialog(Application.getPosWindow(), jPanel, POSConstants.SELECT_CRIETERIA, 2, 3, null, null, null);
            if (n != 0) {
                return;
            }
            GratuityDAO gratuityDAO = new GratuityDAO();
            TipsCashoutReport tipsCashoutReport = gratuityDAO.createReport(jXDatePicker.getDate(), jXDatePicker2.getDate(), (User)jComboBox.getSelectedItem());
            TipsCashoutReportDialog tipsCashoutReportDialog = new TipsCashoutReportDialog(tipsCashoutReport);
            tipsCashoutReportDialog.setSize(400, 600);
            tipsCashoutReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void p() {
        try {
            DrawerUtil.kickDrawer();
            DrawerAssignmentAction drawerAssignmentAction = new DrawerAssignmentAction(this.k, this.b, this.j);
            drawerAssignmentAction.execute();
            this.b = CashDrawerDAO.getInstance().get(this.b.getId());
            this.refreshReport();
            ActionHistoryDAO.saveHistory(this.j, "Cash drawer close", "Drawer id: " + this.b.getId());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void q() {
        try {
            if (!this.j.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CashDrawerReportDialog.25"));
                return;
            }
            StaffBankCloseAction staffBankCloseAction = new StaffBankCloseAction(this.b, this.j);
            staffBankCloseAction.execute();
            this.b = CashDrawerDAO.getInstance().get(this.b.getId());
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public void createReport(boolean bl) throws Exception {
        Object object;
        this.p.removeAll();
        if (bl || this.b.getReportTime() == null) {
            object = new CashDrawerReportService(this.b);
            ((CashDrawerReportService)object).populateReport();
        }
        this.v = PosPrintService.populateTerminalStatusReport(this.b);
        object = new TicketReceiptView(this.v);
        ((TicketReceiptView)object).setZoom(1.25f);
        this.p.add(((TicketReceiptView)object).getReportPanel());
        this.p.revalidate();
        this.p.repaint();
    }
}

