/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.MenuCategoryExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class CategoryExplorerAction
extends AbstractAction {
    public CategoryExplorerAction() {
        super(POSConstants.MENU_CATEGORIES);
    }

    public CategoryExplorerAction(String string) {
        super(string);
    }

    public CategoryExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            MenuCategoryExplorer menuCategoryExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.CATEGORY_EXPLORER);
            if (n == -1) {
                menuCategoryExplorer = new MenuCategoryExplorer();
                jTabbedPane.addTab(POSConstants.CATEGORY_EXPLORER, menuCategoryExplorer);
            } else {
                menuCategoryExplorer = (MenuCategoryExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(menuCategoryExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

