/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DataResetDialog
extends OkCancelOptionDialog
implements ProgressObserver {
    private JTabbedPane a;
    private JLabel b;
    private JPanel c;
    private CheckBoxList d = new CheckBoxList();

    public DataResetDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.setTitle(Messages.getString("DataResetDialog.0"));
        this.setOkButtonText(Messages.getString("DataResetDialog.0"));
        this.setCaption(Messages.getString("DataResetDialog.0"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        ArrayList<DataResetEntry> arrayList = new ArrayList<DataResetEntry>();
        arrayList.add(DataResetEntry.Ticket);
        arrayList.add(DataResetEntry.Session);
        arrayList.add(DataResetEntry.Transactions);
        arrayList.add(DataResetEntry.InvStock);
        arrayList.add(DataResetEntry.ResetAvlStock);
        arrayList.add(DataResetEntry.PurchaseOrder);
        arrayList.add(DataResetEntry.StockCount);
        this.d.setModel(arrayList);
        this.d.selectItems(arrayList);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        jPanel2.setBackground(Color.white);
        jPanel2.add(this.d);
        this.a = new JTabbedPane();
        this.a.addTab(Messages.getString("DataResetDialog.10"), jPanel2);
        jPanel.add(this.a);
        this.c = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.b = new JLabel(Messages.getString("DataResetDialog.12"));
        this.c.add((Component)this.b, "grow,span,wrap");
        this.c.setVisible(false);
        jPanel.add((Component)this.c, "South");
    }

    @Override
    public void doOk() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DataResetDialog.14"), POSConstants.CONFIRM) != 0) {
            return;
        }
        this.c.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                DataResetDialog.this.doResetData();
                if (!StoreUtil.isStoreOpen()) {
                    Application.getInstance().doLogout();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResetData() {
        try {
            this.getButtonPanel().getComponent(0).setEnabled(false);
            this.c.setVisible(true);
            this.progress(0, Messages.getString("DataResetDialog.15"));
            try {
                List list = this.d.getCheckedValues();
                for (DataResetEntry dataResetEntry : list) {
                    switch (dataResetEntry) {
                        case Ticket: {
                            this.c();
                            break;
                        }
                        case Session: {
                            this.a();
                            break;
                        }
                        case Transactions: {
                            this.e();
                            break;
                        }
                        case InvStock: {
                            this.f();
                            break;
                        }
                        case ResetAvlStock: {
                            this.b();
                            break;
                        }
                        case PurchaseOrder: {
                            this.d();
                            break;
                        }
                        case StockCount: {
                            this.g();
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                BOMessageDialog.showError(exception.getMessage());
            }
            this.progress(100, Messages.getString("DataResetDialog.23"));
            this.c.setVisible(false);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Successfully clear table data.");
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception);
            this.progress(0, Messages.getString("DataResetDialog.24"));
        }
        finally {
            this.getButtonPanel().getComponent(0).setEnabled(true);
        }
    }

    private void a() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Terminal set currentCashDrawer=null, assignedUser=null");
        arrayList.add("User set currentCashDrawer=null");
        this.a(arrayList, "update ");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("OTHER_REVENUE_CATEGORY");
        this.a(arrayList2, true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("ActionHistory");
        arrayList3.add("AttendenceHistory");
        arrayList3.add("CashDrawer");
        arrayList3.add("CashBreakdown");
        arrayList3.add("StoreSessionControl");
        arrayList3.add("StoreSession where closeTime!=null");
        this.a(arrayList3);
        Application application = Application.getInstance();
        User user = Application.getCurrentUser();
        AttendenceHistory attendenceHistory = AttendenceHistoryDAO.getInstance().findByLastClockInTime(user);
        if (attendenceHistory == null) {
            attendenceHistory = AttendenceHistoryDAO.createNewHistory(user, Application.getInstance().getTerminal(), user.getCurrentShift());
        }
        Shift shift = user.getCurrentShift();
        Calendar calendar = Calendar.getInstance();
        user.doClockOut(attendenceHistory, shift, calendar);
        application.refreshAndGetTerminal();
        application.refreshCurrentUser();
    }

    private void b() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = String.format("MenuItemInventoryStatus set availableUnit =  %s,unitOnHand = %s", new Double(0.0), new Double(0.0));
        arrayList.add(string);
        this.a(arrayList, "update ");
    }

    private void c() {
        List<Ticket> list = TicketDAO.getInstance().findAll();
        for (Ticket serializable2 : list) {
            TicketDAO.getInstance().delete(serializable2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add("KIT_TICKET_TABLE_NUM");
        this.a((List<String>)arrayList, true);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("VoidItem");
        arrayList2.add("KitchenTicketItem");
        arrayList2.add("KitchenTicket");
        this.a(arrayList2);
    }

    private void d() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PurchaseOrderItem");
        arrayList.add("PurchaseOrder");
        this.a(arrayList);
    }

    private void e() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("InventoryTransaction");
        this.a(arrayList);
    }

    private void f() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("InventoryStock");
        this.a(arrayList);
    }

    private void g() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("StockCountItem");
        arrayList.add("StockCount");
        this.a(arrayList);
    }

    private void a(List<String> list) {
        this.a(list, "delete from ");
    }

    private void a(List<String> list, boolean bl) {
        this.a(list, "delete from ", bl);
    }

    private void a(List<String> list, String string) {
        this.a(list, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(List<String> list, String string, boolean bl) {
        Transaction transaction = null;
        Session session = null;
        GenericDAO genericDAO = new GenericDAO();
        try {
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            for (String string2 : list) {
                SQLQuery sQLQuery;
                String string3 = string + string2;
                if (bl) {
                    sQLQuery = session.createSQLQuery(string3);
                    sQLQuery.executeUpdate();
                    continue;
                }
                sQLQuery = session.createQuery(string3);
                sQLQuery.executeUpdate();
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        finally {
            genericDAO.closeSession(session);
        }
    }

    @Override
    public void progress(int n, String string) {
        this.b.setText(string);
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public Component getParentComponent() {
        return POSUtil.getFocusedWindow();
    }

    @Override
    public void progress(String string) {
        this.b.setText(Messages.getString("DataResetDialog.49") + string);
    }

    static enum DataResetEntry {
        Ticket(1, Messages.getString("DataResetDialog.1")),
        Session(2, Messages.getString("DataResetDialog.2")),
        Transactions(3, Messages.getString("DataResetDialog.11")),
        InvStock(4, Messages.getString("DataResetDialog.13")),
        ResetAvlStock(5, Messages.getString("DataResetDialog.16")),
        PurchaseOrder(6, Messages.getString("DataResetDialog.17")),
        StockCount(7, Messages.getString("DataResetDialog.18"));

        private int a;
        private String b;

        private DataResetEntry(int n2, String string2) {
            this.a = n2;
            this.b = string2;
        }

        public int getDataNo() {
            return this.a;
        }

        public String getDisplayText() {
            return this.b;
        }

        public String toString() {
            return this.getDisplayText();
        }
    }
}

