/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ComboGroupTreeExplorer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;

public class ComboItemExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a;
    private final ComboItemExplorerTableModel b;
    private MenuItem c;
    private ComboGroupTreeExplorer d;
    private JCheckBox e;
    private JCheckBox f;

    public ComboItemExplorer() {
        this.a();
        this.b = new ComboItemExplorerTableModel();
        this.a.setModel(this.b);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable();
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(30);
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        this.f = new JCheckBox(Messages.getString("ComboItemExplorer.1"));
        this.f.addActionListener(actionEvent -> this.b(actionEvent));
        this.e = new JCheckBox(Messages.getString("ComboItemExplorer.0"));
        this.e.addActionListener(actionEvent -> this.a(actionEvent));
        this.add((Component)this.f, "wrap");
        this.add((Component)this.e, "wrap");
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 0 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setPreferredSize(PosUIManager.getSize(0, 150));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ComboItemExplorer.5")));
        jPanel.add((Component)jScrollPane, "grow,wrap");
        jPanel.add((Component)transparentPanel, "grow");
        this.add((Component)jPanel, "grow,newline");
        this.d = new ComboGroupTreeExplorer();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("ComboItemExplorer.12"));
        this.d.setBorder(BorderFactory.createCompoundBorder(titledBorder, new EmptyBorder(7, 7, 0, 7)));
        this.add((Component)this.d, "grow, newline");
    }

    private void a(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        this.c.setModifiablePriceForComboItem(jCheckBox.isSelected());
    }

    private void b(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        this.c.setEnableComboQuantitySelection(jCheckBox.isSelected());
    }

    public void setMenuItem(MenuItem menuItem) {
        this.c = menuItem;
        this.b();
    }

    private void b() {
        this.b.setItems(this.c.getComboItems());
        this.d.setMenuItem(this.c);
        this.f.setSelected(this.c.isEnableComboQuantitySelection());
        this.e.setSelected(this.c.isModifiablePriceForComboItem());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.c();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(Messages.getString("ComboItemExplorer.8"));
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(comboItem);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(n, comboItem);
        }
    }

    private void c() {
        try {
            MenuItem menuItem;
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.setShowVariant(true);
            menuItemSelectionDialog.setShowComboItem(false);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (ComboItem iterator2 : this.b.getItems()) {
                arrayList.add(iterator2.getMenuItem());
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                menuItem = (MenuItem)iterator.next();
                if (!this.c.equals(menuItem)) continue;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CannotAddParentItem"));
                return;
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                menuItem = (MenuItem)iterator2.next();
                if (arrayList == null || arrayList.contains(menuItem)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setMenuItem(menuItem);
                comboItem.setQuantity(1.0);
                this.b.addComboItem(comboItem);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboItem comboItem) {
        try {
            ComboItemEntryDialog comboItemEntryDialog = new ComboItemEntryDialog();
            comboItemEntryDialog.setComboItemTitle(comboItem.getName());
            comboItemEntryDialog.setQuantity(comboItem.getQuantity());
            comboItemEntryDialog.open();
            if (comboItemEntryDialog.isCanceled()) {
                return;
            }
            comboItem.setQuantity(comboItemEntryDialog.getQuantity());
            this.b.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.b.deleteItem(comboItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<ComboItem> getSelectedComboItems() {
        return this.b.getItems();
    }

    public List<ComboGroup> getSelectedComboGroups() {
        return this.d.getGroups();
    }

    private class ComboItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("ComboItemExplorer.9"), Messages.getString("ComboItemExplorer.10"), Messages.getString("ComboItemExplorer.11") + " (" + CurrencyUtil.getCurrencySymbol() + ")"};
        List<ComboItem> b = new ArrayList<ComboItem>();

        public void setItems(List<ComboItem> list) {
            if (list == null) {
                return;
            }
            this.b.addAll(list);
        }

        public List<ComboItem> getItems() {
            return this.b;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            ComboItem comboItem = this.b.get(n);
            if (comboItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return comboItem.getName();
                }
                case 1: {
                    return NumberUtil.trimDecilamIfNotNeeded(comboItem.getQuantity());
                }
                case 2: {
                    return comboItem.getPrice() * comboItem.getQuantity();
                }
            }
            return null;
        }

        public void addComboItem(ComboItem comboItem) {
            int n = this.b.size();
            this.b.add(comboItem);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteItem(ComboItem comboItem, int n) {
            Iterator<ComboItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                ComboItem comboItem2 = iterator.next();
                if (comboItem.getMenuItem() != comboItem2.getMenuItem()) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public ComboItem getComboItem(int n) {
            return this.b.get(n);
        }
    }
}

